/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.core;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.mylyn.wikitext.confluence.core.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.html.core.HtmlLanguage;
import org.junit.Assert;
import org.junit.Test;

public class ConfluenceLanguageIntegrationTest {
    @Test
    public void htmlToConfluence() {
        this.assertHtmlToConfluence(true);
        this.assertHtmlToConfluence(false);
    }

    private void assertHtmlToConfluence(boolean parseAsDocument) {
        HtmlLanguage htmlLanguage = HtmlLanguage.builder().add(DocumentBuilder.BlockType.PARAGRAPH).add(DocumentBuilder.SpanType.BOLD).name("Test").create();
        MarkupParser parser = new MarkupParser((MarkupLanguage)htmlLanguage);
        StringWriter confluenceOut = new StringWriter();
        DocumentBuilder confuenceBuilder = new ConfluenceLanguage().createDocumentBuilder((Writer)confluenceOut);
        parser.setBuilder(confuenceBuilder);
        parser.parse("<html><body>some text <b>bold here</b> more text</body></html>", parseAsDocument);
        Assert.assertEquals((Object)"some text *bold here* more text\n\n", (Object)((Object)confluenceOut).toString());
    }
}

