/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.core;

import org.eclipse.mylyn.wikitext.confluence.core.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.tests.AbstractMarkupGenerationTest;
import org.junit.Test;

public class ConfluenceCodeBlockTest
extends AbstractMarkupGenerationTest<ConfluenceLanguage> {
    @Override
    protected ConfluenceLanguage createMarkupLanguage() {
        return new ConfluenceLanguage();
    }

    @Test
    public void block() {
        this.assertMarkup("<h1 id=\"aheader\">a header</h1><p>Some text</p><pre class=\"Java code-Java\"><code class=\"Java code-Java\">\npublic class Foo {\n}\n\n</code></pre><p>More text...</p>", "h1. a header\n\nSome text\n{code:language=Java}\npublic class Foo {\n}\n{code}\nMore text...");
    }

    @Test
    public void blockWithTrailingText() {
        this.assertMarkup("<pre><code>some code\n</code></pre><p>more text</p>", "{code}some code{code}more text");
    }

    @Test
    public void blockWithPrecedingText() {
        this.assertMarkup("<p>text</p><pre><code>some code\n</code></pre>", "text{code}some code{code}");
    }

    @Test
    public void blockLanguageJava() {
        this.assertMarkup("<pre class=\"java code-java\"><code class=\"java code-java\">some code\n</code></pre><p>more text</p>", "{code:Java}some code{code}more text");
    }

    @Test
    public void blockWithDoubleSlash() {
        this.assertMarkup("<pre><code>one\\\\two\n</code></pre>", "{code}one\\\\two{code}");
    }
}

