/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.parser.html;

import java.io.IOException;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.AbstractSaxHtmlParser;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.AbstractSaxParserTest;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.HtmlCleaner;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.HtmlParser;
import org.junit.Test;
import org.xml.sax.SAXException;

public class HtmlParserTest
extends AbstractSaxParserTest {
    @Override
    protected AbstractSaxHtmlParser createParser() {
        return new HtmlParser();
    }

    public void testBasicMalformed() throws IOException, SAXException {
        this.performTest("<p>foo<br>bar</p>", "foo\nbar\n\n");
    }

    public void testBasicMalformed2() throws IOException, SAXException {
        this.performTest("<p>foo<p>bar", "foo\n\nbar\n\n");
    }

    @Test
    public void testSignificantWhitespaceNotLost() throws IOException, SAXException {
        String input = "<html><body><p>one <b>two</b> three</p></body></html>";
        this.performTest(input, "one **two** three\n\n");
    }

    @Test
    public void testSignificantWhitespaceNotLost_Clean() throws IOException, SAXException {
        String input = "<html><body><p>one <b>two</b> three</p></body></html>";
        new HtmlCleaner().configure((HtmlParser)this.parser);
        this.performTest(input, "one **two** three\n\n");
    }

    @Test
    public void testParseInvalidHtml() throws IOException, SAXException {
        String input = "</font>one <b>two";
        this.performTest(input, "one **two**\n\n");
    }

    @Test
    public void testParseInvalidHtml_Clean() throws IOException, SAXException {
        String input = "</font>one <b>two";
        new HtmlCleaner().configure((HtmlParser)this.parser);
        this.performTest(input, "one **two**\n\n");
    }

    @Test
    public void testParseWhitespaceCleanup() throws IOException, SAXException {
        String input = "one <b>two </b>three";
        new HtmlCleaner().configure((HtmlParser)this.parser);
        this.performTest(input, "one **two** three\n\n");
    }
}

