/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;

class XmlStreamWriterAdapter
implements XMLStreamWriter {
    private final XmlStreamWriter delegate;

    public XmlStreamWriterAdapter(XmlStreamWriter delegate) {
        this.delegate = (XmlStreamWriter)Preconditions.checkNotNull((Object)delegate, (Object)"Must provide a delegate");
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public String getPrefix(String uri) {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public void setDefaultNamespace(String uri) {
        this.delegate.setDefaultNamespace(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) {
        this.delegate.setPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String localName, String value) {
        this.delegate.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) {
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) {
        this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeCData(String data) {
        this.delegate.writeCData(data);
    }

    @Override
    public void writeCharacters(String text) {
        this.delegate.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) {
        this.delegate.writeCharacters(text, start, len);
    }

    @Override
    public void writeComment(String data) {
        this.delegate.writeComment(data);
    }

    @Override
    public void writeDTD(String dtd) {
        this.delegate.writeDTD(dtd);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) {
        this.delegate.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) {
        this.delegate.writeEmptyElement(localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) {
        this.delegate.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) {
        this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEndDocument() {
        this.delegate.writeEndDocument();
    }

    @Override
    public void writeEndElement() {
        this.delegate.writeEndElement();
    }

    @Override
    public void writeEntityRef(String name) {
        this.delegate.writeEntityRef(name);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) {
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target) {
        this.delegate.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) {
        this.delegate.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeStartDocument() {
        this.delegate.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) {
        this.delegate.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) {
        this.delegate.writeStartDocument(encoding, version);
    }

    @Override
    public void writeStartElement(String localName) {
        this.delegate.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) {
        this.delegate.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) {
        this.delegate.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new NamespaceContext(){

            @Override
            public Iterator<String> getPrefixes(String namespaceUri) {
                String prefix = this.getPrefix(namespaceUri);
                if (prefix == null) {
                    return Iterators.emptyIterator();
                }
                return Collections.singletonList(prefix).iterator();
            }

            @Override
            public String getPrefix(String namespaceUri) {
                return XmlStreamWriterAdapter.this.delegate.getPrefix(namespaceUri);
            }

            @Override
            public String getNamespaceURI(String prefix) {
                return XmlStreamWriterAdapter.this.delegate.getNamespaceURI(prefix);
            }
        };
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)name);
        throw new IllegalArgumentException(name);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        Preconditions.checkNotNull((Object)context);
    }
}

