/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.parser.html;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.DocumentProcessor;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.HtmlParser;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.RemoveEmptySpansProcessor;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.RemoveExcessiveStylesProcessor;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.RepairBrokenCSSColorStylesProcessor;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.WhitespaceCleanupProcessor;
import org.jsoup.nodes.Document;

public class HtmlCleaner {
    private final List<DocumentProcessor> processors = new ArrayList<DocumentProcessor>();

    public HtmlCleaner() {
        this.processors.add(new WhitespaceCleanupProcessor());
        this.processors.add(new RemoveEmptySpansProcessor());
        this.processors.add(new RemoveExcessiveStylesProcessor());
        this.processors.add(new RepairBrokenCSSColorStylesProcessor());
    }

    public void configure(HtmlParser parser) {
        parser.getProcessors().addAll(this.processors);
    }

    public void apply(Document document) {
        for (DocumentProcessor processor : this.processors) {
            processor.process(document);
        }
    }
}

