/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.asciidoc.core.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.mylyn.wikitext.core.parser.markup.ContentState;
import org.eclipse.mylyn.wikitext.core.util.LocationTrackingReader;

public class LookAheadReader {
    private ContentState state;
    private LocationTrackingReader reader;

    public void setContentState(ContentState state) {
        if (this.mustInitReader(state)) {
            this.state = state;
            this.reader = new LocationTrackingReader((Reader)new StringReader(state.getMarkupContent()));
        }
    }

    private boolean mustInitReader(ContentState newState) {
        if (this.state != newState) {
            return true;
        }
        if (this.reader == null) {
            return true;
        }
        return this.reader.getLineNumber() >= this.state.getLineNumber();
    }

    public String lookAhead() {
        int lineNumber = this.state.getLineNumber();
        String nextLine = null;
        while (this.reader.getLineNumber() < lineNumber) {
            try {
                nextLine = this.reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return nextLine;
    }
}

