/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.editors.MultipleTaskHyperlinkDetector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.tests.ui.MockTextViewer;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.AbstractTaskHyperlinkDetector;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class MultipleTaskHyperlinkDetectorTest
extends TestCase {
    protected MockRepositoryConnectorUi connectorUi1;
    protected MockRepositoryConnectorUi connectorUi2;
    protected TaskRepository repository1a;
    protected TaskRepository repository1b;
    protected TaskRepository repository2;

    protected void setUp() throws Exception {
        this.repository1a = new TaskRepository("mock", "http://mockrepository.test1a");
        this.repository1b = new TaskRepository("mock", "http://mockrepository.test1b");
        this.connectorUi1 = new MockRepositoryConnectorUi(){
            private final Pattern HYPERLINK_PATTERN = Pattern.compile("(test \\d+)");

            @Override
            public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int index, int textOffset) {
                ArrayList<TaskHyperlink> links = new ArrayList<TaskHyperlink>();
                Matcher m = this.HYPERLINK_PATTERN.matcher(text);
                while (m.find()) {
                    links.add(new TaskHyperlink((IRegion)new Region(textOffset + m.start(), m.end() - m.start()), repository, m.group()));
                }
                return links.toArray(new IHyperlink[0]);
            }
        };
        this.repository2 = new TaskRepository("mock", "http://mockrepository.test2");
        this.connectorUi2 = new MockRepositoryConnectorUi();
        TasksUi.getRepositoryManager().addRepository(this.repository1a);
        TasksUi.getRepositoryManager().addRepository(this.repository1b);
        TasksUi.getRepositoryManager().addRepository(this.repository2);
    }

    protected IHyperlink[] detect(String text, int start, int length, TaskRepository textViewerRepository) {
        AbstractTaskHyperlinkDetector detector = this.createHyperlinkDetector(textViewerRepository);
        return detector.detectHyperlinks((ITextViewer)new MockTextViewer(text), (IRegion)new Region(start, length), true);
    }

    protected AbstractTaskHyperlinkDetector createHyperlinkDetector(final TaskRepository textViewerRepository) {
        MultipleTaskHyperlinkDetector detector = new MultipleTaskHyperlinkDetector(){

            protected AbstractRepositoryConnectorUi getConnectorUi(TaskRepository repository) {
                if (repository.equals((Object)MultipleTaskHyperlinkDetectorTest.this.repository1a) || repository.equals((Object)MultipleTaskHyperlinkDetectorTest.this.repository1b)) {
                    return MultipleTaskHyperlinkDetectorTest.this.connectorUi1;
                }
                if (repository.equals((Object)MultipleTaskHyperlinkDetectorTest.this.repository2)) {
                    return MultipleTaskHyperlinkDetectorTest.this.connectorUi2;
                }
                return super.getConnectorUi(repository);
            }

            protected TaskRepository getTaskRepository(ITextViewer textViewer) {
                return textViewerRepository;
            }
        };
        return detector;
    }

    public void testSingleRepositoryMatches() {
        IHyperlink[] links = this.detect("test 123 test 456 test 789", 9, 15, this.repository2);
        MultipleTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        MultipleTaskHyperlinkDetectorTest.assertEquals((int)2, (int)links.length);
        MultipleTaskHyperlinkDetectorTest.assertEquals((Object)new Region(14, 3), (Object)links[0].getHyperlinkRegion());
        MultipleTaskHyperlinkDetectorTest.assertEquals((Object)new Region(23, 1), (Object)links[1].getHyperlinkRegion());
        MultipleTaskHyperlinkDetectorTest.assertEquals((Object)this.repository2, (Object)((TaskHyperlink)links[0]).getRepository());
    }

    public void testMultipleRepositoriesMatch() {
        IHyperlink[] links = this.detect("test 123 test 456 test 789", 9, 15, this.repository1a);
        MultipleTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        MultipleTaskHyperlinkDetectorTest.assertEquals((int)4, (int)links.length);
        MultipleTaskHyperlinkDetectorTest.assertEquals((Object)new Region(9, 8), (Object)links[0].getHyperlinkRegion());
        MultipleTaskHyperlinkDetectorTest.assertEquals((Object)new Region(9, 8), (Object)links[2].getHyperlinkRegion());
        MultipleTaskHyperlinkDetectorTest.assertEquals(Arrays.asList(this.repository1a, this.repository1b), Arrays.asList(((TaskHyperlink)links[0]).getRepository(), ((TaskHyperlink)links[2]).getRepository()));
        MultipleTaskHyperlinkDetectorTest.assertEquals((Object)new Region(18, 6), (Object)links[1].getHyperlinkRegion());
        MultipleTaskHyperlinkDetectorTest.assertEquals((Object)new Region(18, 6), (Object)links[3].getHyperlinkRegion());
        MultipleTaskHyperlinkDetectorTest.assertEquals(Arrays.asList(this.repository1a, this.repository1b), Arrays.asList(((TaskHyperlink)links[1]).getRepository(), ((TaskHyperlink)links[3]).getRepository()));
    }
}

