/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskAttributeMapperTest
extends TestCase {
    TaskRepository taskRepository = new TaskRepository("kind", "repository");
    TaskAttributeMapper mapper = new TaskAttributeMapper(this.taskRepository);
    TaskData data = new TaskData(this.mapper, "kind", "repository", "id");

    public void testEqualsCommentId() {
        TaskCommentMapper comment = new TaskCommentMapper();
        comment.setCommentId("commentid");
        comment.setNumber(Integer.valueOf(1));
        TaskAttribute attributeOld = this.data.getRoot().createAttribute("1");
        comment.applyTo(attributeOld);
        TaskAttribute attributeNew = this.data.getRoot().createAttribute("2");
        comment.applyTo(attributeNew);
        TaskAttributeMapperTest.assertTrue((boolean)this.mapper.equals(attributeNew, attributeOld));
        comment.setCommentId("commentid2");
        comment.applyTo(attributeOld);
        TaskAttributeMapperTest.assertFalse((String)("Expected not equals:\n" + attributeOld + "\n" + attributeNew), (boolean)this.mapper.equals(attributeNew, attributeOld));
    }

    public void testEqualsCommentMylyn37() {
        TaskCommentMapper comment = new TaskCommentMapper();
        comment.setNumber(Integer.valueOf(1));
        TaskAttribute attributeOld = this.data.getRoot().createAttribute("1");
        comment.applyTo(attributeOld);
        attributeOld.setValue("1");
        TaskAttribute attributeNew = this.data.getRoot().createAttribute("2");
        comment.applyTo(attributeNew);
        TaskAttributeMapperTest.assertEquals((String)"", (String)attributeNew.getValue());
        TaskAttributeMapperTest.assertTrue((String)("Expected equals:\n" + attributeOld + "\n" + attributeNew), (boolean)this.mapper.equals(attributeNew, attributeOld));
        TaskAttributeMapperTest.assertFalse((String)("Expected not equals:\n" + attributeOld + "\n" + attributeNew), (boolean)this.mapper.equals(attributeOld, attributeNew));
    }

    public void testEqualsCommentMylyn37CommentId() {
        TaskCommentMapper comment = new TaskCommentMapper();
        comment.setNumber(Integer.valueOf(1));
        comment.setCommentId("2");
        TaskAttribute attributeOld = this.data.getRoot().createAttribute("1");
        comment.applyTo(attributeOld);
        attributeOld.setValue("1");
        TaskAttribute attributeNew = this.data.getRoot().createAttribute("2");
        comment.applyTo(attributeNew);
        TaskAttributeMapperTest.assertEquals((String)"2", (String)attributeNew.getValue());
        TaskAttributeMapperTest.assertFalse((String)("Expected not equals:\n" + attributeOld + "\n" + attributeNew), (boolean)this.mapper.equals(attributeNew, attributeOld));
        TaskAttribute idAttribute = attributeOld.createAttribute("task.common.comment.id");
        idAttribute.setValue("2");
        TaskAttributeMapperTest.assertTrue((String)("Expected equals:\n" + attributeOld + "\n" + attributeNew), (boolean)this.mapper.equals(attributeNew, attributeOld));
        idAttribute.setValue("3");
        TaskAttributeMapperTest.assertFalse((String)("Expected not equals:\n" + attributeOld + "\n" + attributeNew), (boolean)this.mapper.equals(attributeNew, attributeOld));
    }

    public void testGetValueLabels() throws Exception {
        TaskAttributeMapper mapper = this.mapperWith2Options();
        TaskAttribute attribute = this.data.getRoot().createAttribute("id");
        TaskAttributeMapperTest.assertEquals((Object)ImmutableList.of(), (Object)mapper.getValueLabels(attribute));
        attribute.setValue("1");
        TaskAttributeMapperTest.assertEquals((Object)ImmutableList.of((Object)"a"), (Object)mapper.getValueLabels(attribute));
        attribute.setValue("2");
        TaskAttributeMapperTest.assertEquals((Object)ImmutableList.of((Object)"b"), (Object)mapper.getValueLabels(attribute));
        attribute = this.data.getRoot().createAttribute("id");
        attribute.addValue("1");
        attribute.addValue("2");
        TaskAttributeMapperTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)mapper.getValueLabels(attribute));
        attribute = this.data.getRoot().createAttribute("id");
        attribute.addValue("2");
        attribute.addValue("1");
        TaskAttributeMapperTest.assertEquals((Object)ImmutableList.of((Object)"b", (Object)"a"), (Object)mapper.getValueLabels(attribute));
    }

    public void testGetValueLabelsUnmappedOption() throws Exception {
        TaskAttributeMapper mapper = this.mapperWith2Options();
        TaskAttribute attribute = this.attributeWithUnmappedOption();
        TaskAttributeMapperTest.assertEquals((Object)ImmutableList.of(), (Object)mapper.getValueLabels(attribute));
        attribute.setValue("1");
        TaskAttributeMapperTest.assertEquals((Object)ImmutableList.of((Object)"a"), (Object)mapper.getValueLabels(attribute));
        attribute.setValue("unMappedOption");
        TaskAttributeMapperTest.assertEquals((Object)ImmutableList.of((Object)"unMappedOptionLabel"), (Object)mapper.getValueLabels(attribute));
        attribute = this.attributeWithUnmappedOption();
        attribute.addValue("unMappedOption");
        attribute.addValue("2");
        TaskAttributeMapperTest.assertEquals((Object)ImmutableList.of((Object)"unMappedOptionLabel", (Object)"b"), (Object)mapper.getValueLabels(attribute));
        attribute = this.attributeWithUnmappedOption();
        attribute.addValue("2");
        attribute.addValue("unMappedOption");
        TaskAttributeMapperTest.assertEquals((Object)ImmutableList.of((Object)"b", (Object)"unMappedOptionLabel"), (Object)mapper.getValueLabels(attribute));
    }

    private TaskAttributeMapper mapperWith2Options() {
        TaskAttributeMapper mapper = new TaskAttributeMapper(this.taskRepository){

            public Map<String, String> getOptions(TaskAttribute attribute) {
                return ImmutableMap.of((Object)"1", (Object)"a", (Object)"2", (Object)"b");
            }
        };
        return mapper;
    }

    private TaskAttribute attributeWithUnmappedOption() {
        TaskAttribute attribute = this.data.getRoot().createAttribute("id");
        attribute.putOption("unMappedOption", "unMappedOptionLabel");
        return attribute;
    }
}

