/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.connector;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositorySettingsPage;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;

public class MockRepositoryConnectorUi
extends AbstractRepositoryConnectorUi {
    private static Pattern HYPERLINK_PATTERN = Pattern.compile("(\\d+)");

    public String getConnectorKind() {
        return "mock";
    }

    public ITaskRepositoryPage getSettingsPage(TaskRepository taskRepository) {
        return new MockRepositorySettingsPage(taskRepository);
    }

    public boolean hasSearchPage() {
        return false;
    }

    public IWizard getQueryWizard(TaskRepository repository, IRepositoryQuery query) {
        return null;
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository, ITaskMapping selection) {
        return null;
    }

    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int index, int textOffset) {
        ArrayList<TaskHyperlink> links = new ArrayList<TaskHyperlink>();
        Matcher m = HYPERLINK_PATTERN.matcher(text);
        while (m.find()) {
            links.add(new TaskHyperlink((IRegion)new Region(textOffset + m.start(), m.end() - m.start()), repository, m.group()));
        }
        return links.toArray(new IHyperlink[0]);
    }
}

