/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.ITaskRepositoryFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;

public class TaskRepositoryFilterTests
extends TestCase {
    public void testCanCreateTaskFilter() {
        ITaskRepositoryFilter canCreateTaskFilter = ITaskRepositoryFilter.CAN_CREATE_NEW_TASK;
        TaskRepository repository = new TaskRepository("mock", "http://mockrepository.test");
        MockRepositoryConnector connector = (MockRepositoryConnector)TasksUiPlugin.getConnector((String)"mock");
        TaskRepositoryFilterTests.assertFalse((boolean)canCreateTaskFilter.accept(repository, (AbstractRepositoryConnector)connector));
        connector.setCanCreateNewTask(true);
        TaskRepositoryFilterTests.assertTrue((boolean)canCreateTaskFilter.accept(repository, (AbstractRepositoryConnector)connector));
        repository.setOffline(true);
        TaskRepositoryFilterTests.assertFalse((boolean)canCreateTaskFilter.accept(repository, (AbstractRepositoryConnector)connector));
        connector.resetDefaults();
    }

    public void testCanQueryTaskFilter() {
        ITaskRepositoryFilter canQueryFilter = ITaskRepositoryFilter.CAN_QUERY;
        TaskRepository repository = new TaskRepository("mock", "http://mockrepository.test");
        MockRepositoryConnector connector = (MockRepositoryConnector)TasksUiPlugin.getConnector((String)"mock");
        TaskRepositoryFilterTests.assertFalse((boolean)canQueryFilter.accept(repository, (AbstractRepositoryConnector)connector));
        repository = new TaskRepository("local", "local");
        AbstractRepositoryConnector localConnector = TasksUiPlugin.getConnector((String)"local");
        TaskRepositoryFilterTests.assertFalse((boolean)canQueryFilter.accept(repository, localConnector));
        connector.setCanQuery(true);
        TaskRepositoryFilterTests.assertTrue((boolean)canQueryFilter.accept(repository, (AbstractRepositoryConnector)connector));
        repository.setOffline(true);
        TaskRepositoryFilterTests.assertFalse((boolean)canQueryFilter.accept(repository, (AbstractRepositoryConnector)connector));
        connector.resetDefaults();
    }

    public void testCanCreateTaskFromKeyTaskFilter() {
        ITaskRepositoryFilter canCreateTaskFromKeyFilter = ITaskRepositoryFilter.CAN_CREATE_TASK_FROM_KEY;
        TaskRepository repository = new TaskRepository("mock", "http://mockrepository.test");
        MockRepositoryConnector connector = (MockRepositoryConnector)TasksUiPlugin.getConnector((String)"mock");
        TaskRepositoryFilterTests.assertFalse((boolean)canCreateTaskFromKeyFilter.accept(repository, (AbstractRepositoryConnector)connector));
        connector.setCanCreateTaskFromKey(true);
        TaskRepositoryFilterTests.assertTrue((boolean)canCreateTaskFromKeyFilter.accept(repository, (AbstractRepositoryConnector)connector));
        repository.setOffline(true);
        TaskRepositoryFilterTests.assertFalse((boolean)canCreateTaskFromKeyFilter.accept(repository, (AbstractRepositoryConnector)connector));
        connector.resetDefaults();
    }
}

