/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.reviews.ui.compare.FileItemNode;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewItemCompareEditorInput;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.swt.widgets.Composite;

public class ReviewItemSetCompareEditorInput
extends ReviewItemCompareEditorInput {
    private final IReviewItemSet items;
    private DiffNode root;

    public ReviewItemSetCompareEditorInput(CompareConfiguration configuration, IReviewItemSet items, IFileItem selection, ReviewBehavior behavior) {
        super(configuration, behavior);
        this.items = items;
        this.setTitle(items.getName());
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.root != null) {
            return this.root;
        }
        this.root = new DiffNode(0);
        for (IReviewItem item : this.items.getItems()) {
            if (!(item instanceof IFileItem)) continue;
            FileItemNode node = new FileItemNode(this.behavior, (IFileItem)item, monitor);
            DiffNode parent = this.findNode(this.root, node.getPath());
            parent.add((IDiffElement)node);
        }
        IDiffElement[] iDiffElementArray = this.root.getChildren();
        int n = iDiffElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement child = iDiffElementArray[n2];
            if (child instanceof FileItemNode) {
                this.flattenTree((FileItemNode)child);
            }
            ++n2;
        }
        return this.root;
    }

    private void flattenTree(FileItemNode node) {
        this.mergeChild(node);
        IDiffElement[] iDiffElementArray = node.getChildren();
        int n = iDiffElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement child = iDiffElementArray[n2];
            if (child instanceof FileItemNode) {
                this.flattenTree((FileItemNode)child);
            }
            ++n2;
        }
    }

    public void mergeChild(FileItemNode node) {
        if (node.getChildren().length == 1 && this.isDirectory(node.getChildren()[0])) {
            FileItemNode child = (FileItemNode)node.getChildren()[0];
            node.setName(String.valueOf(node.getName()) + "/" + child.getName());
            node.remove((IDiffElement)child);
            IDiffElement[] iDiffElementArray = child.getChildren();
            int n = iDiffElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffElement element = iDiffElementArray[n2];
                node.add(element);
                ++n2;
            }
            this.mergeChild(node);
        }
    }

    private boolean isDirectory(IDiffElement element) {
        return element instanceof FileItemNode && ((FileItemNode)element).getFileItem() == null;
    }

    private DiffNode findNode(DiffNode root, IPath path) {
        if (path.segmentCount() == 1) {
            return root;
        }
        String name = path.segment(0);
        IDiffElement child = root.findChild(name);
        if (child instanceof DiffNode) {
            return this.findNode((DiffNode)child, path.removeFirstSegments(1));
        }
        FileItemNode node = new FileItemNode(name);
        root.add((IDiffElement)node);
        return this.findNode(node, path.removeFirstSegments(1));
    }

    @Override
    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer contentViewer = super.findContentViewer(oldViewer, input, parent);
        if (input instanceof FileItemNode && ((FileItemNode)input).getFileItem() != null) {
            this.getCompareConfiguration().setLabelProvider(input, ((FileItemNode)input).getLabelProvider());
        }
        return contentViewer;
    }

    protected void updateViewerConfig(Viewer aContentViewer, FileItemNode input) {
        if (aContentViewer instanceof TextMergeViewer) {
            TextMergeViewer textMergeViewer = (TextMergeViewer)aContentViewer;
            try {
                Class<TextMergeViewer> clazz = TextMergeViewer.class;
                Field declaredField = clazz.getDeclaredField("isConfigured");
                declaredField.setAccessible(true);
                declaredField.setBoolean(textMergeViewer, false);
                Method declaredMethod = clazz.getDeclaredMethod("updateContent", Object.class, Object.class, Object.class);
                declaredMethod.setAccessible(true);
                declaredMethod.invoke((Object)textMergeViewer, null, input.getLeft(), input.getRight());
            }
            catch (Throwable throwable) {}
        }
    }
}

