/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mylyn.gerrit.dashboard.GerritPlugin;
import org.eclipse.mylyn.gerrit.dashboard.ui.GerritUi;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTemplateManager;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class GerritServerUtility {
    private static final String LAST_GERRIT_FILE = "lastGerrit.txt";
    private static final String LAST_COMMANDS_FILE = "lastCommands.txt";
    private final String ECLIPSE_GERRIT_DEFAULT = "https://git.eclipse.org/r/";
    private final String SLASH = "/";
    private static GerritServerUtility fInstance = null;
    private Map<TaskRepository, String> fResultTask = new HashMap<TaskRepository, String>();

    protected GerritServerUtility() {
        fInstance = this;
    }

    private void adjustTemplatemanager(TaskRepository aTaskRepo) {
        RepositoryTemplateManager templateManager = TasksUiPlugin.getRepositoryTemplateManager();
        Boolean found = false;
        for (RepositoryTemplate template : templateManager.getTemplates("org.eclipse.mylyn.gerrit")) {
            String convertedRemoteURL = aTaskRepo.getRepositoryUrl();
            GerritPlugin.Ftracer.traceInfo("\t template.label: " + template.label + "\t repo label: " + aTaskRepo.getRepositoryLabel() + " repo getname: " + convertedRemoteURL);
            if (!template.label.equals(aTaskRepo.getRepositoryLabel()) && !template.repositoryUrl.equals(convertedRemoteURL)) continue;
            found = true;
            break;
        }
        if (!found.booleanValue()) {
            String userName = aTaskRepo.getUserName();
            Boolean anonymous = userName == null || userName.isEmpty();
            RepositoryTemplate templateTest = new RepositoryTemplate(aTaskRepo.getRepositoryLabel(), aTaskRepo.getRepositoryUrl(), aTaskRepo.getCharacterEncoding(), aTaskRepo.getVersion(), "", "", "", aTaskRepo.getUserName(), anonymous.booleanValue(), true);
            Map attributes = aTaskRepo.getProperties();
            Set value = attributes.entrySet();
            for (Map.Entry entry : value) {
                templateTest.addAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            templateManager.addTemplate("org.eclipse.mylyn.gerrit", templateTest);
        }
    }

    private void printRepositoryTemplate() {
        RepositoryTemplateManager templateManager = TasksUiPlugin.getRepositoryTemplateManager();
        if (templateManager != null) {
            for (RepositoryTemplate template : templateManager.getTemplates("org.eclipse.mylyn.gerrit")) {
                GerritPlugin.Ftracer.traceInfo("------------======================------------------");
                Set value = template.getAttributes().entrySet();
                if (value == null) continue;
                for (Map.Entry entry : value) {
                    GerritPlugin.Ftracer.traceInfo("key: " + (String)entry.getKey() + "\tvalue: " + (String)entry.getValue());
                }
            }
        }
    }

    private File getLastGerritFile(String aFile) {
        IPath ipath = GerritPlugin.getDefault().getStateLocation();
        String fileName = ipath.append(aFile).toPortableString();
        File file = new File(fileName);
        return file;
    }

    private URL buildDocumentationURL(String aRequest) throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        String lastSaved = GerritServerUtility.getInstance().getLastSavedGerritServer();
        if (lastSaved == null) {
            lastSaved = "https://git.eclipse.org/r/";
        }
        if (!lastSaved.endsWith("/")) {
            lastSaved = lastSaved.concat("/");
        }
        sb.append(lastSaved);
        sb.append(aRequest);
        return new URL(sb.toString());
    }

    private String getEditorId(URL aUrl) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(aUrl.getFile());
        String id = null;
        if (desc != null) {
            id = desc.getId();
        }
        return id;
    }

    public static GerritServerUtility getInstance() {
        if (fInstance == null) {
            new GerritServerUtility();
        }
        return fInstance;
    }

    public Map<TaskRepository, String> getGerritMapping() {
        if (this.fResultTask == null) {
            this.fResultTask = new HashMap<TaskRepository, String>();
        }
        this.fResultTask.clear();
        TaskRepositoryManager repositoryManager = TasksUiPlugin.getRepositoryManager();
        if (repositoryManager != null) {
            GerritPlugin.Ftracer.traceInfo("--------Review repo ---------------");
            Set reviewRepo = repositoryManager.getRepositories("org.eclipse.mylyn.gerrit");
            if (reviewRepo != null) {
                for (TaskRepository taskRepo : reviewRepo) {
                    GerritPlugin.Ftracer.traceInfo("Add Gerrit Review repo: " + taskRepo.getRepositoryLabel() + "\t url: " + taskRepo.getRepositoryUrl());
                    this.fResultTask.put(taskRepo, taskRepo.getRepositoryUrl());
                    if (taskRepo.getRepositoryUrl() == null) continue;
                    this.adjustTemplatemanager(taskRepo);
                }
            }
            this.printRepositoryTemplate();
        }
        return this.fResultTask;
    }

    public Boolean saveLastGerritServer(String aURL) {
        Boolean ok = true;
        File file = this.getLastGerritFile(LAST_GERRIT_FILE);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fw);
            out.write(aURL);
            out.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            ok = false;
        }
        return ok;
    }

    public String getLastSavedGerritServer() {
        String lastGerritURL = null;
        File file = this.getLastGerritFile(LAST_GERRIT_FILE);
        if (file != null) {
            try {
                FileReader fr = new FileReader(file);
                BufferedReader in = new BufferedReader(fr);
                lastGerritURL = in.readLine();
                in.close();
            }
            catch (IOException iOException) {}
        }
        return lastGerritURL;
    }

    public String getMenuSelectionURL(String aSt) {
        String urlStr = null;
        this.fResultTask = this.getGerritMapping();
        if (!this.fResultTask.isEmpty()) {
            Set<TaskRepository> mapSet = this.fResultTask.keySet();
            GerritPlugin.Ftracer.traceInfo("-------------------");
            for (TaskRepository key : mapSet) {
                if (!key.getRepositoryLabel().equals(aSt)) continue;
                urlStr = this.fResultTask.get(key);
                GerritPlugin.Ftracer.traceInfo("Map Key: " + key.getRepositoryLabel() + "\t URL: " + this.fResultTask.get(key));
                return urlStr;
            }
        }
        return urlStr;
    }

    public TaskRepository getTaskRepo(String aStURL) {
        this.fResultTask = this.getGerritMapping();
        if (aStURL != null && !this.fResultTask.isEmpty()) {
            Set<TaskRepository> mapSet = this.fResultTask.keySet();
            GerritPlugin.Ftracer.traceInfo("-------------------");
            for (TaskRepository key : mapSet) {
                if (!key.getRepositoryUrl().equals(aStURL)) continue;
                GerritPlugin.Ftracer.traceInfo("Key label : " + key.getRepositoryLabel() + "\t URL: " + this.fResultTask.get(key));
                return key;
            }
        }
        return null;
    }

    public void openWebBrowser(String aDocumentation) {
        if (fInstance == null) {
            fInstance = GerritServerUtility.getInstance();
        }
        IWorkbenchBrowserSupport workBenchSupport = PlatformUI.getWorkbench().getBrowserSupport();
        URL url = null;
        try {
            url = this.buildDocumentationURL(aDocumentation);
            try {
                String id = this.getEditorId(url);
                workBenchSupport.createBrowser(id).openURL(url);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        GerritUi.Ftracer.traceInfo("openWebBrowser for " + url);
    }

    public Boolean saveLastCommandList(Set<String> aCommands) {
        Boolean ok = true;
        File file = this.getLastGerritFile(LAST_COMMANDS_FILE);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fw);
            for (String s : aCommands) {
                out.write(s);
                out.newLine();
            }
            out.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            ok = false;
        }
        return ok;
    }

    public Set<String> getListLastCommands() {
        LinkedHashSet<String> lastCommands = new LinkedHashSet<String>();
        File file = this.getLastGerritFile(LAST_COMMANDS_FILE);
        if (file != null) {
            try {
                FileReader fr = new FileReader(file);
                BufferedReader in = new BufferedReader(fr);
                while (in.ready()) {
                    String line = in.readLine();
                    lastCommands.add(line);
                }
                in.close();
            }
            catch (IOException iOException) {}
        }
        return lastCommands;
    }
}

