/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeMapper;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class RepositoryConfigurationTest
extends TestCase {
    private static final String PRODUCT = "product";
    RepositoryConfiguration cfg;

    protected void setUp() throws Exception {
        this.cfg = new RepositoryConfiguration();
        this.cfg.addProduct(PRODUCT);
    }

    public void testGetUnconfirmedAllowed_product() throws Exception {
        RepositoryConfigurationTest.assertFalse((boolean)this.cfg.getUnconfirmedAllowed(PRODUCT));
    }

    public void testGetUnconfirmedAllowed_productFalse() throws Exception {
        this.cfg.addUnconfirmedAllowed(PRODUCT, Boolean.FALSE);
        RepositoryConfigurationTest.assertFalse((boolean)this.cfg.getUnconfirmedAllowed(PRODUCT));
    }

    public void testGetUnconfirmedAllowed_productNull() throws Exception {
        this.cfg.addUnconfirmedAllowed(PRODUCT, null);
        RepositoryConfigurationTest.assertFalse((boolean)this.cfg.getUnconfirmedAllowed(PRODUCT));
    }

    public void testGetUnconfirmedAllowed_productTrue() throws Exception {
        this.cfg.addUnconfirmedAllowed(PRODUCT, Boolean.TRUE);
        RepositoryConfigurationTest.assertTrue((boolean)this.cfg.getUnconfirmedAllowed(PRODUCT));
    }

    public void testGetUnconfirmedAllowed_noProduct() throws Exception {
        RepositoryConfigurationTest.assertFalse((boolean)this.cfg.getUnconfirmedAllowed("no-product"));
    }

    public void testGetAttributeOptions() throws Exception {
        TaskRepository repository = new TaskRepository("bugzilla", "http://repository");
        BugzillaAttributeMapper mapper = new BugzillaAttributeMapper(repository, BugzillaFixture.current().connector());
        TaskData taskData = new TaskData((TaskAttributeMapper)mapper, repository.getConnectorKind(), repository.getRepositoryUrl(), "");
        this.cfg.addItem(BugzillaAttribute.REP_PLATFORM, "3");
        this.cfg.addItem(BugzillaAttribute.REP_PLATFORM, "2");
        this.cfg.addItem(BugzillaAttribute.REP_PLATFORM, "1");
        List options = this.cfg.getAttributeOptions(PRODUCT, taskData.getRoot().createAttribute(BugzillaAttribute.REP_PLATFORM.getKey()));
        RepositoryConfigurationTest.assertEquals((int)3, (int)options.size());
        RepositoryConfigurationTest.assertEquals((String)"1", (String)((String)options.get(0)));
        RepositoryConfigurationTest.assertEquals((String)"2", (String)((String)options.get(1)));
        RepositoryConfigurationTest.assertEquals((String)"3", (String)((String)options.get(2)));
    }
}

