/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.IOperation;
import org.eclipse.mylyn.builds.internal.core.BuildPackage;
import org.eclipse.mylyn.builds.internal.core.StringToStringMap;

public abstract class BuildElement
extends EObjectImpl
implements IBuildElement {
    protected static final String URL_EDEFAULT = null;
    protected String url = URL_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<IOperation> operations;
    protected static final IStatus ELEMENT_STATUS_EDEFAULT = null;
    protected IStatus elementStatus = ELEMENT_STATUS_EDEFAULT;
    protected static final Date REFRESH_DATE_EDEFAULT = null;
    protected Date refreshDate = REFRESH_DATE_EDEFAULT;
    protected EMap<String, String> attributes;
    protected BuildElement original;

    protected BuildElement() {
    }

    protected EClass eStaticClass() {
        return BuildPackage.Literals.BUILD_ELEMENT;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String newUrl) {
        String oldUrl = this.url;
        this.url = newUrl;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldUrl, (Object)this.url));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public List<IOperation> getOperations() {
        if (this.operations == null) {
            this.operations = new EDataTypeUniqueEList(IOperation.class, (InternalEObject)this, 2);
        }
        return this.operations;
    }

    @Override
    public IStatus getElementStatus() {
        return this.elementStatus;
    }

    @Override
    public void setElementStatus(IStatus newElementStatus) {
        IStatus oldElementStatus = this.elementStatus;
        this.elementStatus = newElementStatus;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldElementStatus, (Object)this.elementStatus));
        }
    }

    @Override
    public Date getRefreshDate() {
        return this.refreshDate;
    }

    @Override
    public void setRefreshDate(Date newRefreshDate) {
        Date oldRefreshDate = this.refreshDate;
        this.refreshDate = newRefreshDate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldRefreshDate, (Object)this.refreshDate));
        }
    }

    @Override
    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new EcoreEMap(BuildPackage.Literals.STRING_TO_STRING_MAP, StringToStringMap.class, (InternalEObject)this, 5);
        }
        return this.attributes.map();
    }

    @Override
    public abstract String getLabel();

    @Override
    public abstract IBuildServer getServer();

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)((EMap.InternalMapView)this.getAttributes()).eMap()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getUrl();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getOperations();
            }
            case 3: {
                return this.getElementStatus();
            }
            case 4: {
                return this.getRefreshDate();
            }
            case 5: {
                if (coreType) {
                    return ((EMap.InternalMapView)this.getAttributes()).eMap();
                }
                return this.getAttributes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setUrl((String)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.getOperations().clear();
                this.getOperations().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setElementStatus((IStatus)newValue);
                return;
            }
            case 4: {
                this.setRefreshDate((Date)newValue);
                return;
            }
            case 5: {
                ((EStructuralFeature.Setting)((EMap.InternalMapView)this.getAttributes()).eMap()).set(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setUrl(URL_EDEFAULT);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.getOperations().clear();
                return;
            }
            case 3: {
                this.setElementStatus(ELEMENT_STATUS_EDEFAULT);
                return;
            }
            case 4: {
                this.setRefreshDate(REFRESH_DATE_EDEFAULT);
                return;
            }
            case 5: {
                this.getAttributes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return URL_EDEFAULT == null ? this.url != null : !URL_EDEFAULT.equals(this.url);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.operations != null && !this.operations.isEmpty();
            }
            case 3: {
                return ELEMENT_STATUS_EDEFAULT == null ? this.elementStatus != null : !ELEMENT_STATUS_EDEFAULT.equals(this.elementStatus);
            }
            case 4: {
                return REFRESH_DATE_EDEFAULT == null ? this.refreshDate != null : !REFRESH_DATE_EDEFAULT.equals(this.refreshDate);
            }
            case 5: {
                return this.attributes != null && !this.attributes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (url: ");
        result.append(this.url);
        result.append(", name: ");
        result.append(this.name);
        result.append(", operations: ");
        result.append(this.operations);
        result.append(", elementStatus: ");
        result.append(this.elementStatus);
        result.append(", refreshDate: ");
        result.append(this.refreshDate);
        result.append(')');
        return result.toString();
    }

    public BuildElement getOriginal() {
        return this.original;
    }

    public BuildElement createWorkingCopy() {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        BuildElement newElement = (BuildElement)copier.copy((EObject)this);
        copier.copyReferences();
        newElement.original = this;
        return newElement;
    }
}

