/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.client;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.trac.core.client.InvalidTicketException;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.util.TracUtil;

public class TracTicketTest
extends TestCase {
    public void testValid() {
        TracTicket ticket = new TracTicket();
        TracTicketTest.assertFalse((boolean)ticket.isValid());
        ticket.setId(1);
        TracTicketTest.assertTrue((boolean)ticket.isValid());
    }

    public void testPutTracValue() throws InvalidTicketException {
        TracTicket ticket = new TracTicket(1);
        ticket.putValue("summary", "a");
        TracTicketTest.assertEquals((String)"a", (String)ticket.getValue(TracTicket.Key.SUMMARY));
        TracTicketTest.assertEquals(null, (String)ticket.getCustomValue("summary"));
        TracTicketTest.assertEquals(null, (String)ticket.getCustomValue("a"));
        ticket.putValue("summary", "b");
        ticket.putValue("custom", "c");
        TracTicketTest.assertEquals((String)"b", (String)ticket.getValue(TracTicket.Key.SUMMARY));
        TracTicketTest.assertEquals(null, (String)ticket.getCustomValue("summary"));
        TracTicketTest.assertEquals((String)"c", (String)ticket.getCustomValue("custom"));
    }

    public void testPutTracValueId() throws InvalidTicketException {
        TracTicket ticket = new TracTicket();
        TracTicketTest.assertFalse((boolean)ticket.putValue("id", "1"));
    }

    public void testSetCreated() throws InvalidTicketException {
        TracTicket ticket = new TracTicket(1);
        ticket.setCreated(TracUtil.parseDate((long)0L));
        TracTicketTest.assertEquals((long)(TimeZone.getTimeZone("GMT").getOffset(0L) * 1000), (long)ticket.getCreated().getTime());
        Date date = new Date();
        Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utc.setTime(date);
        ticket.setCreated(TracUtil.parseDate((long)((int)(utc.getTimeInMillis() / 1000L))));
        TracTicketTest.assertEquals((long)(date.getTime() / 1000L), (long)(ticket.getCreated().getTime() / 1000L));
    }
}

