/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.spi.editor;

import java.io.File;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.spi.ReviewsConnector;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfObserver;
import org.eclipse.mylyn.reviews.core.spi.remote.review.IReviewRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.spi.edit.remote.AbstractRemoteEditFactoryProvider;
import org.eclipse.mylyn.reviews.spi.edit.remote.review.ReviewsRemoteEditFactoryProvider;
import org.eclipse.mylyn.reviews.ui.spi.editor.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public abstract class AbstractReviewTaskEditorPage
extends AbstractTaskEditorPage {
    private RemoteEmfConsumer<IRepository, IReview, String, ?, ?, Date> reviewConsumer;
    private final RemoteEmfObserver<IRepository, IReview, String, Date> reviewObserver = new RemoteEmfObserver<IRepository, IReview, String, Date>(){

        public void updating() {
            AbstractReviewTaskEditorPage.this.updateMessage();
        }

        public void updated(boolean modified) {
            AbstractReviewTaskEditorPage.this.updateMessage();
        }
    };

    public AbstractReviewTaskEditorPage(TaskEditor editor, String id, String label, String connectorKind) {
        super(editor, id, label, connectorKind);
    }

    public void init(IEditorSite site, IEditorInput input) {
        AbstractReviewTaskEditorPage.super.init(site, input);
        this.checkIfModelIsCached();
        this.reviewConsumer = this.getFactoryProvider().getReviewFactory().getConsumerForLocalKey((EObject)this.getFactoryProvider().getRoot(), (Object)this.getTask().getTaskId());
        this.reviewConsumer.addObserver(this.reviewObserver);
        this.reviewConsumer.open();
        if (this.reviewConsumer.getRemoteObject() == null) {
            this.reviewConsumer.retrieve(false);
        }
    }

    private void checkIfModelIsCached() {
        AbstractRemoteEditFactoryProvider factoryProvider = (AbstractRemoteEditFactoryProvider)this.getFactoryProvider();
        String reviewPath = factoryProvider.getDataLocator().getFilePath(factoryProvider.getContainerSegment(), "Review", this.getTask().getTaskId(), "reviews").toOSString();
        if (!new File(reviewPath).exists()) {
            this.getTaskEditor().setMessage(org.eclipse.mylyn.internal.tasks.ui.editors.Messages.AbstractTaskEditorPage_Synchronize_to_retrieve_task_data, 2, (IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    SynchronizeEditorAction synchronizeEditorAction = new SynchronizeEditorAction();
                    synchronizeEditorAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)AbstractReviewTaskEditorPage.this.getTaskEditor()));
                    if (synchronizeEditorAction != null) {
                        synchronizeEditorAction.run();
                    }
                }
            });
        }
    }

    public void refresh() {
        super.refresh();
        this.updateMessage();
    }

    private void updateMessage() {
        if (!this.reviewConsumer.getStatus().isOK()) {
            this.getTaskEditor().setMessage(org.eclipse.mylyn.internal.tasks.ui.editors.Messages.AbstractTaskEditorPage_Error_opening_task, 3, (IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    TasksUiInternal.displayStatus((String)org.eclipse.mylyn.internal.tasks.ui.editors.Messages.AbstractTaskEditorPage_Open_failed, (IStatus)AbstractReviewTaskEditorPage.this.reviewConsumer.getStatus());
                }
            });
        }
    }

    public IReviewRemoteFactoryProvider getFactoryProvider() {
        TaskRepository repository = this.getTaskEditor().getTaskEditorInput().getTaskRepository();
        ReviewsConnector connector = (ReviewsConnector)TasksUi.getRepositoryConnector((String)repository.getConnectorKind());
        return (IReviewRemoteFactoryProvider)connector.getReviewClient(repository).getFactoryProvider();
    }

    public void dispose() {
        IReviewRemoteFactoryProvider provider = this.getFactoryProvider();
        if (provider instanceof ReviewsRemoteEditFactoryProvider) {
            ReviewsRemoteEditFactoryProvider reviewsProvider = (ReviewsRemoteEditFactoryProvider)provider;
            reviewsProvider.save((EObject)this.getReview());
            this.reviewObserver.dispose();
        }
        super.dispose();
    }

    public IReview getReview() {
        return (IReview)this.reviewConsumer.getModelObject();
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new Action(Messages.AbstractReviewTaskEditorPage_Show_Review_Navigator, ReviewsImages.REVIEW){

            public void run() {
                WorkbenchUtil.showViewInActiveWindow((String)"org.eclipse.mylyn.reviews.Explorer");
            }
        });
        super.fillToolBar(toolBarManager);
    }
}

