/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.mylyn.internal.tasks.ui.BrandManager;
import org.eclipse.mylyn.internal.tasks.ui.ConnectorBrand;
import org.eclipse.mylyn.internal.tasks.ui.IBrandManager;
import org.eclipse.mylyn.internal.tasks.ui.wizards.SelectRepositoryConnectorPage;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ConnectorBrandContentProviderTest {
    @Test
    public void testGetElementsNoConnectors() {
        ImmutableList connectors = ImmutableList.of();
        BrandManager brandManager = (BrandManager)Mockito.mock(BrandManager.class);
        SelectRepositoryConnectorPage.ConnectorBrandContentProvider provider = new SelectRepositoryConnectorPage.ConnectorBrandContentProvider((IBrandManager)brandManager, (Collection)connectors);
        Assert.assertEquals((long)0L, (long)provider.getElements(null).length);
    }

    @Test
    public void testGetElementsMultipleConnectors() {
        MockRepositoryConnector cantCreateRepository = this.mockConnector("cantCreateRepository");
        Mockito.when((Object)cantCreateRepository.canCreateRepository()).thenReturn((Object)false);
        MockRepositoryConnector notUserManaged = this.mockConnector("notUserManaged");
        Mockito.when((Object)notUserManaged.isUserManaged()).thenReturn((Object)false);
        MockRepositoryConnector c1 = this.mockConnector("c1");
        MockRepositoryConnector c2 = this.mockConnector("c2");
        MockRepositoryConnector c3 = this.mockConnector("c3");
        ImmutableList connectors = ImmutableList.of((Object)c1, (Object)c2, (Object)notUserManaged, (Object)cantCreateRepository, (Object)c3);
        BrandManager brandManager = (BrandManager)Mockito.mock(BrandManager.class);
        SelectRepositoryConnectorPage.ConnectorBrandContentProvider provider = new SelectRepositoryConnectorPage.ConnectorBrandContentProvider((IBrandManager)brandManager, (Collection)connectors);
        this.assertBrands(provider, new ConnectorBrand((AbstractRepositoryConnector)c1, null), new ConnectorBrand((AbstractRepositoryConnector)c2, null), new ConnectorBrand((AbstractRepositoryConnector)c3, null));
        Mockito.when((Object)brandManager.getBrands(c1.getConnectorKind())).thenReturn((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        Mockito.when((Object)brandManager.getBrands(c2.getConnectorKind())).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)brandManager.getBrands(c3.getConnectorKind())).thenReturn((Object)ImmutableList.of((Object)"d"));
        this.assertBrands(provider, new ConnectorBrand((AbstractRepositoryConnector)c1, null), new ConnectorBrand((AbstractRepositoryConnector)c1, "a"), new ConnectorBrand((AbstractRepositoryConnector)c1, "b"), new ConnectorBrand((AbstractRepositoryConnector)c1, "c"), new ConnectorBrand((AbstractRepositoryConnector)c2, null), new ConnectorBrand((AbstractRepositoryConnector)c3, null), new ConnectorBrand((AbstractRepositoryConnector)c3, "d"));
    }

    protected MockRepositoryConnector mockConnector(String kind) {
        MockRepositoryConnector spy = (MockRepositoryConnector)Mockito.spy((Object)new MockRepositoryConnector());
        Mockito.when((Object)spy.getConnectorKind()).thenReturn((Object)kind);
        return spy;
    }

    protected void assertBrands(SelectRepositoryConnectorPage.ConnectorBrandContentProvider provider, ConnectorBrand ... brands) {
        Assert.assertEquals(Arrays.asList(brands), Arrays.asList(provider.getElements(null)));
    }
}

