/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.spi.BuildConnector;
import org.eclipse.mylyn.builds.core.spi.BuildServerBehaviour;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.internal.builds.ui.BuildConnectorDescriptor;

public class BuildConnectorDelegate
extends BuildConnector {
    private IStatus status;
    private BuildConnector core;
    private final BuildConnectorDescriptor descriptor;

    public BuildConnectorDelegate(BuildConnectorDescriptor descriptor) {
        this.descriptor = descriptor;
        this.init(descriptor.connectorKind, descriptor.label);
    }

    public synchronized BuildConnector getCore() throws CoreException {
        if (this.core != null) {
            return this.core;
        }
        if (this.status != null) {
            throw new CoreException(this.status);
        }
        IStatus result = this.descriptor.createCore();
        if (result.isOK()) {
            this.core = this.descriptor.core;
        } else {
            this.status = result;
        }
        if (this.status != null) {
            throw new CoreException(this.status);
        }
        return this.core;
    }

    public BuildServerBehaviour getBehaviour(RepositoryLocation location) throws CoreException {
        return this.getCore().getBehaviour(location);
    }

    public IBuildElement getBuildElementFromUrl(IBuildServer server, String url) {
        try {
            return this.getCore().getBuildElementFromUrl(server, url);
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

