/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;

public class InMemoryCredentialsStore
implements ICredentialsStore {
    static Map<String, InMemoryCredentialsStore> storeById = new HashMap<String, InMemoryCredentialsStore>();
    private final String id;
    private final ICredentialsStore parent;
    private final Map<String, Item> store;
    private final boolean keepRemovedKeys;

    public static synchronized InMemoryCredentialsStore getStore(String id) {
        Assert.isNotNull((Object)id);
        InMemoryCredentialsStore store = storeById.get(id);
        if (store == null) {
            store = new InMemoryCredentialsStore(id);
            storeById.put(id, store);
        }
        return store;
    }

    public InMemoryCredentialsStore() {
        this(null, null, true);
    }

    public InMemoryCredentialsStore(ICredentialsStore parent) {
        this(parent, null, true);
    }

    InMemoryCredentialsStore(ICredentialsStore parent, String id, boolean keepRemovedKeys) {
        this.parent = parent;
        this.id = id;
        this.keepRemovedKeys = keepRemovedKeys;
        this.store = new HashMap<String, Item>();
    }

    InMemoryCredentialsStore(String id) {
        this(null, id, false);
    }

    @Override
    public synchronized void clear() {
        this.store.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(ICredentialsStore target) {
        ICredentialsStore iCredentialsStore = target;
        synchronized (iCredentialsStore) {
            InMemoryCredentialsStore inMemoryCredentialsStore = this;
            synchronized (inMemoryCredentialsStore) {
                for (Map.Entry<String, Item> entry : this.store.entrySet()) {
                    Item item = entry.getValue();
                    if (item != null) {
                        if (item.type == String.class) {
                            target.put(entry.getKey(), (String)item.value, item.encrypted, item.persisted);
                            continue;
                        }
                        if (item.type == byte[].class) {
                            target.putByteArray(entry.getKey(), (byte[])item.value, item.encrypted);
                            continue;
                        }
                        if (item.type != Boolean.TYPE) continue;
                        target.putBoolean(entry.getKey(), (Boolean)item.value, item.encrypted);
                        continue;
                    }
                    target.remove(entry.getKey());
                }
            }
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        Iterator<Map.Entry<String, Item>> it = this.store.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue() != null) continue;
            it.remove();
        }
    }

    @Override
    public synchronized String get(String key, String def) {
        Item item = this.store.get(key);
        if (item == null && this.parent != null) {
            return this.parent.get(key, def);
        }
        return item != null && item.type == String.class ? (String)item.value : def;
    }

    @Override
    public synchronized boolean getBoolean(String key, boolean def) {
        Item item = this.store.get(key);
        if (item == null && this.parent != null) {
            return this.parent.getBoolean(key, def);
        }
        return item != null && item.type == Boolean.TYPE ? (Boolean)item.value : def;
    }

    @Override
    public synchronized byte[] getByteArray(String key, byte[] def) {
        Item item = this.store.get(key);
        if (item == null && this.parent != null) {
            return this.parent.getByteArray(key, def);
        }
        return item != null && item.type == byte[].class ? (byte[])item.value : def;
    }

    public String getId() {
        return this.id;
    }

    public synchronized boolean hasKey(String key) {
        return this.store.get(key) != null;
    }

    @Override
    public synchronized String[] keys() {
        ArrayList<String> keys = new ArrayList<String>(this.store.keySet().size());
        for (Map.Entry<String, Item> entry : this.store.entrySet()) {
            if (entry.getValue() == null) continue;
            keys.add(entry.getKey());
        }
        return keys.toArray(new String[0]);
    }

    @Override
    public synchronized void put(String key, String value, boolean encrypt) {
        this.put(key, value, encrypt, true);
    }

    @Override
    public synchronized void put(String key, String value, boolean encrypt, boolean persist) {
        this.store.put(key, this.createItem(String.class, value, encrypt, persist));
    }

    @Override
    public synchronized void putBoolean(String key, boolean value, boolean encrypt) {
        this.store.put(key, this.createItem(Boolean.TYPE, value, encrypt, true));
    }

    @Override
    public synchronized void putByteArray(String key, byte[] value, boolean encrypt) {
        this.store.put(key, this.createItem(byte[].class, value, encrypt, encrypt));
    }

    @Override
    public synchronized void remove(String key) {
        if (this.keepRemovedKeys) {
            this.store.put(key, null);
        } else {
            this.store.remove(key);
        }
    }

    private Item createItem(Class<?> type, Object value, boolean encrypt, boolean persist) {
        Item item = new Item();
        item.value = value;
        item.encrypted = encrypt;
        item.persisted = persist;
        item.type = type;
        return item;
    }

    private static class Item {
        boolean encrypted;
        boolean persisted;
        Object value;
        Class<?> type;

        private Item() {
        }
    }
}

