/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class BugzillaPlanningEditorPart
extends AbstractTaskEditorPart {
    private boolean hasIncoming;
    private static final Set<BugzillaAttribute> PLANNING_ATTRIBUTES = EnumSet.of(BugzillaAttribute.ACTUAL_TIME, BugzillaAttribute.ESTIMATED_TIME, BugzillaAttribute.WORK_TIME, BugzillaAttribute.REMAINING_TIME, BugzillaAttribute.DEADLINE);

    public BugzillaPlanningEditorPart() {
        this.setPartName(Messages.BugzillaPlanningEditorPart_Team_Planning);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        TaskAttribute addTimeAttribute;
        AbstractAttributeEditor attributeEditor;
        this.initialize();
        int style = 2;
        if (this.hasIncoming) {
            style |= 0x40;
        }
        Section timeSection = this.createSection(parent, toolkit, style);
        EditorUtil.setTitleBarForeground((ExpandableComposite)timeSection, (Color)toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridLayout gl = new GridLayout();
        GridData gd = new GridData(4, 0, false, false);
        gd.horizontalSpan = 4;
        timeSection.setLayout((Layout)gl);
        timeSection.setLayoutData((Object)gd);
        Composite timeComposite = toolkit.createComposite((Composite)timeSection);
        gl = new GridLayout(6, false);
        timeComposite.setLayout((Layout)gl);
        gd = new GridData();
        gd.horizontalSpan = 4;
        timeComposite.setLayoutData((Object)gd);
        TaskAttribute attribute = this.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.DEADLINE.getKey());
        if (attribute != null) {
            attributeEditor = this.createAttributeEditor(attribute);
            attributeEditor.createLabelControl(timeComposite, toolkit);
            attributeEditor.createControl(timeComposite, toolkit);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(attributeEditor);
        }
        attribute = this.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey());
        attributeEditor = this.createAttributeEditor(attribute);
        attributeEditor.createLabelControl(timeComposite, toolkit);
        attributeEditor.createControl(timeComposite, toolkit);
        this.getTaskEditorPage().getAttributeEditorToolkit().adapt(attributeEditor);
        Label label = toolkit.createLabel(timeComposite, Messages.BugzillaPlanningEditorPart_Current_Estimate);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        float total = 0.0f;
        try {
            TaskAttribute attrActualTime = this.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.ACTUAL_TIME.getKey());
            float actual = 0.0f;
            if (attrActualTime != null) {
                actual = Float.parseFloat(attrActualTime.getValue());
            }
            TaskAttribute attrRemainingTime = this.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.REMAINING_TIME.getKey());
            float remaining = 0.0f;
            if (attrRemainingTime != null) {
                remaining = Float.parseFloat(attrRemainingTime.getValue());
            }
            total = actual + remaining;
        }
        catch (Exception exception) {}
        Text currentEstimate = toolkit.createText(timeComposite, "" + total, 0x800008);
        currentEstimate.setFont(TEXT_FONT);
        toolkit.adapt((Control)currentEstimate, false, false);
        currentEstimate.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        currentEstimate.setLayoutData((Object)new GridData(256));
        attribute = this.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.ACTUAL_TIME.getKey());
        if (attribute != null) {
            attributeEditor = this.createAttributeEditor(attribute);
            attributeEditor.createLabelControl(timeComposite, toolkit);
            attributeEditor.createControl(timeComposite, toolkit);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(attributeEditor);
        }
        if ((addTimeAttribute = this.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.WORK_TIME.getKey())) == null) {
            addTimeAttribute = BugzillaTaskDataHandler.createAttribute((TaskData)this.getTaskData(), (BugzillaAttribute)BugzillaAttribute.WORK_TIME);
        }
        if (addTimeAttribute != null) {
            attributeEditor = this.createAttributeEditor(addTimeAttribute);
            attributeEditor.createLabelControl(timeComposite, toolkit);
            attributeEditor.createControl(timeComposite, toolkit);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(attributeEditor);
        }
        if ((attribute = this.getTaskData().getRoot().getAttribute(BugzillaAttribute.REMAINING_TIME.getKey())) != null) {
            attributeEditor = this.createAttributeEditor(attribute);
            attributeEditor.createLabelControl(timeComposite, toolkit);
            attributeEditor.createControl(timeComposite, toolkit);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(attributeEditor);
        }
        timeSection.setClient((Control)timeComposite);
        toolkit.paintBordersFor(timeComposite);
        this.setSection(toolkit, timeSection);
    }

    private void initialize() {
        this.hasIncoming = false;
        Map attributes = this.getTaskData().getRoot().getAttributes();
        for (TaskAttribute attribute : attributes.values()) {
            BugzillaAttribute bugzillaAttribute = BugzillaAttribute.UNKNOWN;
            try {
                bugzillaAttribute = BugzillaAttribute.valueOf((String)attribute.getId().trim().toUpperCase(Locale.ENGLISH));
            }
            catch (RuntimeException e) {
                if (e instanceof IllegalArgumentException) continue;
                throw e;
            }
            if (!PLANNING_ATTRIBUTES.contains(bugzillaAttribute) || !this.getModel().hasIncomingChanges(attribute)) continue;
            this.hasIncoming = true;
        }
    }
}

