/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.html.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.internal.wikitext.html.core.HtmlSubsetDocumentBuilder;
import org.eclipse.mylyn.internal.wikitext.html.core.SpanHtmlElementStrategy;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentHandler;
import org.eclipse.mylyn.wikitext.html.core.HtmlLanguage;

public class HtmlSubsetLanguage
extends HtmlLanguage {
    private final Set<DocumentBuilder.BlockType> supportedBlockTypes;
    private final Set<DocumentBuilder.SpanType> supportedSpanTypes;
    private final int headingLevel;
    private final HtmlDocumentHandler documentHandler;
    private final List<SpanHtmlElementStrategy> spanElementStrategies;

    public HtmlSubsetLanguage(String name, HtmlDocumentHandler documentHandler, int headingLevel, Set<DocumentBuilder.BlockType> blockTypes, Set<DocumentBuilder.SpanType> spanTypes, List<SpanHtmlElementStrategy> spanElementStrategies) {
        this.setName((String)Preconditions.checkNotNull((Object)name));
        this.documentHandler = documentHandler;
        Preconditions.checkArgument((headingLevel >= 0 && headingLevel <= 6 ? 1 : 0) != 0, (Object)"headingLevel must be between 0 and 6");
        this.headingLevel = headingLevel;
        this.supportedBlockTypes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(blockTypes)));
        this.supportedSpanTypes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(spanTypes)));
        this.spanElementStrategies = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(spanElementStrategies)));
    }

    public Set<DocumentBuilder.BlockType> getSupportedBlockTypes() {
        return this.supportedBlockTypes;
    }

    public Set<DocumentBuilder.SpanType> getSupportedSpanTypes() {
        return this.supportedSpanTypes;
    }

    public int getSupportedHeadingLevel() {
        return this.headingLevel;
    }

    @Override
    public DocumentBuilder createDocumentBuilder(Writer out, boolean formatting) {
        HtmlSubsetDocumentBuilder builder = new HtmlSubsetDocumentBuilder(out, formatting);
        builder.setSupportedHeadingLevel(this.headingLevel);
        builder.setSupportedSpanTypes(this.supportedSpanTypes, this.spanElementStrategies);
        builder.setSupportedBlockTypes(this.supportedBlockTypes);
        if (this.documentHandler != null) {
            builder.setDocumentHandler(this.documentHandler);
        }
        return builder;
    }

    @Override
    public HtmlSubsetLanguage clone() {
        HtmlSubsetLanguage copy = new HtmlSubsetLanguage(this.getName(), this.documentHandler, this.headingLevel, this.supportedBlockTypes, this.supportedSpanTypes, this.spanElementStrategies);
        copy.setFileExtensions(this.getFileExtensions());
        copy.setExtendsLanguage(this.getExtendsLanguage());
        copy.setParseCleansHtml(this.isParseCleansHtml());
        return copy;
    }
}

