/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IDated;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewItem;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsPackage;

public class ReviewItemSet
extends ReviewItem
implements IReviewItemSet {
    protected static final Date CREATION_DATE_EDEFAULT = null;
    protected Date creationDate = CREATION_DATE_EDEFAULT;
    protected static final Date MODIFICATION_DATE_EDEFAULT = null;
    protected Date modificationDate = MODIFICATION_DATE_EDEFAULT;
    protected EList<IFileItem> items;
    protected static final String REVISION_EDEFAULT = "";
    protected String revision = "";

    protected ReviewItemSet() {
    }

    @Override
    protected EClass eStaticClass() {
        return ReviewsPackage.Literals.REVIEW_ITEM_SET;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date newCreationDate) {
        Date oldCreationDate = this.creationDate;
        this.creationDate = new Date(newCreationDate.getTime());
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldCreationDate, (Object)this.creationDate));
        }
    }

    @Override
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date newModificationDate) {
        Date oldModificationDate = this.modificationDate;
        this.modificationDate = new Date(newModificationDate.getTime());
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldModificationDate, (Object)this.modificationDate));
        }
    }

    @Override
    public List<IFileItem> getItems() {
        if (this.items == null) {
            this.items = new EObjectContainmentWithInverseEList.Resolving(IFileItem.class, (InternalEObject)this, 12, 12);
        }
        return this.items;
    }

    public Date getLastChangeDate() {
        if (this.getModificationDate() != null) {
            return this.getModificationDate();
        }
        return this.getCreationDate();
    }

    @Override
    public List<IComment> getAllComments() {
        ArrayList<IComment> all = new ArrayList<IComment>(this.getComments());
        for (IReviewItem iReviewItem : this.getItems()) {
            all.addAll(iReviewItem.getAllComments());
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)ReviewsPackage.Literals.COMMENT_CONTAINER__ALL_COMMENTS, all.size(), all.toArray());
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(String newRevision) {
        String oldRevision = this.revision;
        this.revision = newRevision;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldRevision, (Object)this.revision));
        }
    }

    @Override
    public IReview getParentReview() {
        if (this.eContainerFeatureID() != 14) {
            return null;
        }
        return (IReview)this.eContainer();
    }

    public IReview basicGetParentReview() {
        if (this.eContainerFeatureID() != 14) {
            return null;
        }
        return (IReview)this.eInternalContainer();
    }

    public NotificationChain basicSetParentReview(IReview newParentReview, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newParentReview, 14, msgs);
        return msgs;
    }

    @Override
    public void setParentReview(IReview newParentReview) {
        if (newParentReview != this.eInternalContainer() || this.eContainerFeatureID() != 14 && newParentReview != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newParentReview)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newParentReview != null) {
                msgs = ((InternalEObject)newParentReview).eInverseAdd((InternalEObject)this, 12, IReview.class, msgs);
            }
            if ((msgs = this.basicSetParentReview(newParentReview, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)newParentReview, (Object)newParentReview));
        }
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 12: {
                return ((InternalEList)this.getItems()).basicAdd((Object)otherEnd, msgs);
            }
            case 14: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetParentReview((IReview)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 12: {
                return ((InternalEList)this.getItems()).basicRemove((Object)otherEnd, msgs);
            }
            case 14: {
                return this.basicSetParentReview(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 14: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 12, IReview.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getCreationDate();
            }
            case 11: {
                return this.getModificationDate();
            }
            case 12: {
                return this.getItems();
            }
            case 13: {
                return this.getRevision();
            }
            case 14: {
                if (resolve) {
                    return this.getParentReview();
                }
                return this.basicGetParentReview();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setCreationDate((Date)newValue);
                return;
            }
            case 11: {
                this.setModificationDate((Date)newValue);
                return;
            }
            case 12: {
                this.getItems().clear();
                this.getItems().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.setRevision((String)newValue);
                return;
            }
            case 14: {
                this.setParentReview((IReview)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setCreationDate(CREATION_DATE_EDEFAULT);
                return;
            }
            case 11: {
                this.setModificationDate(MODIFICATION_DATE_EDEFAULT);
                return;
            }
            case 12: {
                this.getItems().clear();
                return;
            }
            case 13: {
                this.setRevision(REVISION_EDEFAULT);
                return;
            }
            case 14: {
                this.setParentReview(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return CREATION_DATE_EDEFAULT == null ? this.creationDate != null : !CREATION_DATE_EDEFAULT.equals(this.creationDate);
            }
            case 11: {
                return MODIFICATION_DATE_EDEFAULT == null ? this.modificationDate != null : !MODIFICATION_DATE_EDEFAULT.equals(this.modificationDate);
            }
            case 12: {
                return this.items != null && !this.items.isEmpty();
            }
            case 13: {
                return REVISION_EDEFAULT == null ? this.revision != null : !REVISION_EDEFAULT.equals(this.revision);
            }
            case 14: {
                return this.basicGetParentReview() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IDated.class) {
            switch (derivedFeatureID) {
                case 10: {
                    return 0;
                }
                case 11: {
                    return 1;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IDated.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 10;
                }
                case 1: {
                    return 11;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (creationDate: ");
        result.append(this.creationDate);
        result.append(", modificationDate: ");
        result.append(this.modificationDate);
        result.append(", revision: ");
        result.append(this.revision);
        result.append(')');
        return result.toString();
    }

    @Override
    public IReview getReview() {
        return this.getParentReview();
    }
}

