/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.TracHarness;
import org.eclipse.mylyn.trac.tests.support.TracTestUtil;

public class TracAttachmentHandlerTest
extends TestCase {
    private TaskRepository repository;
    private TracRepositoryConnector connector;
    private AbstractTaskAttachmentHandler attachmentHandler;
    private TracHarness harness;

    protected void setUp() throws Exception {
        this.harness = TracFixture.current().createHarness();
        this.connector = this.harness.connector();
        this.attachmentHandler = this.connector.getTaskAttachmentHandler();
        this.repository = this.harness.repository();
    }

    protected void tearDown() throws Exception {
        this.harness.dispose();
    }

    public void testGetContent() throws Exception {
        TracTicket ticket = this.harness.createTicket("GetContent");
        this.harness.attachFile(ticket.getId(), "attachment.txt", "Mylar\n");
        ITask task = this.harness.getTask(ticket);
        List<ITaskAttachment> attachments = TracTestUtil.getTaskAttachments(task);
        TracAttachmentHandlerTest.assertTrue((attachments.size() > 0 ? 1 : 0) != 0);
        InputStream in = this.attachmentHandler.getContent(this.repository, task, attachments.get(0).getTaskAttribute(), null);
        try {
            byte[] result = new byte[6];
            in.read(result);
            TracAttachmentHandlerTest.assertEquals((String)"Mylar\n", (String)new String(result));
            TracAttachmentHandlerTest.assertEquals((int)-1, (int)in.read());
        }
        finally {
            in.close();
        }
    }

    public void testPostConent() throws Exception {
        ITask task = this.harness.createTask("GetContent");
        File file = File.createTempFile("attachment", null);
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write("Mylar".getBytes());
        }
        finally {
            ((OutputStream)out).close();
        }
        this.attachmentHandler.postContent(this.repository, task, (AbstractTaskAttachmentSource)new FileTaskAttachmentSource(file), "comment", null, null);
        ITracClient client = this.connector.getClientManager().getTracClient(this.repository);
        InputStream in = client.getAttachmentData(Integer.parseInt(task.getTaskId()), file.getName(), null);
        try {
            byte[] result = new byte[5];
            in.read(result);
            TracAttachmentHandlerTest.assertEquals((String)"Mylar", (String)new String(result));
        }
        finally {
            in.close();
        }
    }

    public void testCanUploadAttachment() throws Exception {
        ITask task = this.harness.createTask("canUploadAttachment");
        if (this.harness.isXmlRpc()) {
            TracAttachmentHandlerTest.assertTrue((boolean)this.attachmentHandler.canPostContent(this.repository, task));
        } else {
            TracAttachmentHandlerTest.assertFalse((boolean)this.attachmentHandler.canPostContent(this.repository, task));
        }
    }

    public void testCanDownloadAttachmentXmlRpc() throws Exception {
        ITask task = this.harness.createTask("canDownloadAttachment");
        if (this.harness.isXmlRpc()) {
            TracAttachmentHandlerTest.assertTrue((boolean)this.attachmentHandler.canGetContent(this.repository, task));
        } else {
            TracAttachmentHandlerTest.assertFalse((boolean)this.attachmentHandler.canGetContent(this.repository, task));
        }
    }
}

