/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SelectionDialog
extends FormDialog {
    private List<TaskRepository> fListTaskRepository;
    private String fSelection = null;
    private final String fTitle = "Select a Gerit server";
    private final String fQuestion = "Question ? ";

    public SelectionDialog(Shell parent, List<TaskRepository> listTaskRepository) {
        super(parent);
        this.fListTaskRepository = listTaskRepository;
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText("Select a Gerit server");
        mform.getForm().getShell().setText("Question ? ");
        ScrolledForm sform = mform.getForm();
        sform.setExpandHorizontal(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)composite);
        int size = this.fListTaskRepository.size();
        int index = 0;
        while (index < size) {
            final Button button = new Button(composite, 16);
            button.setText(this.fListTaskRepository.get(index).toString());
            button.setSelection(false);
            button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SelectionDialog.this.setSelection(button.getText());
                }
            });
            GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)button);
            ++index;
        }
        this.setHelpAvailable(false);
    }

    private void setSelection(String selection) {
        this.fSelection = selection;
    }

    public String getSelection() {
        return this.fSelection;
    }
}

