/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.internal.model;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.gerrit.dashboard.core.GerritTask;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ReviewTableSorter
extends ViewerSorter {
    private int columnIndex = 0;

    public ReviewTableSorter(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public int compare(Viewer viewer, Object item1, Object item2) {
        int result = 0;
        if (viewer instanceof TableViewer && item1 instanceof GerritTask && item2 instanceof GerritTask) {
            GerritTask task1 = (GerritTask)item1;
            GerritTask task2 = (GerritTask)item2;
            String val1 = null;
            String val2 = null;
            switch (this.columnIndex) {
                case 0: {
                    val1 = task1.getAttribute(GerritTask.IS_STARRED);
                    val2 = task2.getAttribute(GerritTask.IS_STARRED);
                    if (val1 == null || val2 == null) break;
                    result = val1.compareTo(val2);
                    break;
                }
                case 6: {
                    val1 = task1.getAttribute("task.common.date.modified");
                    val2 = task2.getAttribute("task.common.date.modified");
                    if (val1 == null || val2 == null) break;
                    result = val1.compareTo(val2);
                    break;
                }
                case 7: {
                    val1 = task1.getAttribute(GerritTask.REVIEW_STATE);
                    val2 = task2.getAttribute(GerritTask.REVIEW_STATE);
                    if (val1 == null || val2 == null) break;
                    Integer v1 = new Integer(val1);
                    Integer v2 = new Integer(val2);
                    result = v2 - v1;
                    break;
                }
                case 8: {
                    val1 = task1.getAttribute(GerritTask.VERIFY_STATE);
                    val2 = task2.getAttribute(GerritTask.VERIFY_STATE);
                    if (val1 == null || val2 == null) break;
                    Integer v1 = new Integer(val1);
                    Integer v2 = new Integer(val2);
                    result = v2 - v1;
                    break;
                }
                default: {
                    result = this.defaultCompare(viewer, item1, item2);
                }
            }
            if (((TableViewer)viewer).getTable().getSortDirection() != 128) {
                result = -result;
            }
        } else {
            result = this.defaultCompare(viewer, item1, item2);
        }
        return result;
    }

    private int defaultCompare(Viewer aViewer, Object aE1, Object aE2) {
        if (aViewer instanceof TableViewer) {
            TableViewer tv = (TableViewer)aViewer;
            tv.getTable().setSortColumn(tv.getTable().getColumn(this.columnIndex));
            int idx1 = -1;
            int idx2 = -1;
            int i = 0;
            while (i < tv.getTable().getItemCount()) {
                Object obj = tv.getElementAt(i);
                if (obj.equals(aE1)) {
                    idx1 = i;
                } else if (obj.equals(aE2)) {
                    idx2 = i;
                }
                if (idx1 != -1 && idx2 != -1) break;
                ++i;
            }
            int order = 0;
            if (idx1 > -1 && idx2 > -1) {
                String str1 = tv.getTable().getItems()[idx1].getText(this.columnIndex);
                String str2 = tv.getTable().getItems()[idx2].getText(this.columnIndex);
                order = str1.compareTo(str2);
            }
            if (tv.getTable().getSortDirection() != 128) {
                order *= -1;
            }
            return order;
        }
        if (aViewer instanceof TreeViewer) {
            TreeViewer tv = (TreeViewer)aViewer;
            tv.getTree().setSortColumn(tv.getTree().getColumn(this.columnIndex));
            int idx1 = -1;
            int idx2 = -1;
            TreeItem[] listObj = tv.getTree().getItems();
            int i = 0;
            while (i < listObj.length) {
                Object obj = null;
                if (listObj[i] instanceof TreeItem) {
                    obj = listObj[i].getData();
                    listObj[i].setExpanded(true);
                }
                if (obj != null) {
                    if (obj.equals(aE1)) {
                        idx1 = i;
                    } else if (obj.equals(aE2)) {
                        idx2 = i;
                    }
                    if (idx1 > 0 && idx2 > 0) break;
                }
                ++i;
            }
            int order = 0;
            if (idx1 > -1 && idx2 > -1) {
                String str1 = tv.getTree().getItems()[idx1].getText(this.columnIndex);
                String str2 = tv.getTree().getItems()[idx2].getText(this.columnIndex);
                order = str1.compareTo(str2);
                if (tv.getTree().getSortDirection() != 128) {
                    order *= -1;
                }
            }
            return order;
        }
        return 0;
    }

    public static void bind(final TableViewer aTableViewer) {
        int i = 0;
        while (i < aTableViewer.getTable().getColumnCount()) {
            final int columnNum = i;
            TableColumn column = aTableViewer.getTable().getColumn(i);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReviewTableSorter sorter = new ReviewTableSorter(columnNum);
                    Table table = aTableViewer.getTable();
                    if (table.getSortDirection() == 128) {
                        table.setSortDirection(1024);
                    } else if (table.getSortDirection() == 1024) {
                        table.setSortDirection(128);
                    } else {
                        table.setSortDirection(128);
                    }
                    aTableViewer.setComparator((ViewerComparator)sorter);
                }
            });
            ++i;
        }
    }
}

