/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class BugzillaTaskCompletionTest
extends TestCase {
    private TaskRepository repository;
    private BugzillaRepositoryConnector connector;

    protected void setUp() throws Exception {
        super.setUp();
        BugzillaFixture.current().client();
        this.repository = BugzillaFixture.current().repository();
        this.connector = BugzillaFixture.current().connector();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCompletionDate() throws Exception {
        TaskTask task = new TaskTask("bugzilla", BugzillaFixture.current().getRepositoryUrl(), "1");
        TaskAttributeMapper mapper = this.connector.getTaskDataHandler().getAttributeMapper(this.repository);
        TaskData taskData = new TaskData(mapper, "bugzilla", BugzillaFixture.current().getRepositoryUrl(), "1");
        taskData.getRoot().createAttribute(BugzillaAttribute.BUG_STATUS.getKey()).setValue("RESOLVED");
        TaskAttribute attrComment = taskData.getRoot().createAttribute(BugzillaAttribute.COMMENTID.getKey());
        attrComment.getMetaData().setType("comment");
        TaskAttribute attrCreationDate = attrComment.createAttribute(BugzillaAttribute.BUG_WHEN.getKey());
        attrCreationDate.setValue("2009-12-11 12:00");
        BugzillaTaskCompletionTest.assertFalse((boolean)task.isCompleted());
        this.connector.updateTaskFromTaskData(this.repository, (ITask)task, taskData);
        BugzillaTaskCompletionTest.assertTrue((boolean)task.isCompleted());
        Date completionDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse("2009-12-11 12:00");
        BugzillaTaskCompletionTest.assertTrue((boolean)completionDate.equals(task.getCompletionDate()));
    }

    public void testCompletionDateForStates() throws Exception {
        TaskTask task = new TaskTask("bugzilla", BugzillaFixture.current().getRepositoryUrl(), "1");
        TaskAttributeMapper mapper = this.connector.getTaskDataHandler().getAttributeMapper(this.repository);
        TaskData taskData = new TaskData(mapper, "bugzilla", BugzillaFixture.current().getRepositoryUrl(), "1");
        TaskAttribute status = taskData.getRoot().createAttribute(BugzillaAttribute.BUG_STATUS.getKey());
        status.setValue("REOPENED");
        TaskAttribute attrComment = taskData.getRoot().createAttribute(BugzillaAttribute.COMMENTID.getKey());
        attrComment.getMetaData().setType("comment");
        TaskAttribute attrCreationDate = attrComment.createAttribute(BugzillaAttribute.BUG_WHEN.getKey());
        attrCreationDate.setValue("2008-12-11 12:00");
        BugzillaTaskCompletionTest.assertFalse((boolean)task.isCompleted());
        taskData.setPartial(true);
        Date completionDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse("2009-01-06 06:06");
        task.setCompletionDate(completionDate);
        BugzillaTaskCompletionTest.assertTrue((boolean)completionDate.equals(task.getCompletionDate()));
        this.connector.updateTaskFromTaskData(this.repository, (ITask)task, taskData);
        BugzillaTaskCompletionTest.assertTrue((!task.isCompleted() ? 1 : 0) != 0);
        BugzillaTaskCompletionTest.assertNull((Object)task.getCompletionDate());
        status.setValue("NEW");
        task.setCompletionDate(completionDate);
        BugzillaTaskCompletionTest.assertTrue((boolean)completionDate.equals(task.getCompletionDate()));
        this.connector.updateTaskFromTaskData(this.repository, (ITask)task, taskData);
        BugzillaTaskCompletionTest.assertTrue((!task.isCompleted() ? 1 : 0) != 0);
        BugzillaTaskCompletionTest.assertNull((Object)task.getCompletionDate());
        status.setValue("VERIFIED");
        this.connector.updateTaskFromTaskData(this.repository, (ITask)task, taskData);
        BugzillaTaskCompletionTest.assertTrue((boolean)task.isCompleted());
        Date nullDate = new Date(0L);
        BugzillaTaskCompletionTest.assertNotNull((Object)task.getCompletionDate());
        BugzillaTaskCompletionTest.assertTrue((boolean)nullDate.equals(task.getCompletionDate()));
    }
}

