/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.internal.wikitext.markdown.core.LinkDefinitionUsageTracker;
import org.eclipse.mylyn.internal.wikitext.markdown.core.MarkdownContentState;
import org.eclipse.mylyn.internal.wikitext.markdown.core.validation.Messages;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.Locator;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.NoOpDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;
import org.eclipse.mylyn.wikitext.core.validation.ValidationRule;
import org.eclipse.mylyn.wikitext.markdown.core.MarkdownLanguage;

public class LinkDefinitionValidationRule
extends ValidationRule {
    public ValidationProblem findProblem(String markup, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    public List<ValidationProblem> findProblems(String markup, int offset, int length) {
        MarkupParser parser = new MarkupParser((MarkupLanguage)new MarkdownLanguage());
        MarkdownContentStateDocumentBuilder builder = new MarkdownContentStateDocumentBuilder();
        parser.setBuilder((DocumentBuilder)builder);
        parser.parse(markup);
        MarkdownContentState markdownContentState = builder.markdownContentState;
        LinkDefinitionUsageTracker linkDefinitionUsageTracker = markdownContentState.getLinkDefinitionUsageTracker();
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        List<LinkDefinitionUsageTracker.Position> missingLinkDefinitionPositions = linkDefinitionUsageTracker.getMissingLinkDefinitionPositions();
        for (LinkDefinitionUsageTracker.Position position : missingLinkDefinitionPositions) {
            problems.add(new ValidationProblem(ValidationProblem.Severity.ERROR, MessageFormat.format(Messages.getString("LinkDefinitionValidationRule.missing"), position.getId()), position.getOffset(), position.getLength()));
        }
        List<LinkDefinitionUsageTracker.Position> unusedLinkDefinitionPositions = linkDefinitionUsageTracker.getUnusedLinkDefinitionPositions();
        for (LinkDefinitionUsageTracker.Position position : unusedLinkDefinitionPositions) {
            problems.add(new ValidationProblem(ValidationProblem.Severity.WARNING, MessageFormat.format(Messages.getString("LinkDefinitionValidationRule.unused"), position.getId()), position.getOffset(), position.getLength()));
        }
        return problems;
    }

    private class MarkdownContentStateDocumentBuilder
    extends NoOpDocumentBuilder {
        MarkdownContentState markdownContentState;

        private MarkdownContentStateDocumentBuilder() {
        }

        public void setLocator(Locator locator) {
            if (locator != null) {
                this.markdownContentState = (MarkdownContentState)locator;
            }
            super.setLocator(locator);
        }
    }
}

