/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.remote;

import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.reviewdb.Account;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritReviewRemoteFactory;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritUserRemoteFactory;
import org.eclipse.mylyn.internal.gerrit.core.remote.PatchSetContentIdRemoteFactory;
import org.eclipse.mylyn.internal.gerrit.core.remote.PatchSetDetailRemoteFactory;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.spi.edit.remote.review.ReviewsRemoteEditFactoryProvider;

public class GerritRemoteFactoryProvider
extends ReviewsRemoteEditFactoryProvider {
    private final GerritClient client;
    private final GerritReviewRemoteFactory reviewFactory = new GerritReviewRemoteFactory(this);
    private final PatchSetDetailRemoteFactory reviewItemSetFactory = new PatchSetDetailRemoteFactory(this);
    private final PatchSetContentIdRemoteFactory reviewItemSetContentFactory = new PatchSetContentIdRemoteFactory(this);
    private final GerritUserRemoteFactory userFactory = new GerritUserRemoteFactory(this);

    public GerritRemoteFactoryProvider(GerritClient client) {
        super(client.getRepository());
        this.client = client;
    }

    public GerritReviewRemoteFactory getReviewFactory() {
        return this.reviewFactory;
    }

    public PatchSetDetailRemoteFactory getReviewItemSetFactory() {
        return this.reviewItemSetFactory;
    }

    public PatchSetContentIdRemoteFactory getReviewItemSetContentFactory() {
        return this.reviewItemSetContentFactory;
    }

    public GerritUserRemoteFactory getUserFactory(AccountInfoCache cache) {
        this.userFactory.getCache().merge(cache);
        return this.userFactory;
    }

    void pullUser(final IRepository parent, final AccountInfoCache cache, final Account.Id id, final IProgressMonitor monitor) throws CoreException {
        this.modelExec(new Runnable(){

            @Override
            public void run() {
                if (id != null) {
                    RemoteEmfConsumer userConsumer = GerritRemoteFactoryProvider.this.getUserFactory(cache).getConsumerForRemoteKey((EObject)parent, id);
                    try {
                        userConsumer.pull(false, monitor);
                    }
                    catch (CoreException e) {
                        StatusHandler.log((IStatus)e.getStatus());
                    }
                }
            }
        }, true);
    }

    IUser createUser(IRepository parent, AccountInfoCache cache, Account.Id id) {
        if (id != null) {
            RemoteEmfConsumer userConsumer = this.getUserFactory(cache).getConsumerForRemoteKey((EObject)parent, id);
            userConsumer.applyModel(false);
            return (IUser)userConsumer.getModelObject();
        }
        return null;
    }

    public GerritClient getClient() {
        return this.client;
    }
}

