/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.core;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.confluence.core.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.core.osgi.OsgiServiceLocator;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.DocBookDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.RecordingDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.tests.AbstractMarkupGenerationTest;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class ConfluenceLanguageTest
extends AbstractMarkupGenerationTest<ConfluenceLanguage> {
    @Override
    protected ConfluenceLanguage createMarkupLanguage() {
        return new ConfluenceLanguage();
    }

    @Test
    public void testDiscoverable() {
        MarkupLanguage language = OsgiServiceLocator.getApplicableInstance().getMarkupLanguage("Confluence");
        Assert.assertNotNull((Object)language);
        Assert.assertTrue((boolean)(language instanceof ConfluenceLanguage));
    }

    @Test
    public void testIsDetectingRawHyperlinks() {
        Assert.assertTrue((boolean)this.getMarkupLanguage().isDetectingRawHyperlinks());
    }

    @Test
    public void testParagraph() throws Exception {
        String html = this.parser.parseToHtml("a paragraph\n\nanother paragraph\nwith\n2 lines");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)Pattern.compile("<body><p>a paragraph</p><p>another paragraph<br/>\\s*with<br/>\\s*2 lines</p></body>", 8).matcher(html).find());
    }

    @Test
    public void testHeadings() {
        int x = 1;
        while (x <= 6) {
            this.initParser();
            String html = this.parser.parseToHtml("h" + x + ". a heading\n\nwith a para");
            TestUtil.println("HTML:" + html);
            Assert.assertTrue((boolean)Pattern.compile("<body><h" + x + " id=\"aheading\">a heading</h" + x + "><p>with a para</p></body>", 8).matcher(html).find());
            html = this.parser.parseToHtml("h" + x + ". a heading\nwith a para");
            TestUtil.println("HTML:" + html);
            Assert.assertTrue((boolean)Pattern.compile("<body><h" + x + " id=\"aheading\">a heading</h" + x + "><p>with a para</p></body>", 8).matcher(html).find());
            html = this.parser.parseToHtml("  h" + x + ". a heading\n\nwith a para");
            TestUtil.println("HTML:" + html);
            Assert.assertTrue((boolean)Pattern.compile("<body><h" + x + " id=\"aheading\">a heading</h" + x + "><p>with a para</p></body>", 8).matcher(html).find());
            ++x;
        }
    }

    @Test
    public void testBlockQuote() {
        String html = this.parser.parseToHtml("bq. a multiline\nblock quote\n\nwith a para");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)Pattern.compile("<body><blockquote><p>a multiline<br/>\\s*block quote</p></blockquote><p>with a para</p></body>", 8).matcher(html).find());
    }

    @Test
    public void testBlockQuoteExtended() {
        String html = this.parser.parseToHtml("{quote}\na multiline\nblock quote\n\nwith two paras\n{quote}\nanother para");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)Pattern.compile("<body><blockquote><p>a multiline<br/>\\s*block quote</p><p>with two paras</p></blockquote><p>another para</p></body>", 8).matcher(html).find());
    }

    @Test
    public void testBlockQuoteExtended2() {
        String html = this.parser.parseToHtml("{quote}this is a quote{quote}\nsome more text");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)html.contains("<body><blockquote><p>this is a quote</p></blockquote><p>some more text</p></body>"));
    }

    @Test
    public void testBlockQuoteExtendedUnclosed() {
        String html = this.parser.parseToHtml("{quote}\na multiline\nblock quote\n\nwith two paras\n");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)Pattern.compile("<body><blockquote><p>a multiline<br/>\\s*block quote</p><p>with two paras</p></blockquote></body>", 8).matcher(html).find());
    }

    @Test
    public void testBlockQuoteExtendedLeadingSpaces() {
        String html = this.parser.parseToHtml("     {quote}\na multiline\nblock quote\n    {quote}\nmore text");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)html.contains("<body><blockquote><p>a multiline<br/>block quote</p></blockquote><p>more text</p></body>"));
    }

    @Test
    public void testBlockQuoteExtendedBreaksPara() {
        String html = this.parser.parseToHtml("a para\n{quote}quoted{quote}new para");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a para</p><blockquote><p>quoted</p></blockquote><p>new para</p></body>"));
    }

    @Test
    public void testBlockQuoteWithBulletedList() {
        String html = this.parser.parseToHtml("{quote}\ntext\n* a list\n* second item\n\nmore text\n{quote}\nanother para");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)html.contains("<body><blockquote><p>text</p><ul><li>a list</li><li>second item</li></ul><p>more text</p></blockquote><p>another para</p></body>"));
    }

    @Test
    public void testSimplePhraseModifiers() throws IOException {
        Object[][] pairs;
        Object[][] objectArrayArray = pairs = new Object[][]{{"*", "strong"}, {"_", "em"}, {"??", "cite"}, {"-", "del"}, {"+", "u"}, {"^", "sup"}, {"~", "sub"}};
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] pair = objectArrayArray[n2];
            this.initParser();
            String html = this.parser.parseToHtml("a paragraph with " + pair[0] + "content foo bar baz" + pair[0]);
            TestUtil.println("HTML: \n" + html);
            Assert.assertTrue((boolean)html.contains("<p>a paragraph with <" + pair[1] + ">content foo bar baz</" + pair[1] + "></p>"));
            ++n2;
        }
    }

    @Test
    public void testDeleted() {
        String html = this.parser.parseToHtml("one -two three-four five- six");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<del>two three-four five</del>"));
    }

    @Test
    public void testMonospaced() {
        String html = this.parser.parseToHtml("a paragraph with {{content foo bar baz}}");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>a paragraph with <tt>content foo bar baz</tt></p>"));
    }

    @Test
    public void testMonospaced_NegativeTest() {
        String html = this.parser.parseToHtml("a paragraph with \\{{content foo bar baz}}");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>a paragraph with {{content foo bar baz}}</p>"));
    }

    @Test
    public void testCharacterEscapeSequence() {
        String html = this.parser.parseToHtml("a \\{ b");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>a { b</p>"));
    }

    @Test
    public void testEndash() {
        String html = this.parser.parseToHtml("an endash -- foo");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("endash &#8211; foo"));
    }

    @Test
    public void testEnDashAtStartOfLine() throws IOException {
        String html = this.parser.parseToHtml("-- two");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("&#8211; two"));
    }

    @Test
    public void testEnDashAfterWordNoWhitespace() throws IOException {
        String html = this.parser.parseToHtml("one-- two");
        TestUtil.println("HTML: \n" + html);
        Assert.assertFalse((boolean)html.contains("&#8211;"));
        Assert.assertTrue((boolean)html.contains("one-- two"));
    }

    @Test
    public void testEmdash() {
        String html = this.parser.parseToHtml("an emdash --- foo");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("emdash &#8212; foo"));
    }

    @Test
    public void testEmDashAtStartOfLine() throws IOException {
        String html = this.parser.parseToHtml("--- two");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("&#8212; two"));
    }

    @Test
    public void testEmDashAfterWordNoWhitespace() throws IOException {
        String html = this.parser.parseToHtml("one--- two");
        TestUtil.println("HTML: \n" + html);
        Assert.assertFalse((boolean)html.contains("&#8212;"));
        Assert.assertTrue((boolean)html.contains("one--- two"));
    }

    @Test
    public void testHorizontalRule() {
        String html = this.parser.parseToHtml("an hr ---- foo");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("hr <hr/> foo"));
    }

    @Test
    public void testHorizontalRule2() {
        String html = this.parser.parseToHtml("---- an hr foo");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<hr/> an hr foo"));
    }

    @Test
    public void testHorizontalRule3() {
        String html = this.parser.parseToHtml("an hr foo ----");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("an hr foo <hr/>"));
    }

    @Test
    public void testHorizontalRule4() {
        String html = this.parser.parseToHtml("text\n----\nmore text");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<hr/>"));
    }

    @Test
    public void testHyperlink() {
        String html = this.parser.parseToHtml("a [http://example.com] hyperlink");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">http://example.com</a> hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkPartiallyExpressed() {
        String html = this.parser.parseToHtml("a [ |] hyperlink");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a  hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkInternal() {
        String oldPattern = this.getMarkupLanguage().getInternalLinkPattern();
        this.getMarkupLanguage().setInternalLinkPattern("/display/{0}");
        String html = this.parser.parseToHtml("a [Page Example] hyperlink");
        TestUtil.println("HTML: \n" + html);
        this.getMarkupLanguage().setInternalLinkPattern(oldPattern);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"/display/Page Example\">Page Example</a> hyperlink</p></body>"));
    }

    protected ConfluenceLanguage getMarkupLanguage() {
        return (ConfluenceLanguage)this.parser.getMarkupLanguage();
    }

    @Test
    public void testHyperlinkInternalWithAnchor() {
        String oldPattern = this.getMarkupLanguage().getInternalLinkPattern();
        this.getMarkupLanguage().setInternalLinkPattern("/display/{0}");
        String html = this.parser.parseToHtml("a [#Page Example] hyperlink");
        TestUtil.println("HTML: \n" + html);
        this.getMarkupLanguage().setInternalLinkPattern(oldPattern);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"#Page Example\">Page Example</a> hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkInternalWithName() {
        String oldPattern = this.getMarkupLanguage().getInternalLinkPattern();
        this.getMarkupLanguage().setInternalLinkPattern("/display/{0}");
        String html = this.parser.parseToHtml("a [Another Page Example|Page Example] hyperlink");
        TestUtil.println("HTML: \n" + html);
        this.getMarkupLanguage().setInternalLinkPattern(oldPattern);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"/display/Page Example\">Another Page Example</a> hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkInternalWithNameAndTip() {
        String oldPattern = this.getMarkupLanguage().getInternalLinkPattern();
        this.getMarkupLanguage().setInternalLinkPattern("/display/{0}");
        String html = this.parser.parseToHtml("a [Another Page Example|Page Example| Some tip] hyperlink");
        TestUtil.println("HTML: \n" + html);
        this.getMarkupLanguage().setInternalLinkPattern(oldPattern);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"/display/Page Example\" title=\"Some tip\">Another Page Example</a> hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkWithTitle() {
        String html = this.parser.parseToHtml("a [Example|http://example.com] hyperlink");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">Example</a> hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkWithTitle2() {
        String html = this.parser.parseToHtml("a [Example Two | http://example.com] hyperlink");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">Example Two</a> hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkHash() {
        String html = this.parser.parseToHtml("a [Example|#example] hyperlink");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"#example\">Example</a> hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkHash2() {
        String html = this.parser.parseToHtml("a [#example] hyperlink");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"#example\">example</a> hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkWithTip() {
        String html = this.parser.parseToHtml("a [example | http://example.com | title is here] hyperlink");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\" title=\"title is here\">example</a> hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkImplied() {
        String html = this.parser.parseToHtml("a http://example.com hyperlink");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">http://example.com</a> hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkImpliedNegativeMatch() {
        String html = this.parser.parseToHtml("a http://example.com. hyperlink");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">http://example.com</a>. hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkImpliedNegativeMatch2() {
        String html = this.parser.parseToHtml("a http://example.com) hyperlink");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">http://example.com</a>) hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkWithSpaces() {
        String html = this.parser.parseToHtml("a [ http://example.com ] hyperlink");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">http://example.com</a> hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkWithTitleAndSpace() {
        String html = this.parser.parseToHtml("a [Example Two | http://example.com ] hyperlink");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">Example Two</a> hyperlink</p></body>"));
    }

    @Test
    public void testHyperlinkMailtoNoBase() {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setBase(null);
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("[test|mailto:foo@bar.com]");
        TestUtil.println(out.toString());
        Assert.assertTrue((boolean)out.toString().contains("<a href=\"mailto:foo@bar.com\">test</a>"));
    }

    @Test
    public void testHyperlinkMailtoWithBase() throws URISyntaxException {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setBase(new URI("/"));
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("[test|mailto:foo@bar.com]");
        TestUtil.println(out.toString());
        Assert.assertTrue((boolean)out.toString().contains("<a href=\"mailto:foo@bar.com\">test</a>"));
    }

    @Test
    public void testItalicsWithHyperlink() {
        String html = this.parser.parseToHtml("_This [This is a test|http://my_url.jpg] is a test_");
        System.out.println(html);
        Assert.assertTrue((boolean)html.contains("<body><p><em>This <a href=\"http://my_url.jpg\">This is a test</a> is a test</em></p></body>"));
    }

    @Test
    public void testItalicsWithHyperlink2() {
        String html = this.parser.parseToHtml("_This [This is a test|http://myurl.jpg] is a test_");
        System.out.println(html);
        Assert.assertTrue((boolean)html.contains("<body><p><em>This <a href=\"http://myurl.jpg\">This is a test</a> is a test</em></p></body>"));
    }

    @Test
    public void testItalicsWithHyperlink3() {
        String html = this.parser.parseToHtml("_This [This is a test|http://my%5Furl.jpg] is a test_");
        System.out.println(html);
        Assert.assertTrue((boolean)html.contains("<body><p><em>This <a href=\"http://my%5Furl.jpg\">This is a test</a> is a test</em></p></body>"));
    }

    @Test
    public void testNamedAnchor() {
        String html = this.parser.parseToHtml("a {anchor:a23423} named anchor");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <span id=\"a23423\"></span> named anchor</p></body>"));
    }

    @Test
    public void testListUnordered() throws IOException {
        String html = this.parser.parseToHtml("* a list\n* with two lines");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ul>"));
        Assert.assertTrue((boolean)html.contains("<li>a list</li>"));
        Assert.assertTrue((boolean)html.contains("<li>with two lines</li>"));
        Assert.assertTrue((boolean)html.contains("</ul>"));
    }

    @Test
    public void testListOrdered() throws IOException {
        String html = this.parser.parseToHtml("# a list\n# with two lines");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ol>"));
        Assert.assertTrue((boolean)html.contains("<li>a list</li>"));
        Assert.assertTrue((boolean)html.contains("<li>with two lines</li>"));
        Assert.assertTrue((boolean)html.contains("</ol>"));
    }

    @Test
    public void testListNested() throws IOException {
        String html = this.parser.parseToHtml("# a list\n## nested\n## nested2\n# level1\n\npara");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ol>"));
        Assert.assertTrue((boolean)html.contains("<li>a list"));
        Assert.assertTrue((boolean)html.contains("<li>nested"));
        Assert.assertTrue((boolean)html.contains("</ol>"));
    }

    @Test
    public void testListMixed() throws IOException {
        String html = this.parser.parseToHtml("# first\n* second");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ol><li>first</li></ol><ul><li>second</li></ul>"));
    }

    @Test
    public void testListNestedMixed() throws IOException {
        String html = this.parser.parseToHtml("# a list\n#* nested\n#* nested2\n# level1\n\npara");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ol><li>a list<ul><li>nested</li><li>nested2</li></ul></li><li>level1</li></ol>"));
    }

    @Test
    public void testListWithHrPattern() throws IOException {
        String html = this.parser.parseToHtml("- first\n-- second\n--- third\n---- fourth");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ul style=\"list-style: square\"><li>first<ul><li>second<ul><li>third<ul><li>fourth</li></ul></li></ul></li></ul></li></ul>"));
    }

    @Test
    public void testImage() {
        String html = this.parser.parseToHtml("an !image.png! image");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>an <img border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    @Test
    public void testImageWithFullUrl() {
        String html = this.parser.parseToHtml("an !http://www.foo.com/bin/image.png! image");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>an <img border=\"0\" src=\"http://www.foo.com/bin/image.png\"/> image</p></body>"));
    }

    @Test
    public void testImageWithAttributesAlignRight() {
        String html = this.parser.parseToHtml("an !image.png|align=right! image");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>an <img align=\"right\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    @Test
    public void testImageWithAttributesAlignLeft() {
        String html = this.parser.parseToHtml("an !image.png|align=left! image");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>an <img align=\"left\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    @Test
    public void testImageWithAttributesAlignMiddle() {
        String html = this.parser.parseToHtml("an !image.png|align=middle! image");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>an <img align=\"middle\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    @Test
    public void testImageWithAttributesAlignCenter() {
        String html = this.parser.parseToHtml("an !image.png|align=center! image");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>an <div style=\"text-align: center;\"><img border=\"0\" src=\"image.png\"/></div> image</p></body>"));
    }

    @Test
    public void testImageWithAttributesAlignCenterToDocbook() {
        StringWriter out = new StringWriter();
        DocBookDocumentBuilder builder = new DocBookDocumentBuilder((Writer)out);
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("an !image.png|align=center! image");
        String result = out.toString();
        TestUtil.println("DocBook: \n" + result);
        Assert.assertTrue((boolean)result.contains("<para>an <mediaobject><imageobject><imagedata fileref=\"image.png\"/></imageobject></mediaobject> image</para>"));
    }

    @Test
    public void testImageWithAttributesAlt() {
        String html = this.parser.parseToHtml("an !image.png|alt= some alt text! image");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>an <img alt=\"some alt text\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    @Test
    public void testImageWithAttributesBorder() {
        String html = this.parser.parseToHtml("an !image.png|border=5! image");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>an <img border=\"5\" src=\"image.png\"/> image</p></body>"));
    }

    @Test
    public void testImageWithAttributesWidth() {
        String html = this.parser.parseToHtml("an !image.png|width=5! image");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>an <img width=\"5\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    @Test
    public void testImageWithAttributesHeight() {
        String html = this.parser.parseToHtml("an !image.png|height=5! image");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>an <img height=\"5\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    @Test
    public void testImageWithAttributesHeightBadValue() {
        String html = this.parser.parseToHtml("an !image.png|height=5a! image");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>an <img border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    @Test
    public void testImageNegativeMatch() {
        String html = this.parser.parseToHtml("I really like ice cream! Yay!");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>I really like ice cream! Yay!</p></body>"));
    }

    @Test
    public void testTable() {
        String html = this.parser.parseToHtml("|a|row|not header|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><table><tr><td>a</td><td>row</td><td>not header</td></tr></table></body>"));
    }

    @Test
    public void testTableWithHeader() {
        String html = this.parser.parseToHtml("||a||header||row||\n|a|row|not header|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><table><tr><th>a</th><th>header</th><th>row</th></tr><tr><td>a</td><td>row</td><td>not header</td></tr></table></body>"));
    }

    @Test
    public void testTableNestedWithHeader() {
        String html = this.parser.parseToHtml("a para\n||a||header||row||\n|a|row|not header|\ntail");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a para</p><table><tr><th>a</th><th>header</th><th>row</th></tr><tr><td>a</td><td>row</td><td>not header</td></tr></table><p>tail</p></body>"));
    }

    @Test
    public void testTableWithLinkAndPipes() {
        String html = this.parser.parseToHtml("| [Website|https://textile-j.dev.java.net/] |");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><table><tr><td> <a href=\"https://textile-j.dev.java.net/\">Website</a> </td></tr></table></body>"));
    }

    @Test
    public void testTableWithLinkAndPipes2() {
        String html = this.parser.parseToHtml("| [Website|https://textile-j.dev.java.net/] | another cell | [Eclipse|http://www.eclipse.org] |");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><table><tr><td> <a href=\"https://textile-j.dev.java.net/\">Website</a> </td><td> another cell </td><td> <a href=\"http://www.eclipse.org\">Eclipse</a> </td></tr></table></body>"));
    }

    @Test
    public void testPreformattedExtended() {
        String html = this.parser.parseToHtml("{noformat}\na multiline\n\tpreformatted\n\nwith two paras\n{noformat}\nanother para");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)Pattern.compile("body><pre>a multiline\\s+preformatted\\s+with two paras\\s+</pre><p>another para</p></body>", 8).matcher(html).find());
    }

    @Test
    public void testPreformattedExtended2() {
        String html = this.parser.parseToHtml("{noformat}\na multiline\n\tpreformatted\n\nwith two paras{noformat}another para");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)html.contains("<body><pre>a multiline"));
        Assert.assertTrue((boolean)html.contains("</pre><p>another para</p></body>"));
        Assert.assertTrue((boolean)Pattern.compile("with two paras\\s*</pre>", 8).matcher(html).find());
    }

    @Test
    public void testNote() {
        String html = this.parser.parseToHtml("h1. a header\n\nSome text\n{note:title=A Title}\nthe body of the note\nwhich may span multiple lines\n\nAnd may even have multiple paragraphs or *other* _textile_ ??markup??\n{note}\nMore text...");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)html.contains("<p>Some text</p><div class=\"note\""));
        Assert.assertTrue((boolean)html.contains("</p></div><p>More text...</p>"));
        Assert.assertTrue((boolean)html.contains("or <strong>other</strong> <em>textile</em> <cite>markup</cite>"));
        Assert.assertFalse((boolean)html.contains("{note"));
    }

    @Test
    public void testNote2() {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setUseInlineStyles(false);
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("{note}this is a note {note}\n\n* one thing\n* two things");
        String html = out.toString();
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)html.contains("<body><div class=\"note\"><p>this is a note </p></div><ul><li>one thing</li><li>two things</li></ul></body>"));
    }

    @Test
    public void testNote3() {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setUseInlineStyles(false);
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("{note}this is a note {note}*bold* text\nfoo\n\nbar");
        String html = out.toString();
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)html.contains("<body><div class=\"note\"><p>this is a note </p></div><p><strong>bold</strong> text<br/>foo</p><p>bar</p></body>"));
    }

    @Test
    public void testNote4() {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setUseInlineStyles(false);
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("abc{note}this is a note {note}*bold* text\nfoo\n\nbar");
        String html = out.toString();
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>abc</p><div class=\"note\"><p>this is a note </p></div><p><strong>bold</strong> text<br/>foo</p><p>bar</p></body>"));
    }

    @Test
    public void testInfo() {
        String html = this.parser.parseToHtml("h1. a header\n\nSome text\n{info:title=A Title}\nthe body of the note\nwhich may span multiple lines\n\nAnd may even have multiple paragraphs or *other* _textile_ ??markup??\n{info}\nMore text...");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)html.contains("<p>Some text</p><div class=\"info\""));
        Assert.assertTrue((boolean)html.contains("</p></div><p>More text...</p>"));
        Assert.assertTrue((boolean)html.contains("or <strong>other</strong> <em>textile</em> <cite>markup</cite>"));
        Assert.assertFalse((boolean)html.contains("{info"));
    }

    @Test
    public void testWarning() {
        String html = this.parser.parseToHtml("h1. a header\n\nSome text\n{warning:title=A Title}\nthe body of the note\nwhich may span multiple lines\n\nAnd may even have multiple paragraphs or *other* _textile_ ??markup??\n{warning}\nMore text...");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)html.contains("<p>Some text</p><div class=\"warning\""));
        Assert.assertTrue((boolean)html.contains("</p></div><p>More text...</p>"));
        Assert.assertTrue((boolean)html.contains("or <strong>other</strong> <em>textile</em> <cite>markup</cite>"));
        Assert.assertFalse((boolean)html.contains("{warning"));
    }

    @Test
    public void testTip() {
        String html = this.parser.parseToHtml("h1. a header\n\nSome text\n{tip:title=A Title}\nthe body of the note\nwhich may span multiple lines\n\nAnd may even have multiple paragraphs or *other* _textile_ ??markup??\n{tip}\nMore text...");
        TestUtil.println("HTML:" + html);
        Assert.assertTrue((boolean)html.contains("<p>Some text</p><div class=\"tip\""));
        Assert.assertTrue((boolean)html.contains("</p></div><p>More text...</p>"));
        Assert.assertTrue((boolean)html.contains("or <strong>other</strong> <em>textile</em> <cite>markup</cite>"));
        Assert.assertFalse((boolean)html.contains("{tip"));
    }

    @Test
    public void testTipToDocBook() {
        StringWriter out = new StringWriter();
        this.parser.setBuilder((DocumentBuilder)new DocBookDocumentBuilder((Writer)out));
        this.parser.parse("h1. a header\n\nSome text\n{tip:title=A Title}\nthe body of the note\nwhich may span multiple lines\n\nAnd may even have multiple paragraphs or *other* _textile_ ??markup??\n{tip}\nMore text...");
        String docbook = out.toString();
        TestUtil.println("DocBook: " + docbook);
        Assert.assertTrue((boolean)docbook.contains("<tip><title>A Title</title><para>the body of"));
        Assert.assertTrue((boolean)docbook.contains("paragraphs or <emphasis role=\"bold\">other</emphasis> <emphasis>textile</emphasis> <citation>markup</citation></para></tip>"));
    }

    @Test
    public void testTableOfContents() throws IOException {
        String html = this.parser.parseToHtml("h1. Table Of Contents\n\n{toc}\n\nh1. Top Header\n\nsome text\n\nh2. Subhead\n\nh2. Subhead2\n\nh1. Top Header 2\n\nh2. Subhead 3\n\nh3. Subhead 4");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"#Subhead2\">"));
        Assert.assertTrue((boolean)html.contains("<h2 id=\"Subhead2\">"));
        Assert.assertTrue((boolean)html.contains("href=\"#Subhead4\""));
        Assert.assertTrue((boolean)html.contains("<h3 id=\"Subhead4\">"));
    }

    @Test
    public void testTableOfContentsWithMaxLevel() throws IOException {
        String html = this.parser.parseToHtml("h1. Table Of Contents\n\n{toc:maxLevel=2}\n\nh1. Top Header\n\nsome text\n\nh2. Subhead\n\nh2. Subhead2\n\nh1. Top Header 2\n\nh2. Subhead 3\n\nh3. Subhead 4");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"#Subhead2\">"));
        Assert.assertTrue((boolean)html.contains("<h2 id=\"Subhead2\">"));
        Assert.assertFalse((boolean)html.contains("href=\"#Subhead4\""));
        Assert.assertTrue((boolean)html.contains("<h3 id=\"Subhead4\">"));
    }

    @Test
    public void testBoldItalicsBold() {
        String html = this.parser.parseToHtml("*bold _ital ics_ bold*");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<strong>bold <em>ital ics</em> bold</strong>"));
    }

    @Test
    public void testItalicsBold() {
        String html = this.parser.parseToHtml("_italics *bol d* italics_");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<em>italics <strong>bol d</strong> italics</em>"));
    }

    @Test
    public void testItalics() {
        this.assertMarkup("<p><em>italics</em></p>", "_italics_");
    }

    @Test
    public void testDoubleUnderscore() {
        this.assertMarkup("<p>__italics__</p>", "__italics__");
    }

    @Test
    public void testItalicsNegativeMatchTrailingWhitespace() {
        this.assertMarkup("<p>_italics _</p>", "_italics _");
    }

    @Test
    public void testItalicsNegativeMatchLeadingWhitespace() {
        this.assertMarkup("<p>_ italics_</p>", "_ italics_");
    }

    @Test
    public void testItalicsNegativeMatchNoContent() {
        this.assertMarkup("<p>__</p>", "__");
    }

    @Test
    public void testItalicsNegativeMatchNoTerminator() {
        this.assertMarkup("<p>_some text_here no end</p>", "_some text_here no end");
    }

    @Test
    public void testItalicsContainsUnderscore() {
        this.assertMarkup("<p><em>some text_here with</em> end</p>", "_some text_here with_ end");
    }

    @Test
    public void testItalicsNonGreedy() {
        this.assertMarkup("<p><em>italics</em> a_</p>", "_italics_ a_");
    }

    @Test
    public void testItalicsNonGreedy2() {
        this.assertMarkup("<p>some <em>italics</em> and <em>more italics</em> here</p>", "some _italics_ and _more italics_ here");
    }

    @Test
    public void testHyperlinkWithItalics() {
        this.assertMarkup("<p><a href=\"http://my_url.jpg\"><em>This is a test</em></a></p>", "[_This is a test_|http://my_url.jpg]");
    }

    @Test
    public void testHyperlinkWithBold() {
        this.assertMarkup("<p><a href=\"http://my_url.jpg\"><strong>This is a test</strong></a></p>", "[*This is a test*|http://my_url.jpg]");
    }

    @Test
    public void testHyperlinkWithBoldItalics() {
        this.assertMarkup("<p><a href=\"http://my_url.jpg\"><strong><em>This is a test</em></strong></a></p>", "[*_This is a test_*|http://my_url.jpg]");
    }

    @Test
    public void testBoldItalics() {
        String html = this.parser.parseToHtml("*_bold and italic_ not just bold*");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<strong><em>bold and italic</em> not just bold</strong>"));
    }

    @Test
    public void testInlineQuote() {
        String html = this.parser.parseToHtml("a paragraph {quote}with inline{quote} quote");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><p>a paragraph <q>with inline</q> quote</p></body>"));
    }

    @Test
    public void testInlineQuoteWithBullets() {
        String html = this.parser.parseToHtml("* a bullet {quote}with inline{quote} quote");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><ul><li>a bullet <q>with inline</q> quote</li></ul></body>"));
    }

    @Test
    public void testInlineQuoteWithBullets2() {
        String html = this.parser.parseToHtml("* {quote}a bullet with inline{quote} quote");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><ul><li><q>a bullet with inline</q> quote</li></ul></body>"));
    }

    @Test
    public void testInlineQuoteNegativeMatch() {
        String html = this.parser.parseToHtml("a paragraph {quote}with inline quote");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><p>a paragraph {quote}with inline quote</p></body>"));
    }

    @Test
    public void testInlineQuoteNegativeMatch2() {
        String html = this.parser.parseToHtml("{quote}a paragraph with {quote}inline quote{quote}");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><blockquote><p>a paragraph with </p></blockquote><p>inline quote{quote}</p></body>"));
    }

    @Test
    public void testColor() {
        String html = this.parser.parseToHtml("{color:red}\na paragraph\n\nanother paragraph\n{color}\ntext");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><div style=\"color: red;\"><p>a paragraph</p><p>another paragraph</p></div><p>text</p></body>"));
    }

    @Test
    public void testColor2() {
        String html = this.parser.parseToHtml("{color:red}a paragraph\n\nanother paragraph{color}text");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><div style=\"color: red;\"><p>a paragraph</p><p>another paragraph</p></div><p>text</p></body>"));
    }

    @Test
    public void testColor3() {
        String html = this.parser.parseToHtml("text {color:red}more text{color} text");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><p>text <span style=\"color: red;\">more text</span> text</p></body>"));
    }

    @Test
    public void testColor4() {
        String html = this.parser.parseToHtml("text\n{color:red}more text{color}\ntext");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><p>text</p><div style=\"color: red;\"><p>more text</p></div><p>text</p></body>"));
    }

    @Test
    public void testColorLexicalOffsets() {
        RecordingDocumentBuilder builder = new RecordingDocumentBuilder();
        this.parser.setBuilder((DocumentBuilder)builder);
        TestUtil.println("views to help SOA  development. These includes [SOA Services Explorer](in green) for the list of all available SOA services,\n[Types Explorer](in {color:#0000ff}blue{color}) for searching and browsing all available ");
        this.parser.parse("views to help SOA  development. These includes [SOA Services Explorer](in green) for the list of all available SOA services,\n[Types Explorer](in {color:#0000ff}blue{color}) for searching and browsing all available ");
        TestUtil.println("Events: \n" + (Object)((Object)builder));
        int previousDocumentOffset = -1;
        for (RecordingDocumentBuilder.Event event : builder.getEvents()) {
            Assert.assertTrue((previousDocumentOffset <= event.locator.getDocumentOffset() ? 1 : 0) != 0);
            previousDocumentOffset = event.locator.getDocumentOffset();
            if (event.text == null) continue;
            int start = event.locator.getDocumentOffset();
            int end = event.locator.getLineSegmentEndOffset() + event.locator.getLineDocumentOffset();
            Assert.assertEquals((long)event.text.length(), (long)(end - start));
            Assert.assertTrue((end >= start ? 1 : 0) != 0);
            Assert.assertEquals((Object)"views to help SOA  development. These includes [SOA Services Explorer](in green) for the list of all available SOA services,\n[Types Explorer](in {color:#0000ff}blue{color}) for searching and browsing all available ".substring(start, end), (Object)event.text);
        }
    }

    @Test
    public void testHangOnBug318695() throws IOException {
        String content = Resources.toString((URL)ConfluenceLanguageTest.class.getResource("resources/bug318695.confluence"), (Charset)Charsets.UTF_8);
        this.parser.setBuilder((DocumentBuilder)new HtmlDocumentBuilder((Writer)new StringWriter()));
        this.parser.parse((Reader)new StringReader(content));
    }

    @Test
    public void stackOverflowWithLargeContentOnBug424387() throws IOException {
        String content = Resources.toString((URL)ConfluenceLanguageTest.class.getResource("resources/bug424387.confluence"), (Charset)Charsets.UTF_8);
        this.parser.setBuilder((DocumentBuilder)new HtmlDocumentBuilder((Writer)new StringWriter()));
        this.parser.parse((Reader)new StringReader(content));
    }

    @Test
    public void testParagraphWithSingleNewline() {
        String html = this.parser.parseToHtml("one\ntwo\n\nthree");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><p>one<br/>two</p><p>three</p></body>"));
    }

    @Test
    public void testParagraphWithMultipleNewlines() {
        String html = this.parser.parseToHtml("one\n\\\\\\\\two\n\nthree");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><p>one<br/><br/><br/>two</p><p>three</p></body>"));
    }

    @Test
    public void testParagraphWithMultipleNewlines2() {
        String html = this.parser.parseToHtml("one\\\\\\\\\\\\two\n\nthree");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><p>one<br/><br/><br/>two</p><p>three</p></body>"));
    }

    @Test
    public void testListItemWithNewline() {
        String html = this.parser.parseToHtml("* one\ntwo\n* three");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><ul><li>one<br/>two</li><li>three</li></ul></body>"));
    }

    @Test
    public void testListItemWithTwoNewlines() {
        String html = this.parser.parseToHtml("* one\n\ntwo\n* three");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><ul><li>one</li></ul><p>two</p><ul><li>three</li></ul></body>"));
    }
}

