/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.mylyn.internal.wikitext.core.ant.MarkupToEclipseHelpTask;
import org.eclipse.mylyn.internal.wikitext.core.ant.MarkupToHtmlTask;
import org.eclipse.mylyn.internal.wikitext.core.ant.MarkupToHtmlTaskTest;
import org.eclipse.mylyn.wikitext.tests.TestUtil;

public class MarkupToEclipseHelpTaskTest
extends MarkupToHtmlTaskTest {
    @Override
    protected MarkupToHtmlTask createTask() {
        return new MarkupToEclipseHelpTask();
    }

    @Override
    public void testSimpleOutput() throws IOException {
        super.testSimpleOutput();
        File tocFile = new File(this.tempFolder, "markup-toc.xml");
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocFile.exists());
        String tocContent = this.getContent(tocFile);
        TestUtil.println(tocContent);
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<toc topic=\"markup.html\" label=\"markup\">"));
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<topic href=\"markup.html\" label=\"First Heading\""));
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<topic href=\"markup.html#SecondHeading\" label=\"Second Heading\""));
    }

    @Override
    public void testMultipleFiles() throws IOException {
        super.testMultipleFiles();
        File tocFile = new File(this.tempFolder, "markup-toc.xml");
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocFile.exists());
        String tocContent = this.getContent(tocFile);
        TestUtil.println(tocContent);
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<toc topic=\"markup.html\" label=\"markup\">"));
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<topic href=\"markup.html\" label=\"First Heading\""));
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<topic href=\"Second-Heading.html\" label=\"Second Heading\""));
    }

    @Override
    public void testSimpleOutputAlternateTitle() throws IOException {
        super.testSimpleOutputAlternateTitle();
        File tocFile = new File(this.tempFolder, "markup-toc.xml");
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocFile.exists());
        String tocContent = this.getContent(tocFile);
        TestUtil.println(tocContent);
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<toc topic=\"markup.html\" label=\"Alternate Title\">"));
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<topic href=\"markup.html\" label=\"First Heading\""));
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<topic href=\"markup.html#SecondHeading\" label=\"Second Heading\""));
    }

    public void testMultipleFilesWithMultiLevelHeadings() throws IOException {
        File markup = this.createSimpleTextileMarkupWithMultiLevelHeadings();
        this.task.setFile(markup);
        this.task.setMultipleOutputFiles(true);
        this.task.execute();
        this.listFiles();
        File tocFile = new File(this.tempFolder, "markup-toc.xml");
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocFile.exists());
        String tocContent = this.getContent(tocFile);
        TestUtil.println(tocContent);
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<toc topic=\"markup.html\" label=\"markup\">"));
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<topic href=\"markup.html\" label=\"First Heading\""));
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<topic href=\"Second-Heading.html\" label=\"Second Heading\""));
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<topic href=\"Second-Heading.html#SecondL2\" label=\"Second L2\""));
        MarkupToEclipseHelpTaskTest.assertTrue((boolean)tocContent.contains("<topic href=\"Second-Heading.html#SecondL22\" label=\"Second L2 2\""));
    }

    protected File createSimpleTextileMarkupWithMultiLevelHeadings() throws IOException {
        File markupFile = new File(this.tempFolder, "markup.textile");
        PrintWriter writer = new PrintWriter(new FileWriter(markupFile));
        try {
            writer.println("h1. First Heading");
            writer.println();
            writer.println("some content");
            writer.println();
            writer.println("h1. Second Heading");
            writer.println();
            writer.println("some more content");
            writer.println();
            writer.println("h2. Second L2");
            writer.println();
            writer.println("some content");
            writer.println();
            writer.println("h2. Second L2 2");
            writer.println();
            writer.println("some content");
            writer.println();
        }
        finally {
            writer.close();
        }
        return markupFile;
    }

    @Override
    public void testTaskdef() {
        MarkupToEclipseHelpTaskTest.assertEquals((String)MarkupToEclipseHelpTask.class.getName(), (String)this.loadTaskdefBundle().getString("wikitext-to-eclipse-help"));
    }
}

