/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.outline;

import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.internal.wikitext.ui.editor.outline.Messages;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

public class QuickOutlinePopupDialog
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2 {
    private FilteredTree filteredTree;
    private final IShowInTarget showInTarget;
    private PatternFilter patternFilter;

    public QuickOutlinePopupDialog(Shell parent, IShowInTarget showInTarget) {
        super(parent, 16, true, true, false, false, null, null);
        this.showInTarget = showInTarget;
        this.setInfoText(Messages.QuickOutlinePopupDialog_infoText);
        this.create();
    }

    protected Control createTitleControl(Composite parent) {
        Text fileterText = new Text(parent, 128);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)fileterText);
        return fileterText;
    }

    protected Control createDialogArea(Composite parent) {
        this.patternFilter = new PatternFilter();
        this.filteredTree = new FilteredTree(parent, 2818, this.patternFilter, true);
        int heightHint = this.filteredTree.getViewer().getTree().getItemHeight() * 12 + Math.max(this.filteredTree.getFilterControl().getSize().y, 12);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, heightHint).applyTo((Control)this.filteredTree);
        this.filteredTree.getViewer().setUseHashlookup(true);
        this.filteredTree.getViewer().setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.filteredTree.getViewer().setAutoExpandLevel(-1);
        this.filteredTree.getViewer().getTree().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickOutlinePopupDialog.this.handleSelection();
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.filteredTree.getViewer().getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    QuickOutlinePopupDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.filteredTree.getViewer().getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Tree tree = QuickOutlinePopupDialog.this.filteredTree.getViewer().getTree();
                if (tree.getSelectionCount() < 1 || e.button != 1) {
                    return;
                }
                TreeItem object = tree.getItem(new Point(e.x, e.y));
                TreeItem selection = tree.getSelection()[0];
                if (selection.equals(object)) {
                    QuickOutlinePopupDialog.this.handleSelection();
                }
            }
        });
        return this.filteredTree;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void dispose() {
        this.close();
    }

    public boolean isFocusControl() {
        return this.filteredTree.isFocusControl() || this.filteredTree.getFilterControl().isFocusControl() || this.filteredTree.getViewer().getTree().isFocusControl();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.filteredTree.getFilterControl().setFocus();
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setInformation(String information) {
    }

    public void setLocation(Point location) {
        this.getShell().setLocation(location);
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public boolean hasContents() {
        return this.filteredTree != null && this.filteredTree.getViewer().getInput() != null;
    }

    public void setInput(Object input) {
        this.filteredTree.getViewer().setInput(input);
    }

    private void handleSelection() {
        ISelection selection;
        if (this.showInTarget != null && !(selection = this.filteredTree.getViewer().getSelection()).isEmpty()) {
            this.showInTarget.show(new ShowInContext(null, selection));
        }
        this.dispose();
    }
}

