/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesReader;
import org.w3c.dom.Document;

public class MimeTypesFactory {
    public static MimeTypes create() {
        return new MimeTypes();
    }

    public static MimeTypes create(Document document) throws MimeTypeException {
        MimeTypes mimeTypes = new MimeTypes();
        new MimeTypesReader(mimeTypes).read(document);
        mimeTypes.init();
        return mimeTypes;
    }

    public static MimeTypes create(InputStream ... inputStreams) throws IOException, MimeTypeException {
        MimeTypes mimeTypes = new MimeTypes();
        MimeTypesReader reader = new MimeTypesReader(mimeTypes);
        InputStream[] inputStreamArray = inputStreams;
        int n = inputStreams.length;
        int n2 = 0;
        while (n2 < n) {
            InputStream inputStream = inputStreamArray[n2];
            reader.read(inputStream);
            ++n2;
        }
        mimeTypes.init();
        return mimeTypes;
    }

    public static MimeTypes create(InputStream stream) throws IOException, MimeTypeException {
        return MimeTypesFactory.create(new InputStream[]{stream});
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MimeTypes create(URL ... urls) throws IOException, MimeTypeException {
        streams = new InputStream[urls.length];
        i = 0;
        while (i < streams.length) {
            streams[i] = urls[i].openStream();
            ++i;
        }
        try {
            var3_4 = MimeTypesFactory.create(streams);
            return var3_4;
        }
        finally {
            var7_5 = streams;
            var6_7 = streams.length;
            var5_9 = 0;
            ** while (var5_9 < var6_7)
        }
lbl-1000:
        // 1 sources

        {
            stream = var7_5[var5_9];
            stream.close();
            ++var5_9;
            continue;
        }
lbl19:
        // 1 sources

        return var3_4;
    }

    public static MimeTypes create(URL url) throws IOException, MimeTypeException {
        return MimeTypesFactory.create(new URL[]{url});
    }

    public static MimeTypes create(String filePath) throws IOException, MimeTypeException {
        return MimeTypesFactory.create(MimeTypesReader.class.getResource(filePath));
    }

    public static MimeTypes create(String coreFilePath, String extensionFilePath) throws IOException, MimeTypeException {
        String classPrefix = String.valueOf(MimeTypesReader.class.getPackage().getName().replace('.', '/')) + "/";
        ClassLoader cl = MimeTypesReader.class.getClassLoader();
        URL coreURL = cl.getResource(String.valueOf(classPrefix) + coreFilePath);
        ArrayList<URL> extensionURLs = Collections.list(cl.getResources(String.valueOf(classPrefix) + extensionFilePath));
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(coreURL);
        urls.addAll(extensionURLs);
        return MimeTypesFactory.create(urls.toArray(new URL[urls.size()]));
    }
}

