/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.model.Node;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeInstallableUnitItem;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.epp.mpc.core.model.IIu;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.service.QueryHelper;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.service.datalocation.Location;

public class MarketplaceInfo {
    public static final String MPC_NODE_IU_PROPERTY = "org.eclipse.epp.mpc.node";
    public static final String MPC_FEATURE_IU = "org.eclipse.epp.mpc.feature.group";
    public static final String MPC_FEATURE_SITE = "http://download.eclipse.org/mpc";
    public static final String MPC_NODE_PATH = "/content/eclipse-marketplace-client";
    private static final String P2_FEATURE_GROUP_SUFFIX = ".feature.group";
    private static final String PERSISTENT_FILE = String.valueOf(MarketplaceInfo.class.getSimpleName()) + ".xml";
    private Map<String, List<String>> nodeKeyToIU = new HashMap<String, List<String>>();
    private Map<String, List<String>> iuToNodeKey = new HashMap<String, List<String>>();

    public MarketplaceInfo() {
    }

    public MarketplaceInfo(MarketplaceInfo info) {
        this();
        this.nodeKeyToIU.putAll(info.getNodeKeyToIU());
        this.iuToNodeKey.putAll(info.getIuToNodeKey());
    }

    public Map<String, List<String>> getNodeKeyToIU() {
        return this.nodeKeyToIU;
    }

    public void setNodeKeyToIU(Map<String, List<String>> nodeKeyToIU) {
        this.nodeKeyToIU = nodeKeyToIU;
    }

    public Map<String, List<String>> getIuToNodeKey() {
        return this.iuToNodeKey;
    }

    public void setIuToNodeKey(Map<String, List<String>> iuToNodeKey) {
        this.iuToNodeKey = iuToNodeKey;
    }

    @Deprecated
    public synchronized Set<INode> computeInstalledNodes(URL repositoryUrl, Set<String> installedIus) {
        HashSet<INode> nodes = new HashSet<INode>();
        String keyPrefix = String.valueOf(this.computeUrlKey(repositoryUrl)) + '#';
        for (Map.Entry<String, List<String>> entry : this.nodeKeyToIU.entrySet()) {
            List<String> ius;
            if (!entry.getKey().startsWith(keyPrefix) || !this.computeInstalled(installedIus, ius = this.nodeKeyToIU.get(entry.getKey()), false)) continue;
            String nodeId = entry.getKey().substring(keyPrefix.length());
            Node node = new Node();
            node.setId(nodeId);
            nodes.add((INode)node);
        }
        return nodes;
    }

    public synchronized Set<INode> computeInstalledNodes(URL repositoryUrl, Map<String, IInstallableUnit> installedIus) {
        HashSet<INode> nodes = new HashSet<INode>();
        String keyPrefix = String.valueOf(this.computeUrlKey(repositoryUrl)) + '#';
        for (Map.Entry<String, List<String>> entry : this.nodeKeyToIU.entrySet()) {
            if (!entry.getKey().startsWith(keyPrefix)) continue;
            List<String> ius = this.nodeKeyToIU.get(entry.getKey());
            if (!this.computeInstalled(installedIus.keySet(), ius, false)) continue;
            String nodeId = entry.getKey().substring(keyPrefix.length());
            INode node = QueryHelper.nodeById((String)nodeId);
            nodes.add(node);
        }
        for (IInstallableUnit iu : installedIus.values()) {
            String[] nodeUrls;
            String nodeUrlsValue = iu.getProperty(MPC_NODE_IU_PROPERTY);
            if (nodeUrlsValue == null) continue;
            String[] stringArray = nodeUrls = nodeUrlsValue == null ? null : nodeUrlsValue.split("(\\s*,\\s*|\\s+)");
            int n = nodeUrls.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeUrl = stringArray[n2];
                if (nodeUrl.startsWith(repositoryUrl.toString())) {
                    INode node = QueryHelper.nodeByUrl((String)nodeUrl);
                    nodes.add(node);
                }
                ++n2;
            }
        }
        return nodes;
    }

    @Deprecated
    public boolean computeInstalled(Set<String> installedFeatures, Set<URI> knownRepositories, INode node) {
        String updateurl = node.getUpdateurl();
        if (updateurl == null) {
            return false;
        }
        boolean installed = this.computeInstalled(installedFeatures, node);
        if (installed && knownRepositories != null) {
            try {
                URI uri = URLUtil.toURI((String)node.getUpdateurl());
                if (!knownRepositories.contains(uri)) {
                    return false;
                }
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return installed;
    }

    public boolean computeInstalled(Set<String> installedFeatures, INode node) {
        if (node.getIus() != null && !node.getIus().getIuElements().isEmpty()) {
            boolean all = true;
            HashSet<String> ius = new HashSet<String>();
            for (IIu iu : node.getIus().getIuElements()) {
                if (iu.isOptional()) continue;
                ius.add(iu.getId());
            }
            if (ius.isEmpty()) {
                all = false;
                for (IIu iu : node.getIus().getIuElements()) {
                    ius.add(iu.getId());
                }
            }
            return this.computeInstalled(installedFeatures, ius, all);
        }
        return false;
    }

    private boolean computeInstalled(Set<String> installedIus, Collection<String> ius, boolean all) {
        int installCount = 0;
        for (String iu : ius) {
            if (!this.computeInstalled(installedIus, iu)) continue;
            ++installCount;
        }
        return all ? installCount == ius.size() : installCount > 0;
    }

    public void computeInstalled(Set<String> installedFeatures, MarketplaceNodeCatalogItem catalogItem) {
        List<MarketplaceNodeInstallableUnitItem> installableUnitItems = catalogItem.getInstallableUnitItems();
        boolean installed = false;
        if (installableUnitItems != null) {
            boolean anyInstalled = false;
            boolean requiredInstalled = true;
            for (MarketplaceNodeInstallableUnitItem installableUnitItem : installableUnitItems) {
                boolean iuInstalled = this.computeInstalled(installedFeatures, installableUnitItem.getId());
                installableUnitItem.setInstalled(iuInstalled);
                if (iuInstalled) {
                    anyInstalled = true;
                    continue;
                }
                if (installableUnitItem.isOptional()) continue;
                requiredInstalled = false;
            }
            installed = requiredInstalled && anyInstalled;
        }
        catalogItem.setInstalled(installed);
    }

    private boolean computeInstalled(Set<String> installedIus, String iu) {
        return installedIus.contains(iu) || installedIus.contains(String.valueOf(iu) + P2_FEATURE_GROUP_SUFFIX);
    }

    public synchronized void map(URL marketUrl, INode node) {
        block5: {
            String itemKey;
            block4: {
                itemKey = this.computeItemKey(marketUrl, node);
                if (node.getIus() == null || node.getIus().getIuElements().isEmpty()) break block4;
                ArrayList<String> ius = new ArrayList<String>();
                HashSet<String> uniqueIus = new HashSet<String>();
                List iuElements = node.getIus().getIuElements();
                for (IIu iIu : iuElements) {
                    if (!uniqueIus.add(iIu.getId())) continue;
                    ius.add(iIu.getId());
                }
                this.nodeKeyToIU.put(itemKey, ius);
                for (String iu : ius) {
                    List<String> catalogNodes = this.iuToNodeKey.get(iu);
                    if (catalogNodes != null) {
                        if (catalogNodes.contains(itemKey)) continue;
                        catalogNodes.add(itemKey);
                        continue;
                    }
                    catalogNodes = new ArrayList<String>(1);
                    catalogNodes.add(itemKey);
                    this.iuToNodeKey.put(iu, catalogNodes);
                }
                break block5;
            }
            List<String> ius = this.nodeKeyToIU.remove(itemKey);
            if (ius == null) break block5;
            for (String iu : ius) {
                List<String> catalogNodes = this.iuToNodeKey.get(iu);
                if (catalogNodes == null) continue;
                catalogNodes.remove(itemKey);
                if (!catalogNodes.isEmpty()) continue;
                this.iuToNodeKey.remove(iu);
            }
        }
    }

    private String computeItemKey(URL marketUrl, INode item) {
        return String.valueOf(this.computeUrlKey(marketUrl)) + '#' + item.getId();
    }

    private String computeUrlKey(URL url) {
        try {
            return url.toURI().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isMPCNode(INode item) {
        if (item.getUpdateurl() != null) {
            return item.getUpdateurl().startsWith(MPC_FEATURE_SITE);
        }
        if (item.getUrl() != null) {
            return item.getUrl().endsWith(MPC_NODE_PATH) || item.getUrl().endsWith("/content/eclipse-marketplace-client/");
        }
        return false;
    }

    public static MarketplaceInfo getInstance() {
        MarketplaceInfo info = new MarketplaceInfo();
        MarketplaceInfo loaded = info.load();
        return loaded != null ? loaded : info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarketplaceInfo load() {
        try {
            RegistryFile registryFile = this.createRegistryFile();
            File loadFile = registryFile.load();
            if (loadFile == null) return null;
            if (!loadFile.canRead()) return null;
            Class<MarketplaceInfo> clazz = MarketplaceInfo.class;
            synchronized (MarketplaceInfo.class) {
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(loadFile));){
                    XMLDecoder decoder = new XMLDecoder(in);
                    Object object = decoder.readObject();
                    decoder.close();
                    MarketplaceInfo marketplaceInfo = (MarketplaceInfo)object;
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return marketplaceInfo;
                }
                catch (Throwable t) {
                    Status status = new Status(2, "org.eclipse.epp.mpc.ui", Messages.MarketplaceInfo_LoadError, t);
                    MarketplaceClientUi.getLog().log((IStatus)status);
                    loadFile.delete();
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return null;
                }
            }
        }
        catch (Exception ex) {
            MarketplaceClientUi.error(ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save() {
        RegistryFile registryFile = this.createRegistryFile();
        File saveFile = registryFile.save();
        if (saveFile == null) return;
        Class<MarketplaceInfo> clazz = MarketplaceInfo.class;
        synchronized (MarketplaceInfo.class) {
            this.save(saveFile);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void save(File registryFile) {
        try {
            File container = registryFile.getParentFile();
            if (container != null && !container.exists()) {
                container.mkdirs();
            }
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(registryFile));){
                XMLEncoder encoder = new XMLEncoder(outputStream);
                encoder.writeObject(this);
                encoder.close();
            }
        }
        catch (Throwable t) {
            MarketplaceClientUi.error(t);
        }
    }

    protected RegistryFile createRegistryFile() {
        String userHome;
        File userHomeFile;
        File dataFile;
        ArrayList<File> files = new ArrayList<File>();
        File configFile = this.computeConfigurationAreaRegistryFile();
        if (configFile != null) {
            files.add(configFile);
        }
        if ((dataFile = this.computeBundleRegistryFile()) != null) {
            files.add(dataFile);
        }
        if ((userHomeFile = new File(userHome = System.getProperty("user.home"))).exists()) {
            File userConfigFile = this.computeUserHomeRegistryFile(userHomeFile);
            File legacyConfigFile = this.computeLegacyUserHomeRegistryFile(userHomeFile);
            files.add(userConfigFile);
            files.add(legacyConfigFile);
        }
        return new RegistryFile(files.toArray(new File[files.size()]));
    }

    protected File computeConfigurationAreaRegistryFile() {
        URI uri;
        URL url;
        Location configurationLocation = Platform.getConfigurationLocation();
        URL uRL = url = configurationLocation == null ? null : configurationLocation.getURL();
        if (url == null) {
            return null;
        }
        try {
            url = FileLocator.resolve((URL)url);
            uri = URLUtil.toURI((String)url.toExternalForm());
        }
        catch (Exception e) {
            return null;
        }
        if (!"file".equals(uri.getScheme())) {
            return null;
        }
        File configurationArea = new File(uri);
        File mpcArea = new File(configurationArea, "org.eclipse.epp.mpc.ui");
        File dataFile = new File(mpcArea, PERSISTENT_FILE);
        return dataFile;
    }

    protected File computeBundleRegistryFile() {
        File dataFile = Platform.getBundle((String)"org.eclipse.epp.mpc.ui").getBundleContext().getDataFile(PERSISTENT_FILE);
        return dataFile;
    }

    protected File computeUserHomeRegistryFile(File userHome) {
        File eclipseConfigLocation = new File(userHome, ".eclipse/mpc");
        File configFile = MarketplaceInfo.computeConfigFile(eclipseConfigLocation);
        return configFile;
    }

    protected File computeLegacyUserHomeRegistryFile(File userHome) {
        File legacyConfigLocation = new File(userHome, ".eclipse_mpc");
        File legacyConfigFile = MarketplaceInfo.computeConfigFile(legacyConfigLocation);
        return legacyConfigFile;
    }

    private static File computeConfigFile(File mpcConfigLocation) {
        return new File(mpcConfigLocation, PERSISTENT_FILE);
    }

    protected static class RegistryFile {
        private final File[] locations;

        public RegistryFile(File ... locations) {
            this.locations = locations;
        }

        public RegistryFile(RegistryFile registryFile) {
            this(registryFile.getLocations());
        }

        protected File[] getLocations() {
            return this.locations;
        }

        public File load() {
            File[] fileArray = this.locations;
            int n = this.locations.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (this.isFile(file) && this.canRead(file)) {
                    return file;
                }
                ++n2;
            }
            if (this.locations.length > 0) {
                return this.locations[0];
            }
            return null;
        }

        public File save() {
            int i = 0;
            while (i < this.locations.length) {
                File file = this.locations[i];
                try {
                    if ((this.isDirectory(file.getParentFile()) || this.mkdirs(file.getParentFile())) && (this.isFile(file) && this.canWrite(file) || !this.exists(file) && this.createNewFile(file))) {
                        int j = i + 1;
                        while (j < this.locations.length) {
                            File parentFile = this.locations[j].getParentFile();
                            if (this.exists(parentFile)) {
                                if (this.locations[j].exists() && !this.locations[j].delete()) {
                                    this.locations[j].deleteOnExit();
                                }
                                if (!parentFile.delete()) {
                                    parentFile.deleteOnExit();
                                }
                            }
                            ++j;
                        }
                        return file;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++i;
            }
            if (this.locations.length > 0) {
                return this.locations[0];
            }
            return null;
        }

        protected boolean mkdirs(File file) {
            return file.mkdirs();
        }

        protected boolean isDirectory(File file) {
            return file.isDirectory();
        }

        protected boolean createNewFile(File file) throws IOException {
            return file.createNewFile();
        }

        protected boolean exists(File file) {
            return file.exists();
        }

        protected boolean canWrite(File file) {
            return file.canWrite();
        }

        protected boolean canRead(File file) {
            return file.canRead();
        }

        protected boolean isFile(File file) {
            return file.isFile();
        }
    }
}

