/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.model.SearchResult;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeInstallableUnitItem;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.epp.internal.mpc.ui.util.ConcurrentTaskManager;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INews;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.util.NLS;

public class MarketplaceCatalog
extends Catalog {
    private final Map<String, Version> repositoryIuVersionById = new HashMap<String, Version>();
    private INews news;
    private List<MarketplaceNodeCatalogItem> availableUpdates = new ArrayList<MarketplaceNodeCatalogItem>();

    public IStatus performQuery(IMarket market, ICategory category, String queryText, IProgressMonitor monitor) {
        return this.performDiscovery((strategy, monitor1) -> strategy.performQuery(market, category, queryText, monitor1), false, monitor);
    }

    public IStatus tagged(String tag, IProgressMonitor monitor) {
        return this.performDiscovery((strategy, monitor1) -> strategy.tagged(tag, monitor1), false, monitor);
    }

    public IStatus related(IProgressMonitor monitor) {
        return this.performDiscovery((strategy, monitor1) -> strategy.related(monitor1), false, monitor);
    }

    public IStatus recent(IProgressMonitor monitor) {
        return this.performDiscovery((strategy, monitor1) -> strategy.recent(monitor1), false, monitor);
    }

    public IStatus popular(IProgressMonitor monitor) {
        return this.performDiscovery((strategy, monitor1) -> strategy.popular(monitor1), false, monitor);
    }

    public IStatus featured(IProgressMonitor monitor, IMarket market, ICategory category) {
        return this.performDiscovery((strategy, monitor1) -> strategy.featured(monitor1, market, category), false, monitor);
    }

    public IStatus installed(IProgressMonitor monitor) {
        return this.performDiscovery((strategy, monitor1) -> strategy.installed(monitor1), false, monitor);
    }

    public IStatus userFavorites(boolean login, IProgressMonitor monitor) {
        return this.performDiscovery((strategy, monitor1) -> strategy.userFavorites(login, monitor1), false, monitor);
    }

    public IStatus refreshUserFavorites(IProgressMonitor monitor) {
        return this.performDiscovery((strategy, monitor1) -> strategy.refreshUserFavorites(monitor1), true, monitor);
    }

    public IStatus performQuery(IProgressMonitor monitor, Set<String> nodeIds) {
        return this.performDiscovery((strategy, monitor1) -> strategy.performQuery(monitor1, nodeIds), false, monitor);
    }

    public IStatus performNodeQuery(IProgressMonitor monitor, Set<? extends INode> nodes) {
        return this.performDiscovery((strategy, monitor1) -> strategy.performNodeQuery(monitor1, nodes), false, monitor);
    }

    public IStatus checkForUpdates(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceCatalog_checkingForUpdates, (int)10000000);
        try {
            Map<String, IInstallableUnit> installedIUs = this.calculateInstalledIUs((IProgressMonitor)progress.newChild(100000));
            ArrayList<MarketplaceNodeCatalogItem> updateCheckNeeded = new ArrayList<MarketplaceNodeCatalogItem>();
            List<CatalogItem> updateCheckItems = this.getUpdateCheckItems((IProgressMonitor)progress.newChild(100000));
            ArrayList<MarketplaceNodeCatalogItem> updateableItems = new ArrayList<MarketplaceNodeCatalogItem>();
            for (CatalogItem item : updateCheckItems) {
                MarketplaceNodeCatalogItem catalogItem;
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (!(item instanceof MarketplaceNodeCatalogItem) || !(catalogItem = (MarketplaceNodeCatalogItem)item).isInstalled()) continue;
                if (this.setUpdatesAvailable(installedIUs, catalogItem)) {
                    updateCheckNeeded.add(catalogItem);
                    continue;
                }
                if (!Boolean.TRUE.equals(catalogItem.getUpdateAvailable())) continue;
                updateableItems.add(catalogItem);
            }
            if (!updateCheckNeeded.isEmpty()) {
                this.checkForUpdates(updateCheckNeeded, installedIUs, (IProgressMonitor)progress.newChild(9800000));
                for (MarketplaceNodeCatalogItem catalogItem : updateCheckNeeded) {
                    if (!Boolean.TRUE.equals(catalogItem.getUpdateAvailable())) continue;
                    updateableItems.add(catalogItem);
                }
            }
            this.availableUpdates = updateableItems;
            IStatus iStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private List<CatalogItem> getUpdateCheckItems(IProgressMonitor monitor) {
        ArrayList<CatalogItem> updateCheckItems = this.getItems();
        boolean includeInstalled = false;
        for (CatalogCategory category : this.getCategories()) {
            Object marketplaceCategory;
            if (!(category instanceof MarketplaceCategory) || ((MarketplaceCategory)((Object)(marketplaceCategory = (MarketplaceCategory)category))).getContents() != MarketplaceCategory.Contents.FEATURED) continue;
            includeInstalled = true;
            break;
        }
        if (!includeInstalled) {
            return updateCheckItems;
        }
        updateCheckItems = new ArrayList<CatalogItem>(updateCheckItems);
        HashMap<String, CatalogItem> itemsById = new HashMap<String, CatalogItem>();
        for (CatalogItem catalogItem : updateCheckItems) {
            itemsById.put(catalogItem.getId(), catalogItem);
        }
        List discoveryStrategies = this.getDiscoveryStrategies();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(discoveryStrategies.size() * 1000));
        for (AbstractDiscoveryStrategy discoveryStrategy : discoveryStrategies) {
            if (monitor.isCanceled()) break;
            SubMonitor discoveryStrategyProgress = progress.newChild(1000);
            if (discoveryStrategy instanceof MarketplaceDiscoveryStrategy) {
                MarketplaceDiscoveryStrategy marketplaceDiscoveryStrategy = (MarketplaceDiscoveryStrategy)discoveryStrategy;
                try {
                    this.performUpdateCheckDiscovery(marketplaceDiscoveryStrategy, updateCheckItems, itemsById, discoveryStrategyProgress);
                }
                catch (CoreException e) {
                    MarketplaceClientUi.log(1, Messages.MarketplaceCatalog_UpdateCheckDiscoveryError, e);
                }
            }
            discoveryStrategyProgress.setWorkRemaining(0);
        }
        return updateCheckItems;
    }

    private void performUpdateCheckDiscovery(MarketplaceDiscoveryStrategy marketplaceDiscoveryStrategy, List<CatalogItem> updateCheckItems, Map<String, CatalogItem> itemsById, SubMonitor discoveryStrategyProgress) throws CoreException {
        MarketplaceCategory catalogCategory = marketplaceDiscoveryStrategy.findMarketplaceCategory((IProgressMonitor)discoveryStrategyProgress.newChild(1));
        MarketplaceCategory.Contents realContents = catalogCategory.getContents();
        try {
            catalogCategory.setContents(MarketplaceCategory.Contents.INSTALLED);
            SearchResult installed = marketplaceDiscoveryStrategy.computeInstalled((IProgressMonitor)discoveryStrategyProgress.newChild(499));
            List installedNodes = installed.getNodes();
            if (installedNodes == null || installedNodes.isEmpty()) {
                return;
            }
            SubMonitor itemProgress = discoveryStrategyProgress.newChild(500);
            itemProgress.setWorkRemaining(installedNodes.size() * 100);
            for (INode node : installedNodes) {
                CatalogItem item = marketplaceDiscoveryStrategy.createCatalogItem(node, catalogCategory.getId(), false, (IProgressMonitor)itemProgress.newChild(100));
                if (itemsById.containsKey(item.getId())) continue;
                itemsById.put(item.getId(), item);
                updateCheckItems.add(item);
            }
            itemProgress.done();
        }
        finally {
            catalogCategory.setContents(realContents);
        }
    }

    private Map<String, IInstallableUnit> calculateInstalledIUs(IProgressMonitor monitor) {
        HashMap<String, IInstallableUnit> installedIUs = new HashMap<String, IInstallableUnit>();
        List discoveryStrategies = this.getDiscoveryStrategies();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(discoveryStrategies.size() * 1000));
        for (AbstractDiscoveryStrategy discoveryStrategy : discoveryStrategies) {
            if (monitor.isCanceled()) break;
            SubMonitor childProgress = progress.newChild(1000);
            if (discoveryStrategy instanceof MarketplaceDiscoveryStrategy) {
                MarketplaceDiscoveryStrategy marketplaceDiscoveryStrategy = (MarketplaceDiscoveryStrategy)discoveryStrategy;
                Map<String, IInstallableUnit> ius = marketplaceDiscoveryStrategy.computeInstalledIUs((IProgressMonitor)childProgress);
                installedIUs.putAll(ius);
            }
            childProgress.setWorkRemaining(0);
        }
        return installedIUs;
    }

    protected IStatus checkForUpdates(List<MarketplaceNodeCatalogItem> updateCheckNeeded, Map<String, IInstallableUnit> installedIUs, final IProgressMonitor monitor) {
        List<MarketplaceNodeCatalogItem> catalogItemsThisSite;
        URI uri;
        HashMap<URI, ArrayList<MarketplaceNodeCatalogItem>> installedCatalogItemsByUpdateUri = new HashMap<URI, ArrayList<MarketplaceNodeCatalogItem>>();
        for (MarketplaceNodeCatalogItem catalogItem : updateCheckNeeded) {
            INode node = catalogItem.getData();
            String updateurl = node.getUpdateurl();
            try {
                if (updateurl == null) {
                    catalogItem.setAvailable(false);
                    continue;
                }
                uri = new URI(updateurl);
                catalogItemsThisSite = (ArrayList<MarketplaceNodeCatalogItem>)installedCatalogItemsByUpdateUri.get(uri);
                if (catalogItemsThisSite == null) {
                    catalogItemsThisSite = new ArrayList<MarketplaceNodeCatalogItem>();
                    installedCatalogItemsByUpdateUri.put(uri, (ArrayList<MarketplaceNodeCatalogItem>)catalogItemsThisSite);
                }
                catalogItemsThisSite.add(catalogItem);
            }
            catch (URISyntaxException e) {
                MarketplaceClientUi.log(2, Messages.MarketplaceCatalog_InvalidRepositoryUrl, node.getName(), updateurl);
                catalogItem.setAvailable(false);
            }
        }
        if (installedCatalogItemsByUpdateUri.isEmpty()) {
            return Status.OK_STATUS;
        }
        ConcurrentTaskManager executor = new ConcurrentTaskManager(installedCatalogItemsByUpdateUri.size(), Messages.MarketplaceCatalog_checkingForUpdates);
        try {
            NullProgressMonitor pm = new NullProgressMonitor(){

                public boolean isCanceled() {
                    return super.isCanceled() || monitor.isCanceled();
                }
            };
            for (Map.Entry entry : installedCatalogItemsByUpdateUri.entrySet()) {
                uri = (URI)entry.getKey();
                catalogItemsThisSite = (List)entry.getValue();
                executor.submit(() -> this.lambda$11(catalogItemsThisSite, uri, (IProgressMonitor)pm, installedIUs));
            }
            try {
                executor.waitUntilFinished(monitor);
            }
            catch (CoreException e) {
                MarketplaceClientUi.error(e);
                IStatus iStatus = e.getStatus();
                executor.shutdownNow();
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private String createRepositoryIuKey(String uri, String id) {
        return String.valueOf(uri) + "!" + id;
    }

    private boolean setUpdatesAvailable(Map<String, IInstallableUnit> installedIUs, MarketplaceNodeCatalogItem item) {
        boolean needOnlineCheck = false;
        List<MarketplaceNodeInstallableUnitItem> installableUnitItems = item.getInstallableUnitItems();
        for (MarketplaceNodeInstallableUnitItem iuItem : installableUnitItems) {
            String key = this.createRepositoryIuKey(item.getSiteUrl(), iuItem.getId());
            Version availableVersion = this.repositoryIuVersionById.get(key);
            iuItem.setUpdateAvailable(false);
            iuItem.setAvailable(false);
            if (availableVersion != null) {
                iuItem.setAvailable(true);
                IInstallableUnit installedIu = installedIUs.get(iuItem.getId());
                if (installedIu == null || installedIu.getVersion().compareTo((Object)availableVersion) >= 0) continue;
                iuItem.setUpdateAvailable(true);
                continue;
            }
            if (this.repositoryIuVersionById.containsKey(key)) continue;
            needOnlineCheck = true;
        }
        return needOnlineCheck;
    }

    public IStatus performDiscovery(IProgressMonitor monitor) {
        IStatus updateStatus;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)200000);
        IStatus status = super.performDiscovery((IProgressMonitor)progress.newChild(100000));
        if (status.getSeverity() < 4 && !(updateStatus = this.checkForUpdates((IProgressMonitor)progress.newChild(100000))).isOK()) {
            if (status.isOK()) {
                status = updateStatus;
            } else {
                MultiStatus multiStatus = new MultiStatus("org.eclipse.epp.mpc.ui", 0, Messages.MarketplaceCatalog_Discovery_Error, null);
                multiStatus.add(status);
                multiStatus.add(updateStatus);
                status = multiStatus;
            }
        }
        return this.computeStatus(status);
    }

    private IStatus computeStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            Throwable exception;
            IStatus newStatus;
            MultiStatus multiStatus;
            if (status.isMultiStatus() && (multiStatus = (MultiStatus)status).getChildren().length == 1) {
                status = multiStatus.getChildren()[0];
            }
            if (!status.isMultiStatus() && (newStatus = MarketplaceClientCore.computeWellknownProblemStatus((Throwable)(exception = status.getException()))) != null) {
                return newStatus;
            }
        }
        return status;
    }

    protected IStatus performDiscovery(DiscoveryOperation operation, boolean refresh, IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus("org.eclipse.epp.mpc.ui", 0, Messages.MarketplaceCatalog_queryFailed, null);
        if (this.getDiscoveryStrategies().isEmpty()) {
            throw new IllegalStateException();
        }
        ArrayList items = new ArrayList();
        ArrayList categories = new ArrayList(this.getCategories());
        ArrayList certifications = new ArrayList(this.getCertifications());
        ArrayList tags = new ArrayList(this.getTags());
        if (!refresh) {
            for (CatalogCategory catalogCategory : categories) {
                catalogCategory.getItems().clear();
            }
        }
        int totalTicks = 100000;
        int discoveryTicks = 90000;
        monitor.beginTask(Messages.MarketplaceCatalog_queryingMarketplace, 100000);
        try {
            int strategyTicks = 90000 / this.getDiscoveryStrategies().size();
            for (AbstractDiscoveryStrategy discoveryStrategy : this.getDiscoveryStrategies()) {
                Status error;
                List oldTags;
                List oldCertifications;
                List oldItems;
                List oldCategories;
                block16: {
                    Throwable throwable2;
                    block17: {
                        if (monitor.isCanceled()) {
                            status.add(Status.CANCEL_STATUS);
                            break;
                        }
                        if (!(discoveryStrategy instanceof MarketplaceDiscoveryStrategy)) continue;
                        oldCategories = discoveryStrategy.getCategories();
                        oldItems = discoveryStrategy.getItems();
                        oldCertifications = discoveryStrategy.getCertifications();
                        oldTags = discoveryStrategy.getTags();
                        discoveryStrategy.setCategories(categories);
                        discoveryStrategy.setItems(items);
                        discoveryStrategy.setCertifications(certifications);
                        discoveryStrategy.setTags(tags);
                        try {
                            try {
                                MarketplaceDiscoveryStrategy marketplaceStrategy = (MarketplaceDiscoveryStrategy)discoveryStrategy;
                                operation.run(marketplaceStrategy, (IProgressMonitor)new SubProgressMonitor(monitor, strategyTicks));
                                break block16;
                            }
                            catch (CoreException e) {
                                IStatus error2 = MarketplaceClientCore.computeWellknownProblemStatus((Throwable)e);
                                if (error2 == null) {
                                    error2 = new Status(e.getStatus().getSeverity(), "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.MarketplaceCatalog_failedWithError, (Object)discoveryStrategy.getClass().getSimpleName()), (Throwable)e);
                                }
                                status.add(error2);
                                discoveryStrategy.setCategories(oldCategories);
                                discoveryStrategy.setItems(oldItems);
                                discoveryStrategy.setCertifications(oldCertifications);
                                discoveryStrategy.setTags(oldTags);
                                if (!items.contains(null)) continue;
                            }
                        }
                        catch (Throwable throwable2) {
                            discoveryStrategy.setCategories(oldCategories);
                            discoveryStrategy.setItems(oldItems);
                            discoveryStrategy.setCertifications(oldCertifications);
                            discoveryStrategy.setTags(oldTags);
                            if (!items.contains(null)) break block17;
                        }
                        while (items.remove(null)) {
                        }
                        error = new Status(2, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.MarketplaceCatalog_addedNullEntry, (Object)discoveryStrategy.getClass().getSimpleName()));
                        status.add((IStatus)error);
                        continue;
                        while (items.remove(null)) {
                        }
                        error = new Status(2, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.MarketplaceCatalog_addedNullEntry, (Object)discoveryStrategy.getClass().getSimpleName()));
                        status.add((IStatus)error);
                    }
                    throw throwable2;
                }
                discoveryStrategy.setCategories(oldCategories);
                discoveryStrategy.setItems(oldItems);
                discoveryStrategy.setCertifications(oldCertifications);
                discoveryStrategy.setTags(oldTags);
                if (!items.contains(null)) continue;
                while (items.remove(null)) {
                }
                error = new Status(2, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.MarketplaceCatalog_addedNullEntry, (Object)discoveryStrategy.getClass().getSimpleName()));
                status.add((IStatus)error);
            }
            this.update(categories, items, certifications, tags);
        }
        finally {
            monitor.done();
        }
        return this.computeStatus((IStatus)status);
    }

    public IStatus performNewsDiscovery(IProgressMonitor monitor) {
        if (this.getDiscoveryStrategies().isEmpty()) {
            throw new IllegalStateException();
        }
        INews news = null;
        MultiStatus status = new MultiStatus("org.eclipse.epp.mpc.ui", 0, Messages.MarketplaceCatalog_queryFailed, null);
        int totalTicks = 100000;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceCatalog_Checking_News, (int)100000);
        try {
            int strategyTicks = 100000 / this.getDiscoveryStrategies().size();
            for (AbstractDiscoveryStrategy discoveryStrategy : this.getDiscoveryStrategies()) {
                if (monitor.isCanceled()) {
                    status.add(Status.CANCEL_STATUS);
                    break;
                }
                if (!(discoveryStrategy instanceof MarketplaceDiscoveryStrategy)) continue;
                try {
                    MarketplaceDiscoveryStrategy marketplaceStrategy = (MarketplaceDiscoveryStrategy)discoveryStrategy;
                    news = marketplaceStrategy.performNewsDiscovery((IProgressMonitor)progress.newChild(strategyTicks));
                    if (news == null) continue;
                    break;
                }
                catch (CoreException e) {
                    status.add((IStatus)new Status(e.getStatus().getSeverity(), "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.MarketplaceCatalog_failedWithError, (Object)discoveryStrategy.getClass().getSimpleName()), (Throwable)e));
                }
            }
        }
        finally {
            monitor.done();
        }
        if (status.isOK()) {
            this.setNews(news);
        }
        return status;
    }

    public void installErrorReport(IProgressMonitor monitor, IStatus result, Set<CatalogItem> items, IInstallableUnit[] operationIUs, String resolutionDetails) {
        for (AbstractDiscoveryStrategy discoveryStrategy : this.getDiscoveryStrategies()) {
            if (!(discoveryStrategy instanceof MarketplaceDiscoveryStrategy)) continue;
            try {
                ((MarketplaceDiscoveryStrategy)discoveryStrategy).installErrorReport(monitor, result, items, operationIUs, resolutionDetails);
            }
            catch (CoreException e) {
                MarketplaceClientUi.error(e);
            }
        }
    }

    public INews getNews() {
        return this.news;
    }

    public void setNews(INews news) {
        this.news = news;
    }

    public List<IMarket> getMarkets() {
        ArrayList<IMarket> markets = new ArrayList<IMarket>();
        for (CatalogCategory category : this.getCategories()) {
            if (!(category instanceof MarketplaceCategory)) continue;
            MarketplaceCategory marketplaceCategory = (MarketplaceCategory)category;
            for (IMarket iMarket : marketplaceCategory.getMarkets()) {
                if (markets.contains(iMarket)) continue;
                markets.add(iMarket);
            }
        }
        return markets;
    }

    public List<MarketplaceNodeCatalogItem> getAvailableUpdates() {
        return this.availableUpdates;
    }

    public void removeItem(CatalogItem item) {
        this.getItems().remove(item);
        this.getFilteredItems().remove(item);
        this.getAvailableUpdates().remove(item);
        for (CatalogCategory category : this.getCategories()) {
            category.getItems().remove(item);
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$11(List var1_1, URI var2_2, IProgressMonitor var3_3, Map var4_4) {
        block9: {
            session = ProvisioningUI.getDefaultUI().getSession();
            manager = (IMetadataRepositoryManager)session.getProvisioningAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
            try {
                for (MarketplaceNodeCatalogItem item1 : var1_1) {
                    if (!Boolean.TRUE.equals(item1.getAvailable())) continue;
                    item1.setAvailable(null);
                }
                repository = manager.loadRepository(var2_2, var3_3);
                query = QueryUtil.createMatchQuery((String)"id ~= /*.feature.group/ && properties['org.eclipse.equinox.p2.type.group'] == true ", (Object[])new Object[0]);
                result = repository.query(query, var3_3);
                repositoryIuVersionById = new HashMap<String, Version>();
                for (IInstallableUnit iu : result) {
                    key1 = this.createRepositoryIuKey(var2_2.toString(), iu.getId());
                    priorVersion = repositoryIuVersionById.put(key1, version = iu.getVersion());
                    if (priorVersion == null || priorVersion.compareTo((Object)version) <= 0) continue;
                    repositoryIuVersionById.put(key1, priorVersion);
                }
                for (MarketplaceNodeCatalogItem item2 : var1_1) {
                    installableUnitItems = item2.getInstallableUnitItems();
                    for (MarketplaceNodeInstallableUnitItem iuItem : installableUnitItems) {
                        key2 = this.createRepositoryIuKey(var2_2.toString(), iuItem.getId());
                        availableVersion = (Version)repositoryIuVersionById.get(key2);
                        this.repositoryIuVersionById.put(key2, availableVersion);
                        if (availableVersion == null) continue;
                        item2.setAvailable(true);
                    }
                }
                for (MarketplaceNodeCatalogItem item3 : var1_1) {
                    this.setUpdatesAvailable(var4_4, item3);
                }
            }
            catch (ProvisionException e1) {
                errorStatus = new MultiStatus("org.eclipse.epp.mpc.ui", 2, NLS.bind((String)Messages.MarketplaceCatalog_ErrorReadingRepository, (Object)var2_2), (Throwable)e1);
                ** for (item4 : var1_1)
            }
lbl-1000:
            // 1 sources

            {
                item4.setAvailable(false);
                errorStatus.add(MarketplaceClientUi.newStatus(1, item4.getName(), new Object[0]));
                continue;
            }
lbl41:
            // 1 sources

            MarketplaceClientUi.getLog().log((IStatus)errorStatus);
            break block9;
            catch (OperationCanceledException var7_11) {
                // empty catch block
            }
        }
    }

    private static interface DiscoveryOperation {
        public void run(MarketplaceDiscoveryStrategy var1, IProgressMonitor var2) throws CoreException;
    }
}

