/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractUnresolvableReferenceWithNode;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnresolvableConstructorCall
extends AbstractUnresolvableReferenceWithNode
implements IConstructorLinkingCandidate {
    public UnresolvableConstructorCall(XConstructorCall constructorCall, INode node, String text, ExpressionTypeComputationState state) {
        super(constructorCall, node, text, state);
    }

    @Override
    public JvmConstructor getConstructor() {
        throw new UnsupportedOperationException("TODO return some error feature that is compatible to everything");
    }

    @Override
    public boolean isAnonymousClassConstructorCall() {
        return false;
    }

    @Override
    public XConstructorCall getConstructorCall() {
        return (XConstructorCall)this.getExpression();
    }

    @Override
    protected List<XExpression> getArguments() {
        return this.getConstructorCall().getArguments();
    }

    public EReference getReference() {
        return XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR;
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        XConstructorCall constructorCall = this.getConstructorCall();
        EList<JvmTypeReference> typeArguments = constructorCall.getTypeArguments();
        if (typeArguments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (JvmTypeReference typeArgument : typeArguments) {
            result.add(this.getState().getReferenceOwner().toLightweightTypeReference(typeArgument));
        }
        return result;
    }
}

