/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.linking.LinkingScopeProviderBinding;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.IRefactoringDocument;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.JvmModelReferenceUpdater;
import org.eclipse.xtext.xtype.XtypePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseReferenceUpdater
extends JvmModelReferenceUpdater {
    @Inject
    @LinkingScopeProviderBinding
    private IScopeProvider scopeProvider;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private RewritableImportSection.Factory importSectionFactory;
    @Inject
    private ReplaceConverter replaceConverter;

    protected void processReferringResource(Resource referringResource, Iterable<IReferenceDescription> referenceDescriptions, ElementRenameArguments elementRenameArguments, IRefactoringUpdateAcceptor updateAcceptor) {
        Iterable nonImportReferences = Iterables.filter(referenceDescriptions, (Predicate)new Predicate<IReferenceDescription>(){

            public boolean apply(IReferenceDescription input) {
                return !XbaseReferenceUpdater.this.isImportTypeReference(input);
            }
        });
        RewritableImportSection importSection = this.importSectionFactory.parse((XtextResource)referringResource);
        ImportAwareUpdateAcceptor importAwareUpdateAcceptor = this.createUpdateAcceptor(updateAcceptor, importSection);
        super.processReferringResource(referringResource, nonImportReferences, elementRenameArguments, (IRefactoringUpdateAcceptor)importAwareUpdateAcceptor);
        List importChanges = importSection.rewrite();
        TextEdit importChangeEdit = this.replaceConverter.convertToTextEdit(importChanges);
        if (importChangeEdit != null) {
            updateAcceptor.accept(referringResource.getURI(), importChangeEdit);
        }
    }

    protected ImportAwareUpdateAcceptor createUpdateAcceptor(IRefactoringUpdateAcceptor updateAcceptor, RewritableImportSection importSection) {
        return new ImportAwareUpdateAcceptor(updateAcceptor, importSection);
    }

    protected boolean isImportTypeReference(IReferenceDescription input) {
        return input.getEReference() == XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE;
    }

    protected void createTextChange(ITextRegion referenceTextRegion, String newReferenceText, EObject referringElement, EObject newTargetElement, EReference reference, URI referringResourceURI, IRefactoringUpdateAcceptor updateAcceptor) {
        Pair<JvmDeclaredType, QualifiedName> importedTypeAndRelativeName;
        boolean isStaticFeatureCall;
        if (newReferenceText != null && updateAcceptor instanceof ImportAwareUpdateAcceptor && newTargetElement instanceof JvmMember && !this.isImplicitVariable(newTargetElement, reference, newReferenceText) && (!(isStaticFeatureCall = this.isStaticFeatureCall(referringElement, reference, newTargetElement)) || ((XFeatureCall)referringElement).getDeclaringType() == null) && (importedTypeAndRelativeName = this.getImportedTypeAndRelativeName((JvmMember)newTargetElement, ((ImportAwareUpdateAcceptor)updateAcceptor).getImportSection())) != null) {
            JvmDeclaredType importedType = (JvmDeclaredType)importedTypeAndRelativeName.getFirst();
            QualifiedName importRelativeName = (QualifiedName)importedTypeAndRelativeName.getSecond();
            boolean isStaticExtensionFeatureCall = this.isStaticExtensionFeatureCall(referringElement, reference, newTargetElement);
            IScope scope = this.scopeProvider.getScope(referringElement, reference);
            if (scope != null) {
                ((ImportAwareUpdateAcceptor)updateAcceptor).removeImport(importedType, isStaticFeatureCall, isStaticExtensionFeatureCall);
                IEObjectDescription singleElement = scope.getSingleElement(importRelativeName);
                EObject resolvedSingleElement = null;
                if (singleElement != null) {
                    resolvedSingleElement = EcoreUtil.resolve((EObject)singleElement.getEObjectOrProxy(), (EObject)referringElement);
                }
                if (singleElement == null || resolvedSingleElement == newTargetElement) {
                    if (!Strings.isEmpty((String)importedType.getPackageName())) {
                        ((ImportAwareUpdateAcceptor)updateAcceptor).acceptImport(importedType, isStaticFeatureCall, isStaticExtensionFeatureCall);
                    }
                    newReferenceText = this.getLinkText(importRelativeName, newReferenceText);
                } else if (!isStaticExtensionFeatureCall) {
                    QualifiedName newTargetQualifiedName = this.qualifiedNameProvider.getFullyQualifiedName(newTargetElement);
                    newReferenceText = this.getLinkText(newTargetQualifiedName, newReferenceText);
                }
            }
        }
        super.createTextChange(referenceTextRegion, newReferenceText, referringElement, newTargetElement, reference, referringResourceURI, updateAcceptor);
    }

    protected boolean isImplicitVariable(EObject newTargetElement, EReference reference, String newTargetText) {
        return newTargetElement instanceof JvmDeclaredType && reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
    }

    protected boolean isStaticFeatureCall(EObject referringElement, EReference reference, EObject newTargetElement) {
        return referringElement instanceof XFeatureCall && reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE && newTargetElement instanceof JvmFeature && ((JvmFeature)newTargetElement).isStatic();
    }

    protected boolean isStaticExtensionFeatureCall(EObject referringElement, EReference reference, EObject newTargetElement) {
        return referringElement instanceof XMemberFeatureCall && reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE && newTargetElement instanceof JvmFeature && ((JvmFeature)newTargetElement).isStatic();
    }

    protected Pair<JvmDeclaredType, QualifiedName> getImportedTypeAndRelativeName(JvmMember newTargetElement, RewritableImportSection section) {
        if (newTargetElement instanceof JvmConstructor) {
            return this.getImportedTypeAndRelativeName((JvmMember)newTargetElement.getDeclaringType(), section);
        }
        if (!this.isStaticallyReferrable(newTargetElement)) {
            return null;
        }
        StringBuffer relativeName = new StringBuffer(newTargetElement.getSimpleName());
        JvmMember currentMember = newTargetElement;
        while (currentMember.getDeclaringType() != null && section.getImportedType(currentMember.getSimpleName()) != currentMember) {
            currentMember = currentMember.getDeclaringType();
            relativeName.insert(0, "$");
            relativeName.insert(0, currentMember.getSimpleName());
        }
        return Tuples.create((Object)((JvmDeclaredType)currentMember), (Object)this.qualifiedNameConverter.toQualifiedName(relativeName.toString()));
    }

    protected boolean isStaticallyReferrable(JvmMember newTargetElement) {
        if (newTargetElement instanceof JvmDeclaredType) {
            return true;
        }
        if (newTargetElement instanceof JvmFeature) {
            return ((JvmFeature)newTargetElement).isStatic();
        }
        return false;
    }

    protected String getLinkText(QualifiedName importRelativeName, String newReferenceText) {
        if (newReferenceText.endsWith("::")) {
            return String.valueOf(importRelativeName.toString("::")) + "::";
        }
        return importRelativeName.toString(".");
    }

    public static class ImportAwareUpdateAcceptor
    implements IRefactoringUpdateAcceptor {
        private IRefactoringUpdateAcceptor delegate;
        private RewritableImportSection importSection;

        public ImportAwareUpdateAcceptor(IRefactoringUpdateAcceptor delegate, RewritableImportSection importSection) {
            this.delegate = delegate;
            this.importSection = importSection;
        }

        public void accept(URI resourceURI, TextEdit textEdit) {
            this.delegate.accept(resourceURI, textEdit);
        }

        public void accept(URI resourceURI, Change change) {
            this.delegate.accept(resourceURI, change);
        }

        public StatusWrapper getRefactoringStatus() {
            return this.delegate.getRefactoringStatus();
        }

        public IRefactoringDocument getDocument(URI resourceURI) {
            return this.delegate.getDocument(resourceURI);
        }

        public Change createCompositeChange(String name, IProgressMonitor monitor) {
            return this.delegate.createCompositeChange(name, monitor);
        }

        public boolean acceptImport(JvmDeclaredType type, boolean isStatic, boolean isExtension) {
            if (isExtension) {
                return this.importSection.addStaticExtensionImport(type);
            }
            if (isStatic) {
                return this.importSection.addStaticImport(type);
            }
            return this.importSection.addImport(type);
        }

        public boolean removeImport(JvmDeclaredType type, boolean isStatic, boolean isExtension) {
            if (isExtension) {
                return this.importSection.removeStaticExtensionImport(type);
            }
            if (isStatic) {
                return this.importSection.removeStaticImport(type);
            }
            return this.importSection.removeImport(type);
        }

        public RewritableImportSection getImportSection() {
            return this.importSection;
        }
    }
}

