/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.eclipse.xtext.junit4.internal.Timed;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopwatchRule
implements TestRule {
    private boolean watchAll = false;

    public StopwatchRule() {
    }

    public StopwatchRule(boolean watchAll) {
        this.watchAll = watchAll;
    }

    public void printStopwatchData(Description description, Map<String, Stopwatches.NumbersForTask> data) {
        String property = System.getProperty("stopwatch.file");
        PrintStream out = System.out;
        FileOutputStream outputStream = null;
        if (property != null) {
            try {
                outputStream = new FileOutputStream(new File(property), true);
                out = new PrintStream(outputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            out.println("-------------------------------------------------------------------------------------------------------------------------\n");
            out.println("Test '" + description.getDisplayName() + "' :");
            out.println(this.getStopwatchDataAsReadableString(data));
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getStopwatchDataAsReadableString(Map<String, Stopwatches.NumbersForTask> data) {
        StringBuilder sb = new StringBuilder();
        sb.append("-------------------------------------------------------------------------------------------------------------------------\n");
        for (Map.Entry<String, Stopwatches.NumbersForTask> task : data.entrySet()) {
            sb.append("Task '" + task.getKey() + "' took " + task.getValue().getMilliseconds() + "ms (" + task.getValue().getNumberOfMeasurements() + " measurements).\n");
        }
        sb.append("-------------------------------------------------------------------------------------------------------------------------\n");
        return sb.toString();
    }

    public Statement apply(final Statement base, final Description description) {
        if (!this.watchAll && description.getAnnotation(Timed.class) == null) {
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    Stopwatches.setEnabled((boolean)true);
                    Stopwatches.resetAll();
                    base.evaluate();
                }
                finally {
                    StopwatchRule.this.printStopwatchData(description, Stopwatches.allNumbers());
                    Stopwatches.resetAll();
                    Stopwatches.setEnabled((boolean)false);
                }
            }
        };
    }
}

