/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.scoping.DelegatingScope;
import org.eclipse.xtext.xbase.scoping.LocalVariableScopeContext;
import org.eclipse.xtext.xbase.scoping.XtypeScopeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.DefaultJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IValidatedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureScope;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureScopeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.LocalVarDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.StaticMethodsFeatureForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.XAssignmentDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.XAssignmentSugarDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.XFeatureCallSugarDescriptionProvider;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseScopeProvider
extends XtypeScopeProvider {
    private static final Logger log = Logger.getLogger(XbaseScopeProvider.class);
    public static final QualifiedName THIS = QualifiedName.create((String[])new String[]{"this"});
    @Inject
    protected JvmFeatureScopeProvider jvmFeatureScopeProvider;
    @Inject
    private Provider<DefaultJvmFeatureDescriptionProvider> defaultFeatureDescProvider;
    @Inject
    private Provider<XFeatureCallSugarDescriptionProvider> sugarFeatureDescProvider;
    @Inject
    private Provider<StaticMethodsFeatureForTypeProvider> implicitStaticFeatures;
    @Inject
    private Provider<XAssignmentDescriptionProvider> assignmentFeatureDescProvider;
    @Inject
    private Provider<XAssignmentSugarDescriptionProvider> assignmentSugarFeatureDescProvider;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private IdentifiableSimpleNameProvider featureNameProvider;
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    private TypeReferences typeReferences;

    public void setFeatureNameProvider(IdentifiableSimpleNameProvider featureNameProvider) {
        this.featureNameProvider = featureNameProvider;
    }

    public void setTypeProvider(ITypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    protected ITypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public void setSugarFeatureDescProvider(Provider<XFeatureCallSugarDescriptionProvider> sugarFeatureDescProvider) {
        this.sugarFeatureDescProvider = sugarFeatureDescProvider;
    }

    public void setDefaultFeatureDescProvider(Provider<DefaultJvmFeatureDescriptionProvider> defaultFeatureDescProvider) {
        this.defaultFeatureDescProvider = defaultFeatureDescProvider;
    }

    @Override
    public IScope getScope(EObject context, EReference reference) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("enter getScope(" + context + ", " + reference.getEContainingClass().getName() + "#" + reference.getName() + ")"));
        }
        try {
            if (this.isFeatureCallScope(reference)) {
                if (!(context instanceof XAbstractFeatureCall)) {
                    IScope iScope = IScope.NULLSCOPE;
                    return iScope;
                }
                IScope iScope = this.createFeatureCallScope((XAbstractFeatureCall)context, reference);
                return iScope;
            }
            if (this.isConstructorCallScope(reference)) {
                IScope iScope = this.createConstructorCallScope(context, reference);
                return iScope;
            }
            IScope iScope = super.getScope(context, reference);
            return iScope;
        }
        catch (RuntimeException e) {
            log.error((Object)"error during scoping", (Throwable)e);
            throw e;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("leave getScope(" + context + ", " + reference.getEContainingClass().getName() + "#" + reference.getName() + ")"));
            }
        }
    }

    protected IScope createConstructorCallScope(EObject context, EReference reference) {
        final IScope scope = super.getScope(context, reference);
        return new IScope(){

            public Iterable<IEObjectDescription> getAllElements() {
                Iterable original = scope.getAllElements();
                return this.createFeatureDescriptions(original);
            }

            protected Iterable<IEObjectDescription> createFeatureDescriptions(Iterable<IEObjectDescription> original) {
                Iterable result = Iterables.transform(original, (Function)new Function<IEObjectDescription, IEObjectDescription>(){

                    public IEObjectDescription apply(IEObjectDescription from) {
                        TypeArgumentContext typeArgumentContext = XbaseScopeProvider.this.typeArgumentContextProvider.getReceiverContext(null);
                        JvmConstructor constructor = (JvmConstructor)from.getEObjectOrProxy();
                        return new JvmFeatureDescription(from.getQualifiedName(), (JvmFeature)constructor, typeArgumentContext, constructor.getIdentifier(), true, null, 0);
                    }
                });
                return result;
            }

            public Iterable<IEObjectDescription> getElements(EObject object) {
                Iterable original = scope.getElements(object);
                return this.createFeatureDescriptions(original);
            }

            public Iterable<IEObjectDescription> getElements(QualifiedName name) {
                Iterable original = scope.getElements(name);
                return this.createFeatureDescriptions(original);
            }

            public IEObjectDescription getSingleElement(EObject object) {
                Iterable<IEObjectDescription> elements = this.getElements(object);
                return Iterables.isEmpty(elements) ? null : elements.iterator().next();
            }

            public IEObjectDescription getSingleElement(QualifiedName name) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected boolean isConstructorCallScope(EReference reference) {
        return reference.getEReferenceType() == TypesPackage.Literals.JVM_CONSTRUCTOR;
    }

    public boolean isFeatureCallScope(EReference reference) {
        return reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
    }

    protected IScope createFeatureCallScope(XAbstractFeatureCall call, EReference reference) {
        if (call instanceof XFeatureCall || call instanceof XAssignment && ((XAssignment)call).getAssignable() == null) {
            IScope result = this.createSimpleFeatureCallScope(call, reference, call.eResource(), false, -1);
            return result;
        }
        XExpression syntacticalReceiver = this.getSyntacticalReceiver(call);
        IScope result = this.createFeatureCallScopeForReceiver(call, syntacticalReceiver, reference);
        return result;
    }

    public IScope createSimpleFeatureCallScope(EObject context, EReference reference, Resource resource, boolean includeCurrentBlock, int idx) {
        LocalVariableScopeContext scopeContext;
        XFeatureCall featureCall;
        if (context instanceof XFeatureCall && (featureCall = (XFeatureCall)context).getDeclaringType() != null) {
            JvmParameterizedTypeReference typeReference = this.typeReferences.createTypeRef((JvmType)featureCall.getDeclaringType(), new JvmTypeReference[0]);
            JvmFeatureScope result = this.createFeatureScopeForTypeRef((JvmTypeReference)typeReference, context, this.getContextType(context), null, IScope.NULLSCOPE);
            return result;
        }
        DelegatingScope implicitThis = new DelegatingScope(IScope.NULLSCOPE);
        IScope staticScope = this.createStaticScope(context, resource, (IScope)implicitThis);
        IScope localVariableScope = this.createLocalVarScope(staticScope, scopeContext = this.createLocalVariableScopeContext(context, reference, includeCurrentBlock, idx));
        IScope featureScopeForThis = this.createImplicitFeatureCallScope(context, localVariableScope);
        if (featureScopeForThis != null) {
            implicitThis.setDelegate(featureScopeForThis);
        }
        return localVariableScope;
    }

    protected LocalVariableScopeContext createLocalVariableScopeContext(EObject context, EReference reference, boolean includeCurrentBlock, int idx) {
        return new LocalVariableScopeContext(context, reference, includeCurrentBlock, idx, false);
    }

    protected IScope createStaticScope(EObject context, Resource resource, IScope parent) {
        JvmDeclaredType contextType = this.getContextType(context);
        List<IJvmFeatureDescriptionProvider> descriptionProviders = this.getStaticFeatureDescriptionProviders(resource, contextType);
        return this.jvmFeatureScopeProvider.createFeatureScopeForTypeRef(parent, null, descriptionProviders);
    }

    public IScope createFeatureCallScopeForReceiver(XExpression context, XExpression receiver, EReference reference) {
        if (!this.isFeatureCallScope(reference)) {
            return IScope.NULLSCOPE;
        }
        if (receiver == null || receiver.eIsProxy()) {
            return IScope.NULLSCOPE;
        }
        JvmTypeReference receiverType = this.typeProvider.getType(receiver, true);
        if (receiverType != null) {
            return this.createFeatureScopeForTypeRef(receiverType, context, this.getContextType(context), null, IScope.NULLSCOPE);
        }
        return IScope.NULLSCOPE;
    }

    protected XExpression getSyntacticalReceiver(XAbstractFeatureCall call) {
        if (call instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)call).getMemberCallTarget();
        }
        if (call instanceof XBinaryOperation) {
            return ((XBinaryOperation)call).getLeftOperand();
        }
        if (call instanceof XUnaryOperation) {
            return ((XUnaryOperation)call).getOperand();
        }
        if (call instanceof XAssignment) {
            return ((XAssignment)call).getAssignable();
        }
        return null;
    }

    protected IScope createImplicitFeatureCallScope(EObject call, IScope localVariableScope) {
        EObject implicitReceiver;
        JvmTypeReference implicitReceiverType;
        JvmFeatureScope featureScopeForThis = null;
        IEObjectDescription thisVariable = localVariableScope.getSingleElement(THIS);
        if (thisVariable != null && (implicitReceiverType = this.typeProvider.getTypeForIdentifiable((JvmIdentifiableElement)(implicitReceiver = thisVariable.getEObjectOrProxy()))) != null && implicitReceiver instanceof JvmIdentifiableElement) {
            XFeatureCall receiver = XbaseFactory.eINSTANCE.createXFeatureCall();
            receiver.setFeature((JvmIdentifiableElement)implicitReceiver);
            featureScopeForThis = this.createFeatureScopeForTypeRef(implicitReceiverType, call, this.getContextType(call), receiver, IScope.NULLSCOPE);
        }
        return featureScopeForThis;
    }

    protected JvmDeclaredType getContextType(EObject call) {
        if (call == null) {
            return null;
        }
        return (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)call, JvmDeclaredType.class);
    }

    protected IScope createLocalVarScope(IScope parentScope, LocalVariableScopeContext scopeContext) {
        XBlockExpression block;
        EObject context;
        if (scopeContext == null || scopeContext.context == null) {
            return parentScope;
        }
        if (scopeContext.canSpawnForContainer()) {
            parentScope = this.createLocalVarScope(parentScope, scopeContext.spawnForContainer());
        }
        if ((context = scopeContext.context).eContainer() instanceof XBlockExpression) {
            block = (XBlockExpression)context.eContainer();
            parentScope = this.createLocalVarScopeForBlock(block, block.getExpressions().indexOf((Object)context), scopeContext.referredFromClosure, parentScope);
        }
        if (context.eContainer() instanceof XForLoopExpression && context.eContainingFeature() == XbasePackage.Literals.XFOR_LOOP_EXPRESSION__EACH_EXPRESSION) {
            XForLoopExpression loop = (XForLoopExpression)context.eContainer();
            parentScope = this.createLocalScopeForParameter(loop.getDeclaredParam(), parentScope);
        }
        if (context.eContainer() instanceof XCatchClause) {
            XCatchClause catchClause = (XCatchClause)context.eContainer();
            parentScope = this.createLocalScopeForParameter(catchClause.getDeclaredParam(), parentScope);
        }
        if (context instanceof XClosure) {
            parentScope = this.createLocalVarScopeForClosure((XClosure)context, parentScope);
        }
        if (context instanceof XCasePart) {
            parentScope = this.createLocalVarScopeForTypeGuardedCase((XCasePart)context, parentScope);
        }
        if (context instanceof XSwitchExpression) {
            parentScope = this.createLocalVarScopeForSwitchExpression((XSwitchExpression)context, parentScope);
        }
        if (scopeContext.includeCurrentBlock) {
            if (context instanceof XBlockExpression && !(block = (XBlockExpression)context).getExpressions().isEmpty()) {
                parentScope = this.createLocalVarScopeForBlock(block, scopeContext.idx, scopeContext.referredFromClosure, parentScope);
            }
            if (context instanceof XForLoopExpression) {
                parentScope = this.createLocalScopeForParameter(((XForLoopExpression)context).getDeclaredParam(), parentScope);
            }
            if (context instanceof XCatchClause) {
                parentScope = this.createLocalScopeForParameter(((XCatchClause)context).getDeclaredParam(), parentScope);
            }
        }
        return parentScope;
    }

    protected IScope createLocalVarScopeForSwitchExpression(XSwitchExpression context, IScope parentScope) {
        if (context.getLocalVarName() != null) {
            return new JvmFeatureScope(parentScope, "XSwitchExpression", new LocalVarDescription(QualifiedName.create((String[])new String[]{context.getLocalVarName()}), context));
        }
        return parentScope;
    }

    protected IScope createLocalVarScopeForTypeGuardedCase(XCasePart context, IScope parentScope) {
        JvmTypeReference guard = context.getTypeGuard();
        if (guard == null) {
            return parentScope;
        }
        String varName = this.featureNameProvider.getSimpleName(context);
        if (varName == null) {
            return parentScope;
        }
        return new JvmFeatureScope(parentScope, "XCasePart", new LocalVarDescription(QualifiedName.create((String[])new String[]{varName}), context));
    }

    protected IScope createLocalVarScopeForCatchClause(XCatchClause catchClause, int indexOfContextExpressionInBlock, IScope parentScope) {
        return this.createLocalScopeForParameter(catchClause.getDeclaredParam(), parentScope);
    }

    protected IScope createLocalVarScopeForBlock(XBlockExpression block, int indexOfContextExpressionInBlock, boolean referredFromClosure, IScope parentScope) {
        ArrayList descriptions = Lists.newArrayList();
        int i = 0;
        while (i < indexOfContextExpressionInBlock) {
            XVariableDeclaration varDecl;
            XExpression expression = (XExpression)block.getExpressions().get(i);
            if (expression instanceof XVariableDeclaration && (varDecl = (XVariableDeclaration)expression).getName() != null) {
                IValidatedEObjectDescription desc = this.createLocalVarDescription(varDecl);
                if (referredFromClosure && varDecl.isWriteable()) {
                    desc.setIssueCode("org.eclipse.xtext.xbase.validation.IssueCodes.invalid_mutable_variable_access");
                }
                descriptions.add(desc);
            }
            ++i;
        }
        return new JvmFeatureScope(parentScope, "XBlockExpression", descriptions);
    }

    protected IScope createLocalVarScopeForClosure(XClosure closure, IScope parentScope) {
        ArrayList descriptions = Lists.newArrayList();
        EList<JvmFormalParameter> params = closure.getFormalParameters();
        for (JvmFormalParameter p : params) {
            if (p.getName() == null) continue;
            IValidatedEObjectDescription desc = this.createLocalVarDescription(p);
            descriptions.add(desc);
        }
        return new JvmFeatureScope(parentScope, "XClosure", descriptions);
    }

    protected JvmFeatureScope createFeatureScopeForTypeRef(JvmTypeReference receiverType, EObject expression, JvmDeclaredType currentContext, XExpression implicitReceiver, IScope parent) {
        if (expression instanceof XAssignment) {
            List<IJvmFeatureDescriptionProvider> providers = this.getFeatureDescriptionProvidersForAssignment(receiverType, (XAssignment)expression, currentContext, implicitReceiver);
            return this.jvmFeatureScopeProvider.createFeatureScopeForTypeRef(parent, receiverType, providers);
        }
        List<IJvmFeatureDescriptionProvider> providers = this.getFeatureDescriptionProviders(receiverType, expression, currentContext, implicitReceiver);
        return this.jvmFeatureScopeProvider.createFeatureScopeForTypeRef(parent, receiverType, providers);
    }

    protected List<IJvmFeatureDescriptionProvider> getStaticFeatureDescriptionProviders(Resource context, JvmDeclaredType contextType) {
        StaticMethodsFeatureForTypeProvider staticProvider = this.newImplicitStaticFeaturesProvider();
        staticProvider.setContext(context);
        DefaultJvmFeatureDescriptionProvider provider1 = this.newDefaultFeatureDescProvider();
        XFeatureCallSugarDescriptionProvider provider2 = this.newSugarDescriptionProvider();
        provider1.setContextType(contextType);
        provider1.setFeaturesForTypeProvider(staticProvider);
        provider2.setContextType(contextType);
        provider2.setFeaturesForTypeProvider(staticProvider);
        return Lists.newArrayList((Object[])new IJvmFeatureDescriptionProvider[]{provider1, provider2});
    }

    protected List<IJvmFeatureDescriptionProvider> getFeatureDescriptionProviders(JvmTypeReference type, EObject expression, JvmDeclaredType currentContext, XExpression implicitReceiver) {
        DefaultJvmFeatureDescriptionProvider provider1 = this.newDefaultFeatureDescProvider();
        XFeatureCallSugarDescriptionProvider provider2 = this.newSugarDescriptionProvider();
        StaticMethodsFeatureForTypeProvider staticExtensionsProvider = this.newImplicitStaticFeaturesProvider();
        staticExtensionsProvider.setContext(expression.eResource());
        staticExtensionsProvider.setExtensionProvider(true);
        DefaultJvmFeatureDescriptionProvider provider3 = this.newDefaultFeatureDescProvider();
        provider3.setFeaturesForTypeProvider(staticExtensionsProvider);
        XFeatureCallSugarDescriptionProvider provider4 = this.newSugarDescriptionProvider();
        provider4.setFeaturesForTypeProvider(staticExtensionsProvider);
        provider1.setContextType(currentContext);
        provider1.setImplicitReceiver(implicitReceiver);
        provider2.setContextType(currentContext);
        provider2.setImplicitReceiver(implicitReceiver);
        provider3.setContextType(currentContext);
        provider3.setImplicitReceiver(implicitReceiver);
        provider4.setContextType(currentContext);
        provider4.setImplicitReceiver(implicitReceiver);
        ArrayList result = Lists.newArrayList((Object[])new IJvmFeatureDescriptionProvider[]{provider1, provider2, provider3, provider4});
        return result;
    }

    protected StaticMethodsFeatureForTypeProvider newImplicitStaticFeaturesProvider() {
        return (StaticMethodsFeatureForTypeProvider)this.implicitStaticFeatures.get();
    }

    protected List<IJvmFeatureDescriptionProvider> getFeatureDescriptionProvidersForAssignment(JvmTypeReference type, XAssignment expression, JvmDeclaredType currentContext, XExpression implicitReceiver) {
        XAssignmentDescriptionProvider provider1 = (XAssignmentDescriptionProvider)this.assignmentFeatureDescProvider.get();
        XAssignmentSugarDescriptionProvider provider2 = (XAssignmentSugarDescriptionProvider)this.assignmentSugarFeatureDescProvider.get();
        provider1.setContextType(currentContext);
        provider1.setImplicitReceiver(implicitReceiver);
        provider2.setContextType(currentContext);
        provider2.setImplicitReceiver(implicitReceiver);
        ArrayList result = Lists.newArrayList((Object[])new IJvmFeatureDescriptionProvider[]{provider1, provider2});
        return result;
    }

    protected IScope createLocalScopeForParameter(JvmFormalParameter p, IScope parentScope) {
        return p.getName() != null ? new JvmFeatureScope(parentScope, "JvmFormalParameter", this.createLocalVarDescription(p)) : parentScope;
    }

    protected IValidatedEObjectDescription createLocalVarDescription(JvmFormalParameter p) {
        return new LocalVarDescription(QualifiedName.create((String[])new String[]{p.getName()}), (JvmIdentifiableElement)p);
    }

    protected IValidatedEObjectDescription createLocalVarDescription(XVariableDeclaration varDecl) {
        return new LocalVarDescription(QualifiedName.create((String[])new String[]{varDecl.getName()}), varDecl);
    }

    protected DefaultJvmFeatureDescriptionProvider newDefaultFeatureDescProvider() {
        return (DefaultJvmFeatureDescriptionProvider)this.defaultFeatureDescProvider.get();
    }

    protected XFeatureCallSugarDescriptionProvider newSugarDescriptionProvider() {
        return (XFeatureCallSugarDescriptionProvider)this.sugarFeatureDescProvider.get();
    }
}

