/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.generator;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtext.generator.AbstractStubGeneratingFragment;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.model.FileAccessFactory;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.ManifestAccess;
import org.eclipse.xtext.xtext.generator.model.PluginXmlAccess;
import org.eclipse.xtext.xtext.generator.model.TextFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.XtendFileAccess;
import org.eclipse.xtext.xtext.generator.model.project.IBundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IRuntimeProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;
import org.eclipse.xtext.xtext.generator.xbase.XbaseUsageDetector;

public class GeneratorFragment2
extends AbstractStubGeneratingFragment {
    @Inject
    private CodeConfig codeConfig;
    @Inject
    private FileAccessFactory fileAccessFactory;
    @Inject
    @Extension
    private XtextGeneratorNaming _xtextGeneratorNaming;
    @Inject
    @Extension
    private XbaseUsageDetector _xbaseUsageDetector;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean generateMwe = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean generateJavaMain = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean generateXtendMain = false;

    @Override
    public boolean isGenerateStub() {
        boolean _isGenerateStub;
        boolean _and = false;
        Grammar _grammar = this.getGrammar();
        boolean _inheritsXbase = this._xbaseUsageDetector.inheritsXbase(_grammar);
        boolean _not = !_inheritsXbase;
        _and = !_not ? false : (_isGenerateStub = super.isGenerateStub());
        return _and;
    }

    public boolean isGenerateJavaMain() {
        boolean _and = false;
        Grammar _grammar = this.getGrammar();
        boolean _inheritsXbase = this._xbaseUsageDetector.inheritsXbase(_grammar);
        boolean _not = !_inheritsXbase;
        _and = !_not ? false : this.generateJavaMain;
        return _and;
    }

    public boolean isGenerateXtendMain() {
        boolean _and = false;
        Grammar _grammar = this.getGrammar();
        boolean _inheritsXbase = this._xbaseUsageDetector.inheritsXbase(_grammar);
        boolean _not = !_inheritsXbase;
        _and = !_not ? false : this.generateXtendMain;
        return _and;
    }

    public boolean isGenerateMwe() {
        boolean _and = false;
        Grammar _grammar = this.getGrammar();
        boolean _inheritsXbase = this._xbaseUsageDetector.inheritsXbase(_grammar);
        boolean _not = !_inheritsXbase;
        _and = !_not ? false : this.generateMwe;
        return _and;
    }

    protected TypeReference getGeneratorStub(Grammar grammar) {
        String _runtimeBasePackage = this._xtextGeneratorNaming.getRuntimeBasePackage(grammar);
        String _plus = String.valueOf(_runtimeBasePackage) + ".generator.";
        String _simpleName = GrammarUtil.getSimpleName((Grammar)grammar);
        String _plus_1 = String.valueOf(_plus) + _simpleName;
        String _plus_2 = String.valueOf(_plus_1) + "Generator";
        return new TypeReference(_plus_2);
    }

    protected TypeReference getJavaMain(Grammar grammar) {
        TypeReference _generatorStub = this.getGeneratorStub(grammar);
        String _packageName = _generatorStub.getPackageName();
        String _plus = String.valueOf(_packageName) + ".Main";
        return new TypeReference(_plus);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        boolean _and = false;
        _and = !this.generateJavaMain ? false : this.generateXtendMain;
        if (_and) {
            issues.addWarning("Options 'generateJavaMain' and 'generateXtendMain' are mutually exclusive. Generating Xtend only.", this);
            this.generateJavaMain = false;
        }
    }

    @Override
    public void generate() {
        IXtextProjectConfig _projectConfig_6;
        IBundleProjectConfig _eclipsePlugin_2;
        PluginXmlAccess _pluginXml;
        boolean _tripleNotEquals_3;
        boolean _tripleNotEquals_2;
        boolean _isGenerateMwe;
        boolean _isGenerateXtendMain;
        boolean _isGenerateJavaMain_1;
        boolean _isGenerateJavaMain;
        boolean _isGenerateStub = this.isGenerateStub();
        if (_isGenerateStub) {
            boolean _isGenerateXtendStub;
            boolean _tripleNotEquals;
            GuiceModuleAccess.BindingFactory _bindingFactory = new GuiceModuleAccess.BindingFactory();
            TypeReference _typeRef = TypeReference.typeRef(IGenerator2.class, new TypeReference[0]);
            IXtextGeneratorLanguage _language = this.getLanguage();
            Grammar _grammar = _language.getGrammar();
            TypeReference _generatorStub = this.getGeneratorStub(_grammar);
            GuiceModuleAccess.BindingFactory _addTypeToType = _bindingFactory.addTypeToType(_typeRef, _generatorStub);
            IXtextGeneratorLanguage _language_1 = this.getLanguage();
            GuiceModuleAccess _runtimeGenModule = _language_1.getRuntimeGenModule();
            _addTypeToType.contributeTo(_runtimeGenModule);
            IXtextProjectConfig _projectConfig = this.getProjectConfig();
            IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
            ManifestAccess _manifest = _runtime.getManifest();
            boolean bl = _tripleNotEquals = _manifest != null;
            if (_tripleNotEquals) {
                IXtextProjectConfig _projectConfig_1 = this.getProjectConfig();
                IRuntimeProjectConfig _runtime_1 = _projectConfig_1.getRuntime();
                ManifestAccess _manifest_1 = _runtime_1.getManifest();
                Set<String> _requiredBundles = _manifest_1.getRequiredBundles();
                _requiredBundles.add("org.eclipse.xtext.xbase.lib");
            }
            if (_isGenerateXtendStub = this.isGenerateXtendStub()) {
                this.doGenerateXtendStubFile();
            } else {
                this.doGenerateJavaStubFile();
            }
        }
        boolean _or = false;
        boolean _isGenerateStub_1 = this.isGenerateStub();
        _or = _isGenerateStub_1 ? true : (_isGenerateJavaMain = this.isGenerateJavaMain());
        if (_or) {
            boolean _tripleNotEquals_1;
            IXtextProjectConfig _projectConfig_2 = this.getProjectConfig();
            IRuntimeProjectConfig _runtime_2 = _projectConfig_2.getRuntime();
            ManifestAccess _manifest_2 = _runtime_2.getManifest();
            boolean bl = _tripleNotEquals_1 = _manifest_2 != null;
            if (_tripleNotEquals_1) {
                IXtextProjectConfig _projectConfig_3 = this.getProjectConfig();
                IRuntimeProjectConfig _runtime_3 = _projectConfig_3.getRuntime();
                ManifestAccess _manifest_3 = _runtime_3.getManifest();
                Set<String> _exportedPackages = _manifest_3.getExportedPackages();
                IXtextGeneratorLanguage _language_2 = this.getLanguage();
                Grammar _grammar_1 = _language_2.getGrammar();
                TypeReference _generatorStub_1 = this.getGeneratorStub(_grammar_1);
                String _packageName = _generatorStub_1.getPackageName();
                _exportedPackages.add(_packageName);
            }
        }
        if (_isGenerateJavaMain_1 = this.isGenerateJavaMain()) {
            this.doGenerateJavaMain();
        }
        if (_isGenerateXtendMain = this.isGenerateXtendMain()) {
            this.doGenerateXtendMain();
        }
        if (_isGenerateMwe = this.isGenerateMwe()) {
            this.doGenerateMweFile();
        }
        this.contributeEclipsePluginGuiceBindings();
        IXtextProjectConfig _projectConfig_4 = this.getProjectConfig();
        IBundleProjectConfig _eclipsePlugin = _projectConfig_4.getEclipsePlugin();
        ManifestAccess _manifest_4 = _eclipsePlugin.getManifest();
        boolean bl = _tripleNotEquals_2 = _manifest_4 != null;
        if (_tripleNotEquals_2) {
            IXtextProjectConfig _projectConfig_5 = this.getProjectConfig();
            IBundleProjectConfig _eclipsePlugin_1 = _projectConfig_5.getEclipsePlugin();
            ManifestAccess _manifest_5 = _eclipsePlugin_1.getManifest();
            Set<String> _requiredBundles_1 = _manifest_5.getRequiredBundles();
            _requiredBundles_1.add("org.eclipse.xtext.builder");
        }
        boolean bl2 = _tripleNotEquals_3 = (_pluginXml = (_eclipsePlugin_2 = (_projectConfig_6 = this.getProjectConfig()).getEclipsePlugin()).getPluginXml()) != null;
        if (_tripleNotEquals_3) {
            this.contributeEclipsePluginExtensions();
        }
    }

    protected void contributeEclipsePluginGuiceBindings() {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient expression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                TypeReference _typeRef = TypeReference.typeRef("org.eclipse.core.resources.ResourcesPlugin", new TypeReference[0]);
                _builder.append((Object)_typeRef, "");
                _builder.append((Object)".getWorkspace().getRoot()");
            }
        };
        StringConcatenationClient statement = _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"binder.bind(");
                TypeReference _typeRef = TypeReference.typeRef("org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer", new TypeReference[0]);
                _builder.append((Object)_typeRef, "");
                _builder.append((Object)".class)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)".annotatedWith(");
                _builder.append(Names.class, "\t");
                _builder.append((Object)".named(\"builderPreferenceInitializer\"))");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)".to(");
                TypeReference _typeReference = new TypeReference("org.eclipse.xtext.builder.preferences", "BuilderPreferenceAccess.Initializer");
                _builder.append((Object)_typeReference, "\t");
                _builder.append((Object)".class);");
                _builder.newLineIfNotEmpty();
            }
        };
        GuiceModuleAccess.BindingFactory _bindingFactory = new GuiceModuleAccess.BindingFactory();
        TypeReference _typeRef = TypeReference.typeRef("org.eclipse.xtext.builder.IXtextBuilderParticipant", new TypeReference[0]);
        TypeReference _typeRef_1 = TypeReference.typeRef("org.eclipse.xtext.builder.BuilderParticipant", new TypeReference[0]);
        GuiceModuleAccess.BindingFactory _addTypeToType = _bindingFactory.addTypeToType(_typeRef, _typeRef_1);
        TypeReference _typeRef_2 = TypeReference.typeRef("org.eclipse.core.resources.IWorkspaceRoot", new TypeReference[0]);
        GuiceModuleAccess.BindingFactory _addTypeToInstance = _addTypeToType.addTypeToInstance(_typeRef_2, expression);
        GuiceModuleAccess.BindingFactory _addConfiguredBinding = _addTypeToInstance.addConfiguredBinding("BuilderPreferenceStoreInitializer", statement);
        IXtextGeneratorLanguage _language = this.getLanguage();
        GuiceModuleAccess _eclipsePluginGenModule = _language.getEclipsePluginGenModule();
        _addConfiguredBinding.contributeTo(_eclipsePluginGenModule);
    }

    protected void doGenerateXtendStubFile() {
        Grammar _grammar = this.getGrammar();
        TypeReference _generatorStub = this.getGeneratorStub(_grammar);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Generates code from your model files on save.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* ");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"class ");
                IXtextGeneratorLanguage _language = GeneratorFragment2.this.getLanguage();
                Grammar _grammar = _language.getGrammar();
                TypeReference _generatorStub = GeneratorFragment2.this.getGeneratorStub(_grammar);
                String _simpleName = _generatorStub.getSimpleName();
                _builder.append((Object)_simpleName, "");
                _builder.append((Object)" extends ");
                _builder.append(AbstractGenerator.class, "");
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"override void doGenerate(");
                _builder.append(Resource.class, "\t");
                _builder.append((Object)" resource, ");
                _builder.append(IFileSystemAccess2.class, "\t");
                _builder.append((Object)" fsa, ");
                _builder.append(IGeneratorContext.class, "\t");
                _builder.append((Object)" context) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"//\t\tfsa.generateFile('greetings.txt', 'People to greet: ' + ");
                _builder.newLine();
                _builder.append((Object)"//\t\t\tresource.allContents");
                _builder.newLine();
                _builder.append((Object)"//\t\t\t\t.filter(typeof(Greeting))");
                _builder.newLine();
                _builder.append((Object)"//\t\t\t\t.map[name]");
                _builder.newLine();
                _builder.append((Object)"//\t\t\t\t.join(', '))");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        XtendFileAccess _createXtendFile = this.fileAccessFactory.createXtendFile(_generatorStub, _client);
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
        IXtextGeneratorFileSystemAccess _src = _runtime.getSrc();
        _createXtendFile.writeTo(_src);
    }

    protected void doGenerateJavaStubFile() {
        Grammar _grammar = this.getGrammar();
        TypeReference _generatorStub = this.getGeneratorStub(_grammar);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Generates code from your model files on save.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* ");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"public class ");
                IXtextGeneratorLanguage _language = GeneratorFragment2.this.getLanguage();
                Grammar _grammar = _language.getGrammar();
                TypeReference _generatorStub = GeneratorFragment2.this.getGeneratorStub(_grammar);
                String _simpleName = _generatorStub.getSimpleName();
                _builder.append((Object)_simpleName, "");
                _builder.append((Object)" extends ");
                _builder.append(AbstractGenerator.class, "");
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Override.class, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"public void doGenerate(");
                _builder.append(Resource.class, "\t");
                _builder.append((Object)" resource, ");
                _builder.append(IFileSystemAccess2.class, "\t");
                _builder.append((Object)" fsa, ");
                _builder.append(IGeneratorContext.class, "\t");
                _builder.append((Object)" context) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"//\t\tIterator<Greeting> filtered = Iterators.filter(resource.getAllContents(), Greeting.class);");
                _builder.newLine();
                _builder.append((Object)"//\t\tIterator<String> names = Iterators.transform(filtered, new Function<Greeting, String>() {");
                _builder.newLine();
                _builder.append((Object)"//");
                _builder.newLine();
                _builder.append((Object)"//\t\t\t@");
                _builder.append(Override.class, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"//\t\t\tpublic String apply(Greeting greeting) {");
                _builder.newLine();
                _builder.append((Object)"//\t\t\t\treturn greeting.getName();");
                _builder.newLine();
                _builder.append((Object)"//\t\t\t}");
                _builder.newLine();
                _builder.append((Object)"//\t\t});");
                _builder.newLine();
                _builder.append((Object)"//\t\tfsa.generateFile(\"greetings.txt\", \"People to greet: \" + IteratorExtensions.join(names, \", \"));");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        JavaFileAccess _createJavaFile = this.fileAccessFactory.createJavaFile(_generatorStub, _client);
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
        IXtextGeneratorFileSystemAccess _src = _runtime.getSrc();
        _createJavaFile.writeTo(_src);
    }

    protected void doGenerateJavaMain() {
        Grammar _grammar = this.getGrammar();
        TypeReference _javaMain = this.getJavaMain(_grammar);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"public class Main {");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public static void main(String[] args) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (args.length == 0) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"System.err.println(\"Aborting: no path to EMF resource provided!\");");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append(Injector.class, "\t\t");
                _builder.append((Object)" injector = new ");
                Grammar _grammar = GeneratorFragment2.this.getGrammar();
                TypeReference _runtimeSetup = GeneratorFragment2.this._xtextGeneratorNaming.getRuntimeSetup(_grammar);
                _builder.append((Object)_runtimeSetup, "\t\t");
                _builder.append((Object)"().createInjectorAndDoEMFRegistration();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"Main main = injector.getInstance(Main.class);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"main.runGenerator(args[0]);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(Provider.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ResourceSet.class, "\t");
                _builder.append((Object)"> resourceSetProvider;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(IResourceValidator.class, "\t");
                _builder.append((Object)" validator;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(GeneratorDelegate.class, "\t");
                _builder.append((Object)" generator;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.append((Object)" ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(JavaIoFileSystemAccess.class, "\t");
                _builder.append((Object)" fileAccess;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"protected void runGenerator(String string) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Load the resource");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append(ResourceSet.class, "\t\t");
                _builder.append((Object)" set = resourceSetProvider.get();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append(Resource.class, "\t\t");
                _builder.append((Object)" resource = set.getResource(");
                _builder.append(URI.class, "\t\t");
                _builder.append((Object)".createURI(string), true);");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Validate the resource");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append(List.class, "\t\t");
                _builder.append((Object)"<");
                _builder.append(Issue.class, "\t\t");
                _builder.append((Object)"> list = validator.validate(resource, ");
                _builder.append(CheckMode.class, "\t\t");
                _builder.append((Object)".ALL, ");
                _builder.append(CancelIndicator.class, "\t\t");
                _builder.append((Object)".NullImpl);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (!list.isEmpty()) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"for (");
                _builder.append(Issue.class, "\t\t\t");
                _builder.append((Object)" issue : list) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"System.err.println(issue);");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Configure and start the generator");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"fileAccess.setOutputPath(\"src-gen/\");");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append(GeneratorContext.class, "\t\t");
                _builder.append((Object)" context = new ");
                _builder.append(GeneratorContext.class, "\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"context.setCancelIndicator(");
                _builder.append(CancelIndicator.class, "\t\t");
                _builder.append((Object)".NullImpl);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"generator.generate(resource, fileAccess, context);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"System.out.println(\"Code generation finished.\");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        JavaFileAccess _createJavaFile = this.fileAccessFactory.createJavaFile(_javaMain, _client);
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
        IXtextGeneratorFileSystemAccess _src = _runtime.getSrc();
        _createJavaFile.writeTo(_src);
    }

    protected void doGenerateXtendMain() {
        Grammar _grammar = this.getGrammar();
        TypeReference _javaMain = this.getJavaMain(_grammar);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"class Main {");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"def static main(String[] args) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (args.empty) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"System::err.println('Aborting: no path to EMF resource provided!')");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val injector = new ");
                Grammar _grammar = GeneratorFragment2.this.getGrammar();
                TypeReference _runtimeSetup = GeneratorFragment2.this._xtextGeneratorNaming.getRuntimeSetup(_grammar);
                _builder.append((Object)_runtimeSetup, "\t\t");
                _builder.append((Object)"().createInjectorAndDoEMFRegistration");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val main = injector.getInstance(Main)");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"main.runGenerator(args.get(0))");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.append((Object)" ");
                _builder.append(Provider.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ResourceSet.class, "\t");
                _builder.append((Object)"> resourceSetProvider");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.append((Object)" ");
                _builder.append(IResourceValidator.class, "\t");
                _builder.append((Object)" validator");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.append((Object)" ");
                _builder.append(GeneratorDelegate.class, "\t");
                _builder.append((Object)" generator");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.append((Object)" ");
                _builder.append(JavaIoFileSystemAccess.class, "\t");
                _builder.append((Object)" fileAccess");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"def protected runGenerator(String string) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Load the resource");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val set = resourceSetProvider.get");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val resource = set.getResource(");
                _builder.append(URI.class, "\t\t");
                _builder.append((Object)".createURI(string), true)");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Validate the resource");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val issues = validator.validate(resource, ");
                _builder.append(CheckMode.class, "\t\t");
                _builder.append((Object)".ALL, ");
                _builder.append(CancelIndicator.class, "\t\t");
                _builder.append((Object)".NullImpl)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (!issues.empty) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"issues.forEach[System.err.println(it)]");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Configure and start the generator");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"fileAccess.outputPath = 'src-gen/'");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val context = new ");
                _builder.append(GeneratorContext.class, "\t\t");
                _builder.append((Object)" => [");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"cancelIndicator = ");
                _builder.append(CancelIndicator.class, "\t\t\t");
                _builder.append((Object)".NullImpl");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"]");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"generator.generate(resource, fileAccess, context)");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"System.out.println('Code generation finished.')");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        XtendFileAccess _createXtendFile = this.fileAccessFactory.createXtendFile(_javaMain, _client);
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
        IXtextGeneratorFileSystemAccess _src = _runtime.getSrc();
        _createXtendFile.writeTo(_src);
    }

    protected void doGenerateMweFile() {
        IXtextGeneratorLanguage _language = this.getLanguage();
        Grammar _grammar = _language.getGrammar();
        TypeReference _generatorStub = this.getGeneratorStub(_grammar);
        String _path = _generatorStub.getPath();
        String _plus = String.valueOf(_path) + "MWE.mwe2";
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _fileHeader = GeneratorFragment2.this.codeConfig.getFileHeader();
                _builder.append((Object)_fileHeader, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"module ");
                IXtextGeneratorLanguage _language = GeneratorFragment2.this.getLanguage();
                Grammar _grammar = _language.getGrammar();
                TypeReference _generatorStub = GeneratorFragment2.this.getGeneratorStub(_grammar);
                String _name = _generatorStub.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"MWE");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"import org.eclipse.emf.mwe.utils.*");
                _builder.newLine();
                _builder.append((Object)"import ");
                Grammar _grammar_1 = GeneratorFragment2.this.getGrammar();
                TypeReference _runtimeSetup = GeneratorFragment2.this._xtextGeneratorNaming.getRuntimeSetup(_grammar_1);
                String _packageName = _runtimeSetup.getPackageName();
                _builder.append((Object)_packageName, "");
                _builder.append((Object)".*");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"var targetDir");
                _builder.newLine();
                _builder.append((Object)"var modelPath");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"Workflow {");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"component = org.eclipse.xtext.mwe.Reader {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// lookup all resources on the classpath");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// useJavaClassPath = true");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// or define search scope explicitly");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"path = modelPath");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// this class will be generated by the xtext generator ");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"register = ");
                Grammar _grammar_2 = GeneratorFragment2.this.getGrammar();
                TypeReference _runtimeSetup_1 = GeneratorFragment2.this._xtextGeneratorNaming.getRuntimeSetup(_grammar_2);
                String _simpleName = _runtimeSetup_1.getSimpleName();
                _builder.append((Object)_simpleName, "\t\t");
                _builder.append((Object)" {}");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"loadResource = {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"slot = \"model\"");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"component = org.eclipse.xtext.generator.GeneratorComponent {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"register = ");
                Grammar _grammar_3 = GeneratorFragment2.this.getGrammar();
                TypeReference _runtimeSetup_2 = GeneratorFragment2.this._xtextGeneratorNaming.getRuntimeSetup(_grammar_3);
                String _simpleName_1 = _runtimeSetup_2.getSimpleName();
                _builder.append((Object)_simpleName_1, "\t\t");
                _builder.append((Object)" {}");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"slot = 'model'");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"outlet = {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"path = targetDir");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        TextFileAccess _createTextFile = this.fileAccessFactory.createTextFile(_plus, _client);
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
        IXtextGeneratorFileSystemAccess _src = _runtime.getSrc();
        _createTextFile.writeTo(_src);
    }

    protected boolean contributeEclipsePluginExtensions() {
        boolean _xblockexpression = false;
        IXtextGeneratorLanguage _language = this.getLanguage();
        Grammar _grammar = _language.getGrammar();
        String name = _grammar.getName();
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IBundleProjectConfig _eclipsePlugin = _projectConfig.getEclipsePlugin();
        PluginXmlAccess _pluginXml = _eclipsePlugin.getPluginXml();
        List<CharSequence> _entries = _pluginXml.getEntries();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<extension point=\"org.eclipse.xtext.builder.participant\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<participant");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"class=\"");
        Grammar _grammar_1 = this.getGrammar();
        TypeReference _eclipsePluginExecutableExtensionFactory = this._xtextGeneratorNaming.getEclipsePluginExecutableExtensionFactory(_grammar_1);
        _builder.append((Object)_eclipsePluginExecutableExtensionFactory, "\t\t");
        _builder.append((Object)":org.eclipse.xtext.builder.IXtextBuilderParticipant\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"fileExtensions=\"");
        IXtextGeneratorLanguage _language_1 = this.getLanguage();
        List<String> _fileExtensions = _language_1.getFileExtensions();
        String _join = IterableExtensions.join(_fileExtensions, (CharSequence)",");
        _builder.append((Object)_join, "\t\t");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</extension>");
        _builder.newLine();
        _builder.append((Object)"<extension point=\"org.eclipse.ui.preferencePages\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<page");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"category=\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"class=\"");
        Grammar _grammar_2 = this.getGrammar();
        TypeReference _eclipsePluginExecutableExtensionFactory_1 = this._xtextGeneratorNaming.getEclipsePluginExecutableExtensionFactory(_grammar_2);
        _builder.append((Object)_eclipsePluginExecutableExtensionFactory_1, "\t\t");
        _builder.append((Object)":org.eclipse.xtext.builder.preferences.BuilderPreferencePage\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"id=\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)".compiler.preferencePage\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"name=\"Compiler\">");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<keywordReference id=\"");
        IXtextGeneratorLanguage _language_2 = this.getLanguage();
        Grammar _grammar_3 = _language_2.getGrammar();
        String _namespace = GrammarUtil.getNamespace((Grammar)_grammar_3);
        String _plus = String.valueOf(_namespace) + ".ui.keyword_";
        IXtextGeneratorLanguage _language_3 = this.getLanguage();
        Grammar _grammar_4 = _language_3.getGrammar();
        String _simpleName = GrammarUtil.getSimpleName((Grammar)_grammar_4);
        String _plus_1 = String.valueOf(_plus) + _simpleName;
        _builder.append((Object)_plus_1, "\t\t");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"</page>");
        _builder.newLine();
        _builder.append((Object)"</extension>");
        _builder.newLine();
        _builder.append((Object)"<extension point=\"org.eclipse.ui.propertyPages\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<page");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"category=\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"class=\"");
        Grammar _grammar_5 = this.getGrammar();
        TypeReference _eclipsePluginExecutableExtensionFactory_2 = this._xtextGeneratorNaming.getEclipsePluginExecutableExtensionFactory(_grammar_5);
        _builder.append((Object)_eclipsePluginExecutableExtensionFactory_2, "\t\t");
        _builder.append((Object)":org.eclipse.xtext.builder.preferences.BuilderPreferencePage\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"id=\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)".compiler.propertyPage\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"name=\"Compiler\">");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<keywordReference id=\"");
        IXtextGeneratorLanguage _language_4 = this.getLanguage();
        Grammar _grammar_6 = _language_4.getGrammar();
        String _namespace_1 = GrammarUtil.getNamespace((Grammar)_grammar_6);
        String _plus_2 = String.valueOf(_namespace_1) + ".ui.keyword_";
        IXtextGeneratorLanguage _language_5 = this.getLanguage();
        Grammar _grammar_7 = _language_5.getGrammar();
        String _simpleName_1 = GrammarUtil.getSimpleName((Grammar)_grammar_7);
        String _plus_3 = String.valueOf(_plus_2) + _simpleName_1;
        _builder.append((Object)_plus_3, "\t\t");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<enabledWhen>");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"<adapt type=\"org.eclipse.core.resources.IProject\"/>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"</enabledWhen>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<filter name=\"projectNature\" value=\"org.eclipse.xtext.ui.shared.xtextNature\"/>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"</page>");
        _builder.newLine();
        _builder.append((Object)"</extension>");
        _builder.newLine();
        _builder.append((Object)"<extension point=\"org.eclipse.ui.menus\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<menuContribution locationURI=\"popup:#TextEditorContext?after=xtext.ui.openDeclaration\">");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<command");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"commandId=\"org.eclipse.xtext.ui.OpenGeneratedFileCommand\"");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"id=\"");
        _builder.append((Object)name, "\t\t\t");
        _builder.append((Object)".OpenGeneratedCode\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"style=\"push\">");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"<visibleWhen checkEnabled=\"false\">");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"<reference definitionId=\"");
        _builder.append((Object)name, "\t\t\t\t");
        _builder.append((Object)".Editor.opened\" />");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"</visibleWhen>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"</command>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"</menuContribution>");
        _builder.newLine();
        _builder.append((Object)"</extension>");
        _builder.newLine();
        _builder.append((Object)"<extension point=\"org.eclipse.ui.handlers\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<handler");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"class=\"");
        Grammar _grammar_8 = this.getGrammar();
        TypeReference _eclipsePluginExecutableExtensionFactory_3 = this._xtextGeneratorNaming.getEclipsePluginExecutableExtensionFactory(_grammar_8);
        _builder.append((Object)_eclipsePluginExecutableExtensionFactory_3, "\t\t");
        _builder.append((Object)":org.eclipse.xtext.ui.generator.trace.OpenGeneratedFileHandler\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"commandId=\"org.eclipse.xtext.ui.OpenGeneratedFileCommand\">");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<activeWhen>");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"<reference definitionId=\"");
        _builder.append((Object)name, "\t\t\t");
        _builder.append((Object)".Editor.opened\" />");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"</activeWhen>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"</handler>");
        _builder.newLine();
        _builder.append((Object)"</extension>");
        _builder.newLine();
        _xblockexpression = _entries.add(_builder.toString());
        return _xblockexpression;
    }

    public void setGenerateMwe(boolean generateMwe) {
        this.generateMwe = generateMwe;
    }

    public void setGenerateJavaMain(boolean generateJavaMain) {
        this.generateJavaMain = generateJavaMain;
    }

    public void setGenerateXtendMain(boolean generateXtendMain) {
        this.generateXtendMain = generateXtendMain;
    }
}

