/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.util;

import com.google.common.base.Objects;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtext.generator.ecore.EMFGeneratorFragment2;

public class GenModelUtil2 {
    public static GenClass getGenClass(EClass cls, ResourceSet resourceSet) {
        GenClassifier _genClassifier = GenModelUtil2.getGenClassifier((EClassifier)cls, resourceSet);
        return (GenClass)_genClassifier;
    }

    public static GenClassifier getGenClassifier(EClassifier cls, ResourceSet resourceSet) {
        EPackage _ePackage = cls.getEPackage();
        GenPackage genPackage = GenModelUtil2.getGenPackage(_ePackage, resourceSet);
        EList _genClassifiers = genPackage.getGenClassifiers();
        for (GenClassifier genCls : _genClassifiers) {
            EClassifier _ecoreClassifier;
            String _name_1;
            String _name = cls.getName();
            boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = (_ecoreClassifier = genCls.getEcoreClassifier()).getName()));
            if (!_equals) continue;
            return genCls;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"No GenClassifier named '");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"' found in GenModel ");
        Resource _eResource = genPackage.eResource();
        URI _uRI = _eResource.getURI();
        _builder.append((Object)_uRI, "");
        throw new RuntimeException(_builder.toString());
    }

    public static GenDataType getGenDataType(EDataType dt, ResourceSet resourceSet) {
        GenClassifier _genClassifier = GenModelUtil2.getGenClassifier((EClassifier)dt, resourceSet);
        return (GenDataType)_genClassifier;
    }

    public static GenEnum getGenEnum(EEnum en, ResourceSet resourceSet) {
        GenClassifier _genClassifier = GenModelUtil2.getGenClassifier((EClassifier)en, resourceSet);
        return (GenEnum)_genClassifier;
    }

    public static GenFeature getGenFeature(EStructuralFeature feature, ResourceSet resourceSet) {
        EClass _eContainingClass = feature.getEContainingClass();
        GenClassifier _genClassifier = GenModelUtil2.getGenClassifier((EClassifier)_eContainingClass, resourceSet);
        GenClass genCls = (GenClass)_genClassifier;
        EList _genFeatures = genCls.getGenFeatures();
        for (GenFeature genFeat : _genFeatures) {
            EStructuralFeature _ecoreFeature;
            String _name_1;
            String _name = feature.getName();
            boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = (_ecoreFeature = genFeat.getEcoreFeature()).getName()));
            if (!_equals) continue;
            return genFeat;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"No GenFeature named '");
        String _name_2 = feature.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"' found in GenClass '");
        _builder.append((Object)genCls, "");
        _builder.append((Object)"' from GenModel");
        Resource _eResource = genCls.eResource();
        URI _uRI = _eResource.getURI();
        _builder.append((Object)_uRI, "");
        throw new RuntimeException(_builder.toString());
    }

    public static GenPackage getGenPackage(EPackage pkg, ResourceSet resourceSet) {
        Resource genModelResource;
        boolean _tripleNotEquals;
        String nsURI = pkg.getNsURI();
        String location = null;
        Resource _eResource = pkg.eResource();
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        boolean bl = _tripleNotEquals = _uRI != null;
        if (_tripleNotEquals) {
            String _string;
            Resource _eResource_1 = pkg.eResource();
            URI _uRI_1 = _eResource_1.getURI();
            location = _string = _uRI_1.toString();
        }
        if ((genModelResource = GenModelUtil2.getGenModelResource(location, nsURI, resourceSet)) != null) {
            EList _contents = genModelResource.getContents();
            for (EObject model : _contents) {
                GenPackage genPkg;
                if (!(model instanceof GenModel) || (genPkg = ((GenModel)model).findGenPackage(pkg)) == null) continue;
                EPackage _ecorePackage = genPkg.getEcorePackage();
                _ecorePackage.getEClassifiers();
                return genPkg;
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"No GenPackage for NsURI ");
            _builder.append((Object)nsURI, "");
            _builder.append((Object)" found in ");
            URI _uRI_2 = genModelResource.getURI();
            _builder.append((Object)_uRI_2, "");
            throw new RuntimeException(_builder.toString());
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"No GenPackage for NsURI ");
        _builder_1.append((Object)nsURI, "");
        _builder_1.append((Object)".");
        throw new RuntimeException(_builder_1.toString());
    }

    public static Resource getGenModelResource(String locationInfo, String nsURI, ResourceSet resourceSet) {
        Map _ePackageNsURIToGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false);
        URI genModelURI = (URI)_ePackageNsURIToGenModelLocationMap.get(nsURI);
        if (genModelURI == null) {
            boolean _not;
            boolean _equals = "http://www.eclipse.org/emf/2002/Ecore".equals(nsURI);
            if (_equals) {
                return null;
            }
            EList _resources = resourceSet.getResources();
            for (Resource res : _resources) {
                EList _contents = res.getContents();
                for (EObject obj : _contents) {
                    if (!(obj instanceof GenModel)) continue;
                    EList _genPackages = ((GenModel)obj).getGenPackages();
                    for (GenPackage genPackage : _genPackages) {
                        String _nSURI = genPackage.getNSURI();
                        boolean _equals_1 = _nSURI.equals(nsURI);
                        if (!_equals_1) continue;
                        return genPackage.eResource();
                    }
                }
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Could not find a GenModel for EPackage '");
            _builder.append((Object)nsURI, "");
            _builder.append((Object)"'");
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)locationInfo);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                _builder.append((Object)" from ");
                _builder.append((Object)locationInfo, "");
            }
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"If the missing GenModel has been generated via ");
            String _simpleName = EMFGeneratorFragment2.class.getSimpleName();
            _builder.append((Object)_simpleName, "");
            _builder.append((Object)", make sure to run it first in the workflow.");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"If you have a *.genmodel-file, make sure to register it via StandaloneSetup.registerGenModelFile(String).");
            _builder.newLine();
            throw new RuntimeException(_builder.toString());
        }
        if (resourceSet == null) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"There is no ResourceSet for EPackage '");
            _builder_1.append((Object)nsURI, "");
            _builder_1.append((Object)"'. Please make sure the EPackage has been loaded from a .ecore file and not from the generated Java file.");
            throw new RuntimeException(_builder_1.toString());
        }
        Resource genModelResource = resourceSet.getResource(genModelURI, true);
        if (genModelResource == null) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)"Error loading GenModel ");
            _builder_2.append((Object)genModelURI, "");
            throw new RuntimeException(_builder_2.toString());
        }
        EList _contents_1 = genModelResource.getContents();
        for (EObject content : _contents_1) {
            if (!(content instanceof GenModel)) continue;
            ((GenModel)content).reconcile();
        }
        return genModelResource;
    }

    public static String getPackageLiteral() {
        return "eINSTANCE";
    }

    public static String getIntLiteral(EClass clazz, EStructuralFeature feature, ResourceSet resourceSet) {
        GenClass _genClass = GenModelUtil2.getGenClass(clazz, resourceSet);
        GenFeature _genFeature = GenModelUtil2.getGenFeature(feature, resourceSet);
        return _genClass.getFeatureID(_genFeature);
    }

    public static String getIntLiteral(EClassifier classifier, ResourceSet resourceSet) {
        GenClassifier _genClassifier = GenModelUtil2.getGenClassifier(classifier, resourceSet);
        return _genClassifier.getClassifierID();
    }

    public static String getTypeLiteral(EClassifier classifier, ResourceSet resourceSet) {
        GenClassifier genClassifier = GenModelUtil2.getGenClassifier(classifier, resourceSet);
        GenPackage _genPackage = genClassifier.getGenPackage();
        boolean _isLiteralsInterface = _genPackage.isLiteralsInterface();
        if (_isLiteralsInterface) {
            String _classifierID = genClassifier.getClassifierID();
            return "Literals." + _classifierID;
        }
        String _classifierAccessorName = genClassifier.getClassifierAccessorName();
        String _plus = "eINSTANCE.get" + _classifierAccessorName;
        return String.valueOf(_plus) + "()";
    }

    public static String getFeatureLiteral(EStructuralFeature feature, ResourceSet resourceSet) {
        GenFeature genFeature = GenModelUtil2.getGenFeature(feature, resourceSet);
        GenPackage _genPackage = genFeature.getGenPackage();
        boolean _isLiteralsInterface = _genPackage.isLiteralsInterface();
        if (_isLiteralsInterface) {
            GenClass _genClass = genFeature.getGenClass();
            String _featureID = _genClass.getFeatureID(genFeature);
            return "Literals." + _featureID;
        }
        String _featureAccessorName = genFeature.getFeatureAccessorName();
        String _plus = "eINSTANCE.get" + _featureAccessorName;
        return String.valueOf(_plus) + "()";
    }

    public static String getJavaTypeName(EClassifier classifier, ResourceSet resourceSet) {
        GenClassifier genClassifier = GenModelUtil2.getGenClassifier(classifier, resourceSet);
        if (genClassifier instanceof GenClass) {
            return ((GenClass)genClassifier).getQualifiedInterfaceName();
        }
        return ((GenDataType)genClassifier).getQualifiedInstanceClassName();
    }

    public static String getGetAccessor(EStructuralFeature feature, ResourceSet resourceSet) {
        GenFeature genFeature = GenModelUtil2.getGenFeature(feature, resourceSet);
        GenClass genClass = genFeature.getGenClass();
        boolean _isMapEntry = genClass.isMapEntry();
        if (_isMapEntry) {
            GenFeature _mapEntryKeyFeature = genClass.getMapEntryKeyFeature();
            boolean _equals = Objects.equal((Object)genFeature, (Object)_mapEntryKeyFeature);
            if (_equals) {
                return "getKey";
            }
            GenFeature _mapEntryValueFeature = genClass.getMapEntryValueFeature();
            boolean _equals_1 = Objects.equal((Object)genFeature, (Object)_mapEntryValueFeature);
            if (_equals_1) {
                return "getValue";
            }
        }
        return genFeature.getGetAccessor();
    }
}

