/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;
import org.osgi.framework.Version;

public class JavaProjectClasspathChangeAnalyzer {
    private static final Logger logger = Logger.getLogger(JavaProjectClasspathChangeAnalyzer.class);
    private static final Version VERSION_3_33_0 = new Version(3, 33, 0);
    private ReflectExtensions reflectExtensions = new ReflectExtensions();
    private static Version installedJdtCoreVersion;

    public Set<IJavaProject> getJavaProjectsWithClasspathChange(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (element instanceof IPackageFragmentRoot) {
            if (this.isRelevantPackageFragmentRootChange(delta)) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                return Collections.singleton(root.getJavaProject());
            }
        } else {
            if (element instanceof IJavaModel) {
                return this.getJavaProjectsWithClasspathChange(delta.getAffectedChildren());
            }
            if (element instanceof IJavaProject) {
                if (this.isClasspathChangeOnProject(delta)) {
                    if (this.isAttachmentChangeOnly(delta)) {
                        return Collections.emptySet();
                    }
                    return Collections.singleton((IJavaProject)element);
                }
                return this.getJavaProjectsWithClasspathChange(delta.getAffectedChildren());
            }
        }
        return Collections.emptySet();
    }

    public boolean isClasspathChangeOnProject(IJavaElementDelta delta) {
        assert (delta.getElement() instanceof IJavaProject);
        return (delta.getFlags() & 0x20000) != 0 || (delta.getFlags() & 0x200000) != 0;
    }

    public boolean isAttachmentChangeOnly(IJavaElementDelta delta) {
        if (!JavaProjectClasspathChangeAnalyzer.isJdtCoreGreaterOrEqual(VERSION_3_33_0)) {
            if (delta.getAffectedChildren().length == 0) {
                return true;
            }
        } else if (delta.getAffectedChildren().length == 0) {
            return false;
        }
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            if (!this.isAttachmentChangeFlagOnly(child)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isJdtCoreGreaterOrEqual(Version version) {
        if (installedJdtCoreVersion == null) {
            installedJdtCoreVersion = JavaCore.getPlugin().getBundle().getVersion();
        }
        return installedJdtCoreVersion.compareTo(version) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Beta
    protected boolean isAttachmentChangeFlagOnly(IJavaElementDelta child) {
        int flags = child.getFlags();
        if (flags == 0) {
            return false;
        }
        int F_CLASSPATH_ATTRIBUTES = 0x800000;
        int allOtherFlags = flags & ~(0x3000 | F_CLASSPATH_ATTRIBUTES);
        if (allOtherFlags != 0) {
            return false;
        }
        if ((flags & F_CLASSPATH_ATTRIBUTES) == 0) return true;
        try {
            Object[] attributeDeltas;
            Object[] objectArray = attributeDeltas = (Object[])this.reflectExtensions.invoke((Object)child, "getClasspathAttributeDeltas", new Object[0]);
            int n = attributeDeltas.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Object attributeDelta = objectArray[n2];
                String name = (String)this.reflectExtensions.invoke(attributeDelta, "getAttributeName", new Object[0]);
                if (!"javadoc_location".equals(name)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (ReflectiveOperationException e) {
            logger.error((Object)"Something went wrong with the reflection code to read classpath attribute deltas", (Throwable)e);
            return false;
        }
    }

    public boolean isRelevantPackageFragmentRootChange(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        assert (element instanceof IPackageFragmentRoot);
        return delta.getKind() == 2 || delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0 || (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 0x40) != 0 || (((IPackageFragmentRoot)element).isExternal() || ((IPackageFragmentRoot)element).isArchive()) && (delta.getFlags() & 0x8001) == delta.getFlags();
    }

    private Set<IJavaProject> getJavaProjectsWithClasspathChange(IJavaElementDelta[] affectedChildren) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        IJavaElementDelta[] iJavaElementDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta delta = iJavaElementDeltaArray[n2];
            set.addAll(this.getJavaProjectsWithClasspathChange(delta));
            ++n2;
        }
        return set;
    }
}

