/*******************************************************************************
 * Copyright (c) 2013, 2020 itemis AG (http://www.itemis.eu) and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.xtext.xbase.compiler;

import org.eclipse.xtext.util.JavaVersion;

/**
 * @author Holger Schill - Initial contribution and API
 * @author Miro Spoenemann
 */
public class GeneratorConfig {
	/**
	 * Whether expressions shall be generated.
	 */
	private boolean generateExpressions = true;

	/**
	 * Whether <code>@SuppressWarnings</code> shall be generated for non-nested
	 * types.
	 */
	private boolean generateSyntheticSuppressWarnings = true;

	/**
	 * Whether <code>@Generated</code> shall be generated for non-nested types.
	 */
	private boolean generateGeneratedAnnotation = false;

	/**
	 * Whether the current time shall be added to <code>@Generated</code>
	 * annotations.
	 */
	private boolean includeDateInGeneratedAnnotation = false;

	/**
	 * The comment that is added to <code>@Generated</code> annotations, also
	 * supports variables:
	 * <ul>
	 * <li><code>${sourcefile}</code></li>
	 * </ul>
	 */
	private String generatedAnnotationComment;

	/**
	 * Version of the Java Source code that's being generated by the compiler.
	 */
	private JavaVersion javaSourceVersion = JavaVersion.JAVA5;

	/**
	 * Copy the values of the given generator configuration.
	 */
	public GeneratorConfig copy(GeneratorConfig other) {
		this.generateExpressions = other.generateExpressions;
		this.generateSyntheticSuppressWarnings = other.generateSyntheticSuppressWarnings;
		this.generateGeneratedAnnotation = other.generateGeneratedAnnotation;
		this.includeDateInGeneratedAnnotation = other.includeDateInGeneratedAnnotation;
		this.generatedAnnotationComment = other.generatedAnnotationComment;
		this.javaSourceVersion = other.javaSourceVersion;
		return this;
	}

	public boolean isGenerateExpressions() {
		return generateExpressions;
	}

	public void setGenerateExpressions(boolean generateExpressions) {
		this.generateExpressions = generateExpressions;
	}

	public boolean isGenerateSyntheticSuppressWarnings() {
		return generateSyntheticSuppressWarnings;
	}

	public void setGenerateSyntheticSuppressWarnings(boolean generateSyntheticSuppressWarnings) {
		this.generateSyntheticSuppressWarnings = generateSyntheticSuppressWarnings;
	}

	public boolean isGenerateGeneratedAnnotation() {
		return generateGeneratedAnnotation;
	}

	public void setGenerateGeneratedAnnotation(boolean generateGeneratedAnnotation) {
		this.generateGeneratedAnnotation = generateGeneratedAnnotation;
	}

	public boolean isIncludeDateInGeneratedAnnotation() {
		return includeDateInGeneratedAnnotation;
	}

	public void setIncludeDateInGeneratedAnnotation(boolean includeDateInGeneratedAnnotation) {
		this.includeDateInGeneratedAnnotation = includeDateInGeneratedAnnotation;
	}

	public String getGeneratedAnnotationComment() {
		return generatedAnnotationComment;
	}

	public void setGeneratedAnnotationComment(String generatedAnnotationComment) {
		this.generatedAnnotationComment = generatedAnnotationComment;
	}

	public JavaVersion getJavaSourceVersion() {
		return javaSourceVersion;
	}

	public void setJavaSourceVersion(JavaVersion javaSourceVersion) {
		this.javaSourceVersion = javaSourceVersion;
	}
}