/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.findReferences;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.findReferences.Declarators;
import org.eclipse.xtend.core.jvmmodel.AnonymousClassUtil;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.imports.StaticallyImportedMemberProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XtypePackage;

public class XtendReferenceFinder
extends ReferenceFinder {
    @Inject
    @Extension
    private StaticallyImportedMemberProvider _staticallyImportedMemberProvider;
    @Inject
    @Extension
    private AnonymousClassUtil _anonymousClassUtil;
    @Inject
    private Declarators declarators;

    public void findReferencesInDescription(TargetURIs targetURIs, IResourceDescription resourceDescription, IReferenceFinder.IResourceAccess resourceAccess, IReferenceFinder.Acceptor acceptor, IProgressMonitor monitor) {
        if (resourceAccess == null) {
            return;
        }
        Set<QualifiedName> names = this.declarators.getDeclaratorData(targetURIs, resourceAccess).getDeclaratorNames();
        boolean _isCanceled = monitor.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        Set importedNames = IterableExtensions.toSet((Iterable)resourceDescription.getImportedNames());
        Functions.Function1 _function = it -> importedNames.contains(it);
        boolean _exists = IterableExtensions.exists(names, (Functions.Function1)_function);
        if (_exists) {
            IUnitOfWork _function_1 = it -> {
                this.findReferences((Predicate)targetURIs, it.getResource(resourceDescription.getURI(), true), acceptor, monitor);
                return null;
            };
            resourceAccess.readOnly(resourceDescription.getURI(), _function_1);
        }
    }

    protected void findLocalReferencesFromElement(Predicate<URI> targetURIs, EObject sourceCandidate, Resource localResource, IReferenceFinder.Acceptor acceptor) {
        boolean _isPackageFragment;
        boolean _matched = false;
        if (sourceCandidate instanceof XAbstractFeatureCall && (_isPackageFragment = ((XAbstractFeatureCall)sourceCandidate).isPackageFragment())) {
            _matched = true;
            return;
        }
        super.findLocalReferencesFromElement(targetURIs, sourceCandidate, localResource, acceptor);
        boolean _matched_1 = false;
        if (sourceCandidate instanceof XImportDeclaration && ((XImportDeclaration)sourceCandidate).isStatic() && !((XImportDeclaration)sourceCandidate).isWildcard()) {
            _matched_1 = true;
            this.addReferenceToFeatureFromStaticImport((XImportDeclaration)sourceCandidate, targetURIs, acceptor);
        }
        if (!_matched_1 && sourceCandidate instanceof XFeatureCall && ((XFeatureCall)sourceCandidate).getActualReceiver() == null && ((XFeatureCall)sourceCandidate).isStatic()) {
            _matched_1 = true;
            this.addReferenceToTypeFromStaticImport((XAbstractFeatureCall)sourceCandidate, targetURIs, acceptor);
        }
        if (!_matched_1 && sourceCandidate instanceof XMemberFeatureCall) {
            _matched_1 = true;
            if (((XMemberFeatureCall)sourceCandidate).isStatic() && !((XMemberFeatureCall)sourceCandidate).isStaticWithDeclaringType()) {
                this.addReferenceToTypeFromStaticImport((XAbstractFeatureCall)sourceCandidate, targetURIs, acceptor);
            }
        }
        if (!_matched_1 && sourceCandidate instanceof AnonymousClass) {
            _matched_1 = true;
            this.addReferencesToSuper((AnonymousClass)sourceCandidate, targetURIs, acceptor);
        }
    }

    protected void addReferencesToSuper(AnonymousClass anonymousClass, Predicate<URI> targetURISet, IReferenceFinder.Acceptor acceptor) {
        JvmConstructor superConstructor;
        XConstructorCall constructorCall = anonymousClass.getConstructorCall();
        JvmGenericType superType = this._anonymousClassUtil.getSuperType(anonymousClass);
        if (superType != null) {
            this.addReferenceIfTarget((EObject)superType, targetURISet, (EObject)constructorCall, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, acceptor);
        }
        if ((superConstructor = this._anonymousClassUtil.getSuperTypeConstructor(anonymousClass)) != null) {
            this.addReferenceIfTarget((EObject)superConstructor, targetURISet, (EObject)constructorCall, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, acceptor);
        }
    }

    protected void addReferenceToFeatureFromStaticImport(XImportDeclaration importDeclaration, Predicate<URI> targetURISet, IReferenceFinder.Acceptor acceptor) {
        Consumer<JvmFeature> _function = it -> this.addReferenceIfTarget((EObject)it, targetURISet, (EObject)importDeclaration, XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE, acceptor);
        this._staticallyImportedMemberProvider.getAllFeatures(importDeclaration).forEach(_function);
    }

    protected void addReferenceToTypeFromStaticImport(XAbstractFeatureCall sourceCandidate, Predicate<URI> targetURISet, IReferenceFinder.Acceptor acceptor) {
        JvmIdentifiableElement feature = sourceCandidate.getFeature();
        if (feature instanceof JvmMember) {
            JvmDeclaredType type = ((JvmMember)feature).getDeclaringType();
            this.addReferenceIfTarget((EObject)type, targetURISet, (EObject)sourceCandidate, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, acceptor);
        }
    }

    protected void addReferenceIfTarget(EObject candidate, Predicate<URI> targetURISet, EObject sourceElement, EReference reference, IReferenceFinder.Acceptor acceptor) {
        URI candidateURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)candidate);
        boolean _apply = targetURISet.apply((Object)candidateURI);
        if (_apply) {
            URI sourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)sourceElement);
            acceptor.accept(sourceElement, sourceURI, reference, -1, candidate, candidateURI);
        }
    }
}

