/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.service;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.util.internal.EmfAdaptable;
import org.eclipse.xtext.xbase.lib.Pure;

@EmfAdaptable
@Accessors
public class AllRulesCache {
    private final Map<String, AbstractRule> allRules = Maps.newHashMap();

    public AllRulesCache(Grammar grammar) {
        List<AbstractRule> _allRules = GrammarUtil.allRules(grammar);
        for (AbstractRule rule : _allRules) {
            if (rule instanceof TerminalRule) {
                this.allRules.put(((TerminalRule)rule).getName().toUpperCase(), rule);
                continue;
            }
            this.allRules.put(rule.getName(), rule);
        }
    }

    public static AllRulesCache findInEmfObject(Notifier emfObject) {
        for (Adapter adapter : emfObject.eAdapters()) {
            if (!(adapter instanceof AllRulesCacheAdapter)) continue;
            return ((AllRulesCacheAdapter)adapter).get();
        }
        return null;
    }

    public static AllRulesCache removeFromEmfObject(Notifier emfObject) {
        EList adapters = emfObject.eAdapters();
        int max = adapters.size();
        for (int i = 0; i < max; ++i) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (!(adapter instanceof AllRulesCacheAdapter)) continue;
            emfObject.eAdapters().remove(i);
            return ((AllRulesCacheAdapter)adapter).get();
        }
        return null;
    }

    public void attachToEmfObject(Notifier emfObject) {
        AllRulesCache result = AllRulesCache.findInEmfObject(emfObject);
        if (result != null) {
            throw new IllegalStateException("The given EMF object already contains an adapter for AllRulesCache");
        }
        AllRulesCacheAdapter adapter = new AllRulesCacheAdapter(this);
        emfObject.eAdapters().add((Object)adapter);
    }

    @Pure
    public Map<String, AbstractRule> getAllRules() {
        return this.allRules;
    }

    public static class AllRulesCacheAdapter
    extends AdapterImpl {
        private AllRulesCache element;

        public AllRulesCacheAdapter(AllRulesCache element) {
            this.element = element;
        }

        public AllRulesCache get() {
            return this.element;
        }

        public boolean isAdapterForType(Object object) {
            return object == AllRulesCache.class;
        }
    }
}

