/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.ResourceStorageLoadable;
import org.eclipse.xtext.resource.persistence.ResourceStorageProviderAdapter;
import org.eclipse.xtext.resource.persistence.ResourceStorageWritable;
import org.eclipse.xtext.resource.persistence.SourceLevelURIsAdapter;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class ResourceStorageFacade
implements IResourceStorageFacade {
    private static final Logger LOG = Logger.getLogger(ResourceStorageFacade.class);
    @Inject
    private IContextualOutputConfigurationProvider outputConfigurationProvider;
    @Inject
    private Provider<AbstractFileSystemAccess2> fileSystemAccessProvider;
    @Accessors
    private boolean storeNodeModel = false;

    @Override
    public boolean shouldLoadFromStorage(StorageAwareResource resource) {
        SourceLevelURIsAdapter adapter = SourceLevelURIsAdapter.findInstalledAdapter(resource.getResourceSet());
        if (adapter == null) {
            return false;
        }
        boolean _contains = adapter.getSourceLevelURIs().contains(resource.getURI());
        if (_contains) {
            return false;
        }
        return this.doesStorageExist(resource);
    }

    @Override
    public ResourceStorageLoadable getOrCreateResourceStorageLoadable(StorageAwareResource resource) {
        try {
            ResourceStorageLoadable inputStream;
            ResourceStorageProviderAdapter stateProvider = (ResourceStorageProviderAdapter)((Object)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resource.getResourceSet().eAdapters(), ResourceStorageProviderAdapter.class)));
            if (stateProvider != null && (inputStream = stateProvider.getResourceStorageLoadable(resource)) != null) {
                return inputStream;
            }
            InputStream _xifexpression = null;
            boolean _exists = resource.getResourceSet().getURIConverter().exists(this.getBinaryStorageURI(resource.getURI()), CollectionLiterals.emptyMap());
            if (_exists) {
                _xifexpression = resource.getResourceSet().getURIConverter().createInputStream(this.getBinaryStorageURI(resource.getURI()));
            } else {
                InputStream _xblockexpression = null;
                AbstractFileSystemAccess2 fsa = this.getFileSystemAccess(resource);
                String outputRelativePath = this.computeOutputPath(resource);
                _xifexpression = _xblockexpression = fsa.readBinaryFile(outputRelativePath);
            }
            InputStream inputStream_1 = _xifexpression;
            return this.createResourceStorageLoadable(inputStream_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void saveResource(StorageAwareResource resource, IFileSystemAccessExtension3 fsa) {
        String path = this.computeOutputPath(resource);
        MyByteArrayOutputStream bout = new MyByteArrayOutputStream();
        ResourceStorageWritable outStream = this.createResourceStorageWritable(bout);
        try {
            outStream.writeResource(resource);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                URI _uRI = resource.getURI();
                String _plus = "Cannot write storage for " + _uRI;
                LOG.warn((Object)_plus, (Throwable)e);
                return;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        byte[] _byteArray = bout.toByteArray();
        int _length = bout.length();
        ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_byteArray, 0, _length);
        fsa.generateFile(path, _byteArrayInputStream);
    }

    @Override
    public ResourceStorageLoadable createResourceStorageLoadable(InputStream in) {
        boolean _isStoreNodeModel = this.isStoreNodeModel();
        return new ResourceStorageLoadable(in, _isStoreNodeModel);
    }

    @Override
    public ResourceStorageWritable createResourceStorageWritable(OutputStream out) {
        boolean _isStoreNodeModel = this.isStoreNodeModel();
        return new ResourceStorageWritable(out, _isStoreNodeModel);
    }

    protected boolean doesStorageExist(StorageAwareResource resource) {
        String outputRelativePath;
        ResourceStorageProviderAdapter stateProvider = (ResourceStorageProviderAdapter)((Object)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resource.getResourceSet().eAdapters(), ResourceStorageProviderAdapter.class)));
        if (stateProvider != null && stateProvider.getResourceStorageLoadable(resource) != null) {
            return true;
        }
        boolean _exists = resource.getResourceSet().getURIConverter().exists(this.getBinaryStorageURI(resource.getURI()), CollectionLiterals.emptyMap());
        if (_exists) {
            return true;
        }
        boolean _isArchive = resource.getURI().isArchive();
        if (_isArchive) {
            return false;
        }
        AbstractFileSystemAccess2 fsa = this.getFileSystemAccess(resource);
        URI uri = fsa.getURI(outputRelativePath = this.computeOutputPath(resource));
        return uri != null && resource.getResourceSet().getURIConverter().exists(uri, null);
    }

    protected AbstractFileSystemAccess2 getFileSystemAccess(StorageAwareResource resource) {
        AbstractFileSystemAccess2 fsa = (AbstractFileSystemAccess2)this.fileSystemAccessProvider.get();
        fsa.setContext((Object)resource);
        Functions.Function1 _function = it -> it.getName();
        fsa.setOutputConfigurations(IterableExtensions.toMap(this.outputConfigurationProvider.getOutputConfigurations((Resource)resource), (Functions.Function1)_function));
        return fsa;
    }

    protected String computeOutputPath(StorageAwareResource resource) {
        URI srcContainerURI = this.getSourceContainerURI(resource);
        URI uri = this.getBinaryStorageURI(resource.getURI());
        String outputRelativePath = uri.deresolve(srcContainerURI, false, false, true).path();
        return outputRelativePath;
    }

    protected URI getSourceContainerURI(StorageAwareResource resource) {
        return resource.getURI().trimSegments(1).appendSegment("");
    }

    @Override
    public boolean hasStorageFor(URI uri) {
        return new ExtensibleURIConverterImpl().exists(this.getBinaryStorageURI(uri), CollectionLiterals.emptyMap());
    }

    protected URI getBinaryStorageURI(URI sourceURI) {
        URI _trimSegments = sourceURI.trimSegments(1);
        String _lastSegment = sourceURI.lastSegment();
        String _plus = "." + _lastSegment;
        String _plus_1 = _plus + "bin";
        return _trimSegments.appendSegment(_plus_1);
    }

    @Pure
    public boolean isStoreNodeModel() {
        return this.storeNodeModel;
    }

    public void setStoreNodeModel(boolean storeNodeModel) {
        this.storeNodeModel = storeNodeModel;
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private MyByteArrayOutputStream() {
        }

        @Override
        public synchronized byte[] toByteArray() {
            return this.buf;
        }

        public int length() {
            return this.count;
        }
    }
}

