/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class PortableURIs {
    public static final String PORTABLE_SCHEME = "portable";
    @Inject
    private IGlobalScopeProvider globalScopeProvider;
    @Inject
    private EPackage.Registry packageRegistry;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;

    public boolean isPortableURIFragment(String uriFragment) {
        return uriFragment.startsWith(PORTABLE_SCHEME);
    }

    public EObject resolve(StorageAwareResource resource, String portableFragment) {
        PortableFragmentDescription desc = this.fromFragmentString(portableFragment);
        EReference mock = EcoreFactory.eINSTANCE.createEReference();
        mock.setEType((EClassifier)desc.descriptionEClass);
        IScope scope = this.globalScopeProvider.getScope((Resource)resource, mock, (Predicate<IEObjectDescription>)Predicates.alwaysTrue());
        IEObjectDescription description = (IEObjectDescription)IterableExtensions.head(scope.getElements(desc.descriptionQualifiedName));
        if (description == null) {
            return null;
        }
        EObject container = EcoreUtil.resolve((EObject)description.getEObjectOrProxy(), (Resource)resource);
        return this.getEObject(container, desc.descriptionRelativeFragment);
    }

    public URI toPortableURI(StorageAwareResource sourceResource, URI targetURI) {
        URI result;
        Resource _resource = sourceResource.getResourceSet().getResource(targetURI.trimFragment(), false);
        EObject _eObject = null;
        if (_resource != null) {
            _eObject = _resource.getEObject(targetURI.fragment());
        }
        EObject to = _eObject;
        boolean _or = false;
        if (to == null) {
            _or = true;
        } else {
            boolean _tripleNotEquals;
            Resource _eResource = to.eResource();
            ResourceSet _resourceSet = null;
            if (_eResource != null) {
                _resourceSet = _eResource.getResourceSet();
            }
            _or = _tripleNotEquals = _resourceSet != null;
        }
        if (_or && (result = this.toPortableURI(sourceResource, to)) != null) {
            return result;
        }
        return null;
    }

    public URI toPortableURI(StorageAwareResource sourceResource, EObject targetObject) {
        if (targetObject == null || targetObject.eIsProxy()) {
            return sourceResource.getURI().appendFragment("UNRESOLVABLE");
        }
        String portableFragment = this.getPortableURIFragment(targetObject);
        if (portableFragment != null) {
            return sourceResource.getURI().appendFragment(portableFragment);
        }
        return null;
    }

    protected String getPortableURIFragment(EObject obj) {
        IResourceDescriptions descriptions = this.resourceDescriptionsProvider.getResourceDescriptions(obj.eResource());
        IResourceDescription desc = descriptions.getResourceDescription(obj.eResource().getURI());
        if (desc == null) {
            return null;
        }
        Functions.Function1 _function = it -> {
            boolean _xblockexpression = false;
            EObject possibleContainer = EcoreUtil.resolve((EObject)it.getEObjectOrProxy(), (Resource)obj.eResource());
            _xblockexpression = Objects.equal((Object)obj, (Object)possibleContainer) || EcoreUtil.isAncestor((EObject)obj, (EObject)possibleContainer);
            return _xblockexpression;
        };
        IEObjectDescription containerDesc = (IEObjectDescription)IterableExtensions.findFirst(desc.getExportedObjects(), (Functions.Function1)_function);
        if (containerDesc != null) {
            PortableFragmentDescription fragmentDescription = this.createPortableFragmentDescription(containerDesc, obj);
            return this.toFragmentString(fragmentDescription);
        }
        return null;
    }

    protected PortableFragmentDescription createPortableFragmentDescription(IEObjectDescription desc, EObject target) {
        EObject possibleContainer = EcoreUtil.resolve((EObject)desc.getEObjectOrProxy(), (EObject)target);
        String fragmentToTarget = this.getFragment(target, possibleContainer);
        EClass _eClass = desc.getEClass();
        QualifiedName _qualifiedName = desc.getQualifiedName();
        return new PortableFragmentDescription(_eClass, _qualifiedName, fragmentToTarget);
    }

    protected String toFragmentString(PortableFragmentDescription desc) {
        String eclassUriAsString = URI.encodeFragment((String)EcoreUtil.getURI((EObject)desc.descriptionEClass).toString(), (boolean)false);
        List<String> segments = desc.descriptionQualifiedName.getSegments();
        String _encodeFragment = URI.encodeFragment((String)IterableExtensions.join(segments, (CharSequence)":"), (boolean)false);
        String uriFragment = "portable#" + eclassUriAsString + "#" + _encodeFragment;
        if (desc.descriptionRelativeFragment != null) {
            String _uriFragment = uriFragment;
            String _encodeFragment_1 = URI.encodeFragment((String)desc.descriptionRelativeFragment, (boolean)false);
            String _plus = "#" + _encodeFragment_1;
            uriFragment = _uriFragment + _plus;
        }
        return uriFragment;
    }

    protected PortableFragmentDescription fromFragmentString(String fragmentString) {
        Iterator segments = Splitter.on((String)"#").split((CharSequence)fragmentString).iterator();
        segments.next();
        URI eClassURI = URI.createURI((String)URI.decode((String)((String)segments.next())));
        EPackage ePackage = this.packageRegistry.getEPackage(eClassURI.trimFragment().toString());
        Resource _eResource = null;
        if (ePackage != null) {
            _eResource = ePackage.eResource();
        }
        EObject _eObject = null;
        if (_eResource != null) {
            _eObject = _eResource.getEObject(eClassURI.fragment());
        }
        EClass eClass = (EClass)_eObject;
        QualifiedName qname = QualifiedName.create(IterableExtensions.toList((Iterable)Splitter.on((String)":").split((CharSequence)URI.decode((String)((String)segments.next())))));
        String _xifexpression = null;
        boolean _hasNext = segments.hasNext();
        if (_hasNext) {
            _xifexpression = URI.decode((String)((String)segments.next()));
        }
        String fragment = _xifexpression;
        EClass _elvis = null;
        _elvis = eClass != null ? eClass : EcorePackage.Literals.EOBJECT;
        return new PortableFragmentDescription(_elvis, qname, fragment);
    }

    public String getFragment(EObject fromContainer, EObject toChild) {
        boolean _equals = Objects.equal((Object)fromContainer, (Object)toChild);
        if (_equals) {
            return null;
        }
        InternalEObject lastChild = (InternalEObject)toChild;
        InternalEObject lastContainer = lastChild.eInternalContainer();
        String result = lastContainer.eURIFragmentSegment(lastChild.eContainingFeature(), (EObject)lastChild);
        while (lastContainer != null && !Objects.equal((Object)fromContainer, (Object)lastContainer)) {
            String _plus_1;
            lastChild = lastContainer;
            if ((lastContainer = lastContainer.eInternalContainer()) == null) {
                throw new IllegalStateException("No more containers for element " + lastChild);
            }
            String _eURIFragmentSegment = lastContainer.eURIFragmentSegment(lastChild.eContainingFeature(), (EObject)lastChild);
            String _plus = _eURIFragmentSegment + "/";
            result = _plus_1 = _plus + result;
        }
        return result;
    }

    public EObject getEObject(EObject from, String toFragment) {
        if (toFragment == null) {
            return from;
        }
        Iterable splitted = Splitter.on((String)"/").split((CharSequence)toFragment);
        Functions.Function2 _function = ($0, $1) -> ((InternalEObject)$0).eObjectForURIFragmentSegment($1);
        return (EObject)IterableExtensions.fold((Iterable)splitted, (Object)from, (Functions.Function2)_function);
    }

    @Data
    public static class PortableFragmentDescription {
        private final EClass descriptionEClass;
        private final QualifiedName descriptionQualifiedName;
        private final String descriptionRelativeFragment;

        public PortableFragmentDescription(EClass descriptionEClass, QualifiedName descriptionQualifiedName, String descriptionRelativeFragment) {
            this.descriptionEClass = descriptionEClass;
            this.descriptionQualifiedName = descriptionQualifiedName;
            this.descriptionRelativeFragment = descriptionRelativeFragment;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.descriptionEClass == null ? 0 : this.descriptionEClass.hashCode());
            result = 31 * result + (this.descriptionQualifiedName == null ? 0 : this.descriptionQualifiedName.hashCode());
            result = 31 * result + (this.descriptionRelativeFragment == null ? 0 : this.descriptionRelativeFragment.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortableFragmentDescription other = (PortableFragmentDescription)obj;
            if (this.descriptionEClass == null ? other.descriptionEClass != null : !this.descriptionEClass.equals(other.descriptionEClass)) {
                return false;
            }
            if (this.descriptionQualifiedName == null ? other.descriptionQualifiedName != null : !this.descriptionQualifiedName.equals(other.descriptionQualifiedName)) {
                return false;
            }
            return !(this.descriptionRelativeFragment == null ? other.descriptionRelativeFragment != null : !this.descriptionRelativeFragment.equals(other.descriptionRelativeFragment));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("descriptionEClass", (Object)this.descriptionEClass);
            b.add("descriptionQualifiedName", (Object)this.descriptionQualifiedName);
            b.add("descriptionRelativeFragment", (Object)this.descriptionRelativeFragment);
            return b.toString();
        }

        @Pure
        public EClass getDescriptionEClass() {
            return this.descriptionEClass;
        }

        @Pure
        public QualifiedName getDescriptionQualifiedName() {
            return this.descriptionQualifiedName;
        }

        @Pure
        public String getDescriptionRelativeFragment() {
            return this.descriptionRelativeFragment;
        }
    }
}

