/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

@Log
public class GuiceModuleAccess {
    private final Set<Binding> bindings = CollectionLiterals.newLinkedHashSet((Object[])new Binding[0]);
    @Accessors
    private TypeReference superClass;
    private static final Logger LOG = Logger.getLogger(GuiceModuleAccess.class);

    public void add(Binding newBinding) {
        boolean _contains = this.bindings.contains(newBinding);
        if (_contains) {
            Iterator<Binding> iterator = this.bindings.iterator();
            boolean found = false;
            while (iterator.hasNext() && !found) {
                Binding oldBinding = iterator.next();
                boolean _equals = Objects.equal((Object)oldBinding, (Object)newBinding);
                if (!_equals) continue;
                if (oldBinding.isFinal) {
                    if (newBinding.isFinal) {
                        throw new IllegalStateException("Conflicting final bindings for '" + oldBinding.key.type + "' from fragments " + oldBinding.contributedBy + " and " + newBinding.contributedBy);
                    }
                    LOG.warn((Object)("Cannot override final binding '" + oldBinding + "'. " + "Ignoring binding from fragment '" + newBinding.contributedBy + "'"));
                } else {
                    LOG.debug((Object)("replacing binding : " + oldBinding));
                    LOG.debug((Object)(" with new binding : " + newBinding));
                    iterator.remove();
                }
                found = true;
            }
        }
        this.bindings.add(newBinding);
    }

    public void addAll(Iterable<Binding> bindings) {
        for (Binding binding : bindings) {
            this.add(binding);
        }
    }

    public Set<Binding> getBindings() {
        return Collections.unmodifiableSet(this.bindings);
    }

    @Pure
    public TypeReference getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(TypeReference superClass) {
        this.superClass = superClass;
    }

    public static class BindingFactory {
        @Accessors
        private final String contributedBy;
        private final Set<Binding> bindings = CollectionLiterals.newLinkedHashSet((Object[])new Binding[0]);

        public BindingFactory() {
            this.contributedBy = new Exception().getStackTrace()[1].getClassName();
        }

        public BindingFactory(String contributedBy) {
            this.contributedBy = contributedBy;
        }

        private void add(BindKey type, BindValue expr) {
            this.add(type, expr, false);
        }

        private void add(BindKey type, BindValue expr, boolean isFinal) {
            Binding _binding = new Binding(type, expr, isFinal, this.contributedBy);
            this.add(_binding);
        }

        private void add(Binding binding) {
            boolean _not;
            boolean _add = this.bindings.add(binding);
            boolean bl = _not = !_add;
            if (_not) {
                throw new IllegalArgumentException("Duplicate binding for " + binding.key + " in " + this.contributedBy);
            }
        }

        private BindKey key(TypeReference type) {
            return new BindKey(null, type, false, false);
        }

        private BindKey key(String name) {
            return new BindKey(name, null, false, false);
        }

        private BindKey eagerSingleton(TypeReference type) {
            return new BindKey(null, type, true, true);
        }

        private BindKey singleton(TypeReference type) {
            return new BindKey(null, type, true, false);
        }

        private BindValue value(TypeReference type) {
            List<Object> _emptyList = Collections.emptyList();
            return new BindValue(null, type, false, _emptyList);
        }

        private BindValue expr(Object expr) {
            List<Object> _emptyList = Collections.emptyList();
            return new BindValue(expr, null, false, _emptyList);
        }

        private BindValue provider(TypeReference type) {
            List<Object> _emptyList = Collections.emptyList();
            return new BindValue(null, type, true, _emptyList);
        }

        private BindValue providerExpr(Object expr) {
            List<Object> _emptyList = Collections.emptyList();
            return new BindValue(expr, null, true, _emptyList);
        }

        private BindValue statements(Object[] statements) {
            return new BindValue(null, null, false, (List)Conversions.doWrapArray((Object)statements));
        }

        public BindingFactory addTypeToInstance(TypeReference type, StringConcatenationClient expression) {
            this.add(this.key(type), this.expr(expression));
            return this;
        }

        public BindingFactory addTypeToProviderInstance(TypeReference type, StringConcatenationClient expression) {
            this.add(this.key(type), this.providerExpr(expression));
            return this;
        }

        public BindingFactory addConfiguredBinding(String name, StringConcatenationClient statement) {
            this.add(this.key(name), this.statements(new Object[]{statement}));
            return this;
        }

        public BindingFactory addTypeToType(TypeReference keyType, TypeReference valueType) {
            this.add(this.key(keyType), this.value(valueType));
            return this;
        }

        public BindingFactory addTypeToTypeSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.singleton(keyType), this.value(valueType));
            return this;
        }

        public BindingFactory addTypeToTypeEagerSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.eagerSingleton(keyType), this.value(valueType));
            return this;
        }

        public BindingFactory addTypeToProvider(TypeReference keyType, TypeReference valueType) {
            this.add(this.key(keyType), this.provider(valueType));
            return this;
        }

        public BindingFactory addTypeToProviderSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.singleton(keyType), this.provider(valueType));
            return this;
        }

        public BindingFactory addTypeToProviderEagerSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.eagerSingleton(keyType), this.provider(valueType));
            return this;
        }

        public BindingFactory addfinalTypeToType(TypeReference keyType, TypeReference valueType) {
            this.add(this.key(keyType), this.value(valueType), true);
            return this;
        }

        public BindingFactory addfinalTypeToTypeSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.singleton(keyType), this.value(valueType), true);
            return this;
        }

        public BindingFactory addfinalTypeToTypeEagerSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.eagerSingleton(keyType), this.value(valueType), true);
            return this;
        }

        public BindingFactory addfinalTypeToProvider(TypeReference keyType, TypeReference valueType) {
            this.add(this.key(keyType), this.provider(valueType), true);
            return this;
        }

        public BindingFactory addfinalTypeToProviderSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.singleton(keyType), this.provider(valueType), true);
            return this;
        }

        public BindingFactory addfinalTypeToProviderEagerSingleton(TypeReference keyType, TypeReference valueType) {
            this.add(this.eagerSingleton(keyType), this.provider(valueType), true);
            return this;
        }

        public void contributeTo(GuiceModuleAccess module) {
            module.addAll(this.bindings);
        }

        @Pure
        public String getContributedBy() {
            return this.contributedBy;
        }
    }

    @Data
    public static class Binding {
        private final BindKey key;
        private final BindValue value;
        private final boolean isFinal;
        private final String contributedBy;

        public boolean equals(Object other) {
            boolean _xifexpression = false;
            _xifexpression = other instanceof Binding ? Objects.equal((Object)this.key, (Object)((Binding)other).key) : false;
            return _xifexpression;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public Binding(BindKey key, BindValue value, boolean isFinal, String contributedBy) {
            this.key = key;
            this.value = value;
            this.isFinal = isFinal;
            this.contributedBy = contributedBy;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("key", (Object)this.key);
            b.add("value", (Object)this.value);
            b.add("isFinal", (Object)this.isFinal);
            b.add("contributedBy", (Object)this.contributedBy);
            return b.toString();
        }

        @Pure
        public BindKey getKey() {
            return this.key;
        }

        @Pure
        public BindValue getValue() {
            return this.value;
        }

        @Pure
        public boolean isFinal() {
            return this.isFinal;
        }

        @Pure
        public String getContributedBy() {
            return this.contributedBy;
        }
    }

    @Data
    public static class BindValue {
        private final Object expression;
        private final TypeReference type;
        private final boolean provider;
        private final List<Object> statements;

        public BindValue(Object expression, TypeReference type, boolean provider, List<Object> statements) {
            this.expression = expression;
            this.type = type;
            this.provider = provider;
            this.statements = statements;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.provider ? 1231 : 1237);
            result = 31 * result + (this.statements == null ? 0 : this.statements.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BindValue other = (BindValue)obj;
            if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            if (other.provider != this.provider) {
                return false;
            }
            return !(this.statements == null ? other.statements != null : !this.statements.equals(other.statements));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("expression", this.expression);
            b.add("type", (Object)this.type);
            b.add("provider", (Object)this.provider);
            b.add("statements", this.statements);
            return b.toString();
        }

        @Pure
        public Object getExpression() {
            return this.expression;
        }

        @Pure
        public TypeReference getType() {
            return this.type;
        }

        @Pure
        public boolean isProvider() {
            return this.provider;
        }

        @Pure
        public List<Object> getStatements() {
            return this.statements;
        }
    }

    @Data
    public static class BindKey {
        private final String name;
        private final TypeReference type;
        private final boolean singleton;
        private final boolean eagerSingleton;

        public boolean equals(Object other) {
            boolean _xifexpression = false;
            _xifexpression = other instanceof BindKey ? Objects.equal((Object)this.name, (Object)((BindKey)other).name) && Objects.equal((Object)this.type, (Object)((BindKey)other).type) : false;
            return _xifexpression;
        }

        public int hashCode() {
            int h = 0;
            if (this.name != null) {
                int _h = h;
                int _hashCode = this.name.hashCode();
                h = _h + _hashCode;
            }
            if (this.type != null) {
                int _h_1 = h;
                int _hashCode_1 = this.type.hashCode();
                h = _h_1 + _hashCode_1;
            }
            return h;
        }

        public BindKey(String name, TypeReference type, boolean singleton, boolean eagerSingleton) {
            this.name = name;
            this.type = type;
            this.singleton = singleton;
            this.eagerSingleton = eagerSingleton;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("name", (Object)this.name);
            b.add("type", (Object)this.type);
            b.add("singleton", (Object)this.singleton);
            b.add("eagerSingleton", (Object)this.eagerSingleton);
            return b.toString();
        }

        @Pure
        public String getName() {
            return this.name;
        }

        @Pure
        public TypeReference getType() {
            return this.type;
        }

        @Pure
        public boolean isSingleton() {
            return this.singleton;
        }

        @Pure
        public boolean isEagerSingleton() {
            return this.eagerSingleton;
        }
    }
}

