/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.smap;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaStratumLineBreakpoint;

public class XbaseLineBreakpoint
extends JavaStratumLineBreakpoint {
    private static final String XBASE_BREAKPOINT = "org.eclipse.xtext.xbase.ui.xbaseLineBreakpointMarker";

    public XbaseLineBreakpoint() {
    }

    public XbaseLineBreakpoint(IResource breakpointResource, String languageShortName, String typePattern, int line, int charStart, int charEnd, Map<String, Object> attributes) throws DebugException {
        super(breakpointResource, languageShortName, null, null, typePattern, line, charStart, charEnd, 0, true, attributes, XBASE_BREAKPOINT);
    }

    protected IJavaProject getJavaProject(IJavaStackFrame stackFrame) {
        IJavaProject javaProject = super.getJavaProject(stackFrame);
        if (javaProject == null) {
            javaProject = this.computeJavaProject(stackFrame);
        }
        return javaProject;
    }

    private IJavaProject computeJavaProject(IJavaStackFrame stackFrame) {
        IJavaProject project;
        Object element;
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = null;
        try {
            String[] sourcePaths;
            IJavaType thisType;
            if (locator instanceof ISourceLookupDirector && !stackFrame.isStatic() && (thisType = stackFrame.getThis().getJavaType()) instanceof IJavaReferenceType && (sourcePaths = ((IJavaReferenceType)thisType).getSourcePaths(null)) != null && sourcePaths.length > 0) {
                sourceElement = ((ISourceLookupDirector)locator).getSourceElement((Object)sourcePaths[0]);
            }
        }
        catch (DebugException e) {
            DebugPlugin.log((Throwable)e);
        }
        if (sourceElement == null) {
            sourceElement = locator.getSourceElement((IStackFrame)stackFrame);
        }
        if (!(sourceElement instanceof IJavaElement) && sourceElement instanceof IAdaptable && (element = ((IAdaptable)sourceElement).getAdapter(IJavaElement.class)) != null) {
            sourceElement = element;
        }
        if (sourceElement instanceof IJavaElement) {
            return ((IJavaElement)sourceElement).getJavaProject();
        }
        if (sourceElement instanceof IResource && (project = JavaCore.create((IProject)((IResource)sourceElement).getProject())).exists()) {
            return project;
        }
        return null;
    }
}

