/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.codebuilder;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.codebuilder.AbstractConstructorBuilder;
import org.eclipse.xtend.ide.codebuilder.AbstractExecutableBuilder;
import org.eclipse.xtend.ide.codebuilder.AbstractMethodBuilder;
import org.eclipse.xtend.ide.codebuilder.AbstractParameterBuilder;
import org.eclipse.xtend.ide.codebuilder.CodeBuilderFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class MemberFromSuperImplementor {
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private CodeBuilderFactory codeBuilderFactory;
    @Inject
    private AnnotationLookup annotationLookup;
    @Inject
    @Extension
    private TypesFactory typesFactory;

    public void appendOverrideFunction(XtendTypeDeclaration overrider, IResolvedOperation overriddenOperation, ISourceAppender appendable) {
        boolean _isValid;
        boolean _isAbstract;
        boolean _not_1;
        boolean _not;
        JvmDeclaredType inferredType = this.associations.getInferredType(overrider);
        AbstractMethodBuilder methodBuilder = this.codeBuilderFactory.createMethodBuilder(inferredType);
        this.initializeExecutableBuilder(methodBuilder, inferredType, (IResolvedExecutable)overriddenOperation);
        methodBuilder.setOverrideFlag(true);
        methodBuilder.setMethodName(overriddenOperation.getDeclaration().getSimpleName());
        methodBuilder.setReturnType(overriddenOperation.getResolvedReturnType());
        boolean _isEmpty = overriddenOperation.getResolvedTypeParameters().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ArrayList typeParameters = CollectionLiterals.newArrayList((Object[])new JvmTypeParameter[0]);
            Procedures.Procedure2 _function = (typeParam, idx) -> {
                JvmTypeParameter newTypeParam = this.typesFactory.createJvmTypeParameter();
                newTypeParam.setName(typeParam.getName());
                Consumer<LightweightTypeReference> _function_1 = it -> {
                    JvmUpperBound upperBound = this.typesFactory.createJvmUpperBound();
                    upperBound.setTypeReference(it.toJavaCompliantTypeReference());
                    EList _constraints = newTypeParam.getConstraints();
                    _constraints.add((Object)upperBound);
                };
                overriddenOperation.getResolvedTypeParameterConstraints(idx.intValue()).forEach(_function_1);
                typeParameters.add(newTypeParam);
            };
            IterableExtensions.forEach((Iterable)overriddenOperation.getResolvedTypeParameters(), (Procedures.Procedure2)_function);
            methodBuilder.setTypeParameters(typeParameters);
        }
        boolean bl2 = _not_1 = !(_isAbstract = overriddenOperation.getDeclaration().isAbstract());
        if (_not_1) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("super.");
            List _resolvedTypeParameters = overriddenOperation.getResolvedTypeParameters();
            boolean _hasElements = false;
            for (JvmTypeParameter typeParam2 : _resolvedTypeParameters) {
                if (!_hasElements) {
                    _hasElements = true;
                    _builder.append("<");
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _simpleName = typeParam2.getSimpleName();
                _builder.append(_simpleName);
            }
            if (_hasElements) {
                _builder.append(">");
            }
            String _simpleName_1 = overriddenOperation.getDeclaration().getSimpleName();
            _builder.append(_simpleName_1);
            _builder.append("(");
            Functions.Function1 _function_1 = it -> it.getSimpleName();
            String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)overriddenOperation.getDeclaration().getParameters(), (Functions.Function1)_function_1), (CharSequence)", ");
            _builder.append(_join);
            _builder.append(")");
            String body = _builder.toString();
            Procedures.Procedure1<? super ISourceAppender> superTypeRef = this.getImplementedInterface(inferredType, overriddenOperation.getDeclaration().getDeclaringType());
            Procedures.Procedure1 _function_2 = it -> {
                if (superTypeRef != null) {
                    superTypeRef.apply(it);
                }
                it.append((CharSequence)body);
            };
            methodBuilder.setBodyGenerator((Procedures.Procedure1<? super ISourceAppender>)_function_2);
        }
        if (_isValid = methodBuilder.isValid()) {
            methodBuilder.build(appendable);
        }
    }

    private Procedures.Procedure1<? super ISourceAppender> getImplementedInterface(JvmDeclaredType subType, JvmDeclaredType superInterface) {
        if (superInterface instanceof JvmGenericType && ((JvmGenericType)superInterface).isInterface()) {
            Functions.Function1 _function = it -> {
                JvmType _type = it.getType();
                return Objects.equal((Object)_type, (Object)superInterface);
            };
            boolean _exists = IterableExtensions.exists((Iterable)subType.getSuperTypes(), (Functions.Function1)_function);
            if (_exists) {
                Procedures.Procedure1 _function_1 = it -> it.append((JvmType)superInterface).append((CharSequence)".");
                return _function_1;
            }
            Functions.Function1 _function_2 = it -> this.isInterface(it.getType());
            Functions.Function1 _function_3 = it -> {
                JvmType _type = it.getType();
                return (JvmDeclaredType)_type;
            };
            Functions.Function1 _function_4 = it -> {
                Procedures.Procedure1<? super ISourceAppender> _implementedInterface = this.getImplementedInterface((JvmDeclaredType)it, superInterface);
                return _implementedInterface != null;
            };
            JvmDeclaredType interfaze = (JvmDeclaredType)IterableExtensions.findFirst((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)subType.getSuperTypes(), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
            if (interfaze != null) {
                Procedures.Procedure1 _function_5 = it -> it.append((JvmType)interfaze).append((CharSequence)".");
                return _function_5;
            }
        }
        return null;
    }

    private boolean isInterface(JvmType type) {
        return type instanceof JvmGenericType && ((JvmGenericType)type).isInterface();
    }

    public void appendConstructorFromSuper(XtendClass overrider, IResolvedConstructor superConstructor, ISourceAppender appendable) {
        JvmGenericType inferredType = this.associations.getInferredType(overrider);
        AbstractConstructorBuilder constructorBuilder = this.codeBuilderFactory.createConstructorBuilder((JvmDeclaredType)inferredType);
        this.initializeExecutableBuilder(constructorBuilder, (JvmDeclaredType)inferredType, (IResolvedExecutable)superConstructor);
        Procedures.Procedure1 _function = it -> {
            boolean _not;
            boolean _isEmpty = superConstructor.getResolvedParameterTypes().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("super(");
                Functions.Function1 _function_1 = it_1 -> it_1.getSimpleName();
                String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)superConstructor.getDeclaration().getParameters(), (Functions.Function1)_function_1), (CharSequence)", ");
                _builder.append(_join);
                _builder.append(")");
                it.append((CharSequence)_builder);
            }
        };
        constructorBuilder.setBodyGenerator((Procedures.Procedure1<? super ISourceAppender>)_function);
        boolean _isValid = constructorBuilder.isValid();
        if (_isValid) {
            constructorBuilder.build(appendable);
        }
    }

    protected void initializeExecutableBuilder(AbstractExecutableBuilder builder, JvmDeclaredType overrider, IResolvedExecutable overridden) {
        JvmExecutable executable = overridden.getDeclaration();
        builder.setContext((EObject)overrider);
        builder.setVisibility(overridden.getDeclaration().getVisibility());
        Procedures.Procedure2 _function = (it, index) -> {
            JvmFormalParameter declaredParameter = (JvmFormalParameter)executable.getParameters().get(index.intValue());
            AbstractParameterBuilder parameterBuilder = builder.newParameterBuilder();
            parameterBuilder.setName(declaredParameter.getSimpleName());
            parameterBuilder.setType((LightweightTypeReference)it);
            JvmAnnotationReference _findAnnotation = this.annotationLookup.findAnnotation((JvmAnnotationTarget)declaredParameter, Extension.class);
            boolean _tripleNotEquals = _findAnnotation != null;
            parameterBuilder.setExtensionFlag(_tripleNotEquals);
        };
        IterableExtensions.forEach((Iterable)overridden.getResolvedParameterTypes(), (Procedures.Procedure2)_function);
        builder.setVarArgsFlag(executable.isVarArgs());
        builder.setExceptions(overridden.getResolvedExceptions());
    }
}

