/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.XtendTypeDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableEnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.services.SourceTypeLookup;
import org.eclipse.xtend.lib.macro.services.TypeLookup;
import org.eclipse.xtend.lib.macro.services.UpstreamTypeLookup;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtype.XtypePackage;

public class TypeLookupImpl
implements TypeLookup,
SourceTypeLookup,
UpstreamTypeLookup {
    @Extension
    private CompilationUnitImpl compilationUnit;

    public TypeLookupImpl(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public MutableAnnotationTypeDeclaration findAnnotationType(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableAnnotationTypeDeclaration _switchResult = null;
        if (type instanceof MutableAnnotationTypeDeclaration) {
            _switchResult = (MutableAnnotationTypeDeclaration)type;
        }
        return _switchResult;
    }

    public MutableClassDeclaration findClass(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableClassDeclaration _switchResult = null;
        if (type instanceof MutableClassDeclaration) {
            _switchResult = (MutableClassDeclaration)type;
        }
        return _switchResult;
    }

    public MutableEnumerationTypeDeclaration findEnumerationType(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableEnumerationTypeDeclaration _switchResult = null;
        if (type instanceof MutableEnumerationTypeDeclaration) {
            _switchResult = (MutableEnumerationTypeDeclaration)type;
        }
        return _switchResult;
    }

    public MutableInterfaceDeclaration findInterface(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableInterfaceDeclaration _switchResult = null;
        if (type instanceof MutableInterfaceDeclaration) {
            _switchResult = (MutableInterfaceDeclaration)type;
        }
        return _switchResult;
    }

    private Type findType(String qualifiedName) {
        Functions.Function1 _function = type -> type.getQualifiedName('.');
        Functions.Function1 _function_1 = type -> Iterables.filter((Iterable)type.getMembers(), JvmDeclaredType.class);
        JvmDeclaredType result = (JvmDeclaredType)this.recursiveFindType(qualifiedName, Iterables.filter((Iterable)this.compilationUnit.getXtendFile().eResource().getContents(), JvmDeclaredType.class), _function, _function_1);
        Type _xifexpression = null;
        if (result != null) {
            _xifexpression = this.compilationUnit.toType((JvmType)result);
        }
        return _xifexpression;
    }

    public ClassDeclaration findSourceClass(String qualifiedName) {
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> type = this.findSourceType(qualifiedName);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _switchResult = null;
        if (type instanceof ClassDeclaration) {
            _switchResult = type;
        }
        return (ClassDeclaration)_switchResult;
    }

    public InterfaceDeclaration findSourceInterface(String qualifiedName) {
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> type = this.findSourceType(qualifiedName);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _switchResult = null;
        if (type instanceof InterfaceDeclaration) {
            _switchResult = type;
        }
        return (InterfaceDeclaration)_switchResult;
    }

    public EnumerationTypeDeclaration findSourceEnumerationType(String qualifiedName) {
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> type = this.findSourceType(qualifiedName);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _switchResult = null;
        if (type instanceof EnumerationTypeDeclaration) {
            _switchResult = type;
        }
        return (EnumerationTypeDeclaration)_switchResult;
    }

    public AnnotationTypeDeclaration findSourceAnnotationType(String qualifiedName) {
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> type = this.findSourceType(qualifiedName);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _switchResult = null;
        if (type instanceof AnnotationTypeDeclaration) {
            _switchResult = type;
        }
        return (AnnotationTypeDeclaration)_switchResult;
    }

    private XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> findSourceType(String qualifiedName) {
        EObject _head = (EObject)IterableExtensions.head((Iterable)this.compilationUnit.getXtendFile().eResource().getContents());
        Functions.Function1 _function = type -> this.compilationUnit.getQualifiedNameConverter().toString(this.compilationUnit.getQualifiedNameProvider().getFullyQualifiedName((EObject)type));
        Functions.Function1 _function_1 = type -> Iterables.filter(type.getMembers(), XtendTypeDeclaration.class);
        XtendTypeDeclaration result = this.recursiveFindType(qualifiedName, (Iterable)((XtendFile)_head).getXtendTypes(), (Functions.Function1)_function, (Functions.Function1)_function_1);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _xifexpression = null;
        if (result != null) {
            _xifexpression = this.compilationUnit.toXtendTypeDeclaration(result);
        }
        return _xifexpression;
    }

    private <T> T recursiveFindType(String qualifiedName, Iterable<? extends T> typeDeclarations, Functions.Function1<? super T, ? extends String> qualifiedNameProvider, Functions.Function1<? super T, ? extends Iterable<? extends T>> subTypeProvider) {
        for (T type : typeDeclarations) {
            String name = (String)qualifiedNameProvider.apply(type);
            boolean _equals = Objects.equal((Object)qualifiedName, (Object)name);
            if (_equals) {
                return type;
            }
            if (!qualifiedName.startsWith(name) || qualifiedName.charAt(name.length()) != '.') continue;
            return this.recursiveFindType(qualifiedName, (Iterable)subTypeProvider.apply(type), qualifiedNameProvider, subTypeProvider);
        }
        return null;
    }

    public Type findTypeGlobally(Class<?> clazz) {
        return this.findTypeGlobally(clazz.getCanonicalName());
    }

    public Type findTypeGlobally(String typeName) {
        Type _elvis = null;
        Type _findType = this.findType(typeName);
        if (_findType != null) {
            _elvis = _findType;
        } else {
            Type _findTypeOnScope;
            Functions.Function1 _function = it -> true;
            _elvis = _findTypeOnScope = this.findTypeOnScope(typeName, (Functions.Function1<? super IEObjectDescription, ? extends Boolean>)_function);
        }
        return _elvis;
    }

    public Type findUpstreamType(Class<?> clazz) {
        return this.findUpstreamType(clazz.getCanonicalName());
    }

    public Type findUpstreamType(String typeName) {
        Functions.Function1 _function = it -> {
            Resource _eResource_1;
            Resource _eResource = it.getEObjectOrProxy().eResource();
            return !Objects.equal((Object)_eResource, (Object)(_eResource_1 = this.compilationUnit.getXtendFile().eResource()));
        };
        return this.findTypeOnScope(typeName, (Functions.Function1<? super IEObjectDescription, ? extends Boolean>)_function);
    }

    private Type findTypeOnScope(String typeName, Functions.Function1<? super IEObjectDescription, ? extends Boolean> filter) {
        QualifiedName qualifiedName = this.compilationUnit.getQualifiedNameConverter().toQualifiedName(typeName);
        IEObjectDescription result = this.compilationUnit.getScopeProvider().getScope((EObject)this.compilationUnit.getXtendFile(), XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE).getSingleElement(qualifiedName);
        if (result != null && TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(result.getEClass()) && ((Boolean)filter.apply((Object)result)).booleanValue()) {
            EObject _eObjectOrProxy = result.getEObjectOrProxy();
            return this.compilationUnit.toType((JvmType)_eObjectOrProxy);
        }
        return null;
    }
}

